--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.OpenAL.AL.Object
-- Copyright   :  (c) Sven Panne 2003
-- License     :  BSD-style (see the file libraries/OpenAL/LICENSE)
-- 
-- Maintainer  :  sven_panne@yahoo.com
-- Stability   :  provisional
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Sound.OpenAL.AL.Object (
   Object, genObjects, deleteObjects, isObject
) where

import Control.Monad ( liftM )
import Data.List ( genericLength )
import Foreign.Marshal.Array ( withArray, peekArray, allocaArray )
import Sound.OpenAL.AL.BasicTypes
import Sound.OpenAL.AL.ObjectInternal
import Sound.OpenAL.AL.ALboolean ( unmarshalALboolean )

--------------------------------------------------------------------------------

genObjects :: Object a => ALsizei -> IO [a]
genObjects numObjects =
   allocaArray (fromIntegral numObjects) $ \buf -> do
      alGenObjects numObjects buf
      peekArray (fromIntegral numObjects) buf

deleteObjects :: Object a => [a] -> IO ()
deleteObjects objects =
   withArray objects $
      alDeleteObjects (genericLength objects)

isObject :: Object a => a -> IO Bool
isObject = liftM unmarshalALboolean . alIsObject
