--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.OpenAL.AL.Source
-- Copyright   :  (c) Sven Panne 2003
-- License     :  BSD-style (see the file libraries/OpenAL/LICENSE)
-- 
-- Maintainer  :  sven_panne@yahoo.com
-- Stability   :  provisional
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Sound.OpenAL.AL.Source (
   Source
) where

import Control.Monad ( liftM )
import Foreign.Storable ( Storable(..) )
import Foreign.Ptr ( Ptr, castPtr )
import Sound.OpenAL.AL.BasicTypes
import Sound.OpenAL.AL.ObjectInternal ( Object(..) )
import Sound.OpenAL.AL.Object ( Object )

--------------------------------------------------------------------------------

newtype Source = Source { sourceID :: ALuint }
   deriving ( Eq, Ord, Show )

instance Storable Source where
   sizeOf    = sizeOf . sourceID
   alignment = alignment . sourceID
   peek      = liftM Source . peek . castPtr
   poke ptr  = poke (castPtr ptr) . sourceID

instance Object Source where
   alGenObjects = alGenSources
   alDeleteObjects = alDeleteSources
   alIsObject = alIsSource

foreign import CALLCONV unsafe "alGenSources"
   alGenSources :: ALsizei -> Ptr Source -> IO ()

foreign import CALLCONV unsafe "alDeleteSources"
   alDeleteSources :: ALsizei -> Ptr Source -> IO ()

foreign import CALLCONV unsafe "alIsSource"
   alIsSource :: Source -> IO ALboolean



{-
sourcei/sourcef/sourcefv:
AL_BUFFER
AL_CONE_INNER_ANGLE
AL_CONE_OUTER_ANGLE
AL_CONE_OUTER_GAIN
AL_DIRECTION
AL_GAIN
AL_GAIN_LINEAR_LOKI
AL_LOOPING
AL_MAX_DISTANCE
AL_MAX_GAIN
AL_MIN_GAIN
AL_PITCH
AL_POSITION
AL_REFERENCE_DISTANCE
AL_ROLLOFF_FACTOR
AL_SOURCE_RELATIVE
AL_STREAMING
AL_VELOCITY

getsourceiv
AL_BUFFERS_PROCESSED
AL_BUFFERS_QUEUED
AL_BYTE_LOKI
AL_CONE_INNER_ANGLE
AL_CONE_OUTER_ANGLE
AL_CONE_OUTER_GAIN
AL_DIRECTION
AL_GAIN
AL_GAIN_LINEAR_LOKI
AL_LOOPING
AL_MAX_DISTANCE
AL_PITCH
AL_POSITION
AL_REFERENCE_DISTANCE
AL_ROLLOFF_FACTOR
AL_SOURCE_RELATIVE
AL_SOURCE_STATE
AL_STREAMING
AL_VELOCITY

getsourcefv
*AL_BUFFER
AL_BUFFERS_PROCESSED
AL_BUFFERS_QUEUED
AL_BYTE_LOKI
AL_CONE_INNER_ANGLE
AL_CONE_OUTER_ANGLE
AL_CONE_OUTER_GAIN
AL_DIRECTION
AL_GAIN
AL_GAIN_LINEAR_LOKI
AL_LOOPING
AL_MAX_DISTANCE
*AL_MAX_GAIN
*AL_MIN_GAIN
AL_PITCH
AL_POSITION
AL_REFERENCE_DISTANCE
AL_ROLLOFF_FACTOR
AL_SOURCE_RELATIVE
AL_SOURCE_STATE
AL_STREAMING
AL_VELOCITY


-}
