--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.OpenAL.ALC.Extensions
-- Copyright   :  (c) Sven Panne 2003
-- License     :  BSD-style (see the file libraries/OpenAL/LICENSE)
-- 
-- Maintainer  :  sven_panne@yahoo.com
-- Stability   :  provisional
-- Portability :  portable
--
-- Extension Handling
--
--------------------------------------------------------------------------------

module Sound.OpenAL.ALC.Extensions (
   alcExtensions, alcIsExtensionPresent, alcGetProcAddress, alcGetEnumValue
) where

import Control.Monad ( liftM )
import Foreign.Ptr ( Ptr, FunPtr )
import Graphics.Rendering.OpenGL.GL.StateVar (
   GettableStateVar, makeGettableStateVar )
import Sound.OpenAL.AL.BasicTypes
import Sound.OpenAL.ALC.BasicTypes ( fromDevice, withALString )
import Sound.OpenAL.ALC.Device ( Device )
import Sound.OpenAL.ALC.Queries (
   StringQuery(..), alcGetString, alcIsExtensionPresent )

--------------------------------------------------------------------------------

alcExtensions :: GettableStateVar [String]
alcExtensions = makeGettableStateVar $
   liftM words $ alcGetString Nothing Extensions

--------------------------------------------------------------------------------

alcGetProcAddress :: Maybe Device -> String -> IO (FunPtr a)
alcGetProcAddress device funcName =
   withALString funcName (alcGetProcAddress_ (fromDevice device))

foreign import CALLCONV unsafe "alcGetProcAddress"
   alcGetProcAddress_ :: Device -> Ptr ALubyte -> IO (FunPtr a)

--------------------------------------------------------------------------------

alcGetEnumValue :: Maybe Device -> String -> IO ALenum
alcGetEnumValue device enumName =
   withALString enumName (alcGetEnumValue_ (fromDevice device))

foreign import CALLCONV unsafe "alcGetEnumValue"
   alcGetEnumValue_ :: Device -> Ptr ALubyte -> IO ALenum
