/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the w64 mingw-runtime package.
 * No warranty is given; refer to the file DISCLAIMER.PD within this package.
 */
#ifndef _INC_ICFTYPES
#define _INC_ICFTYPES

#ifdef __cplusplus
extern "C" {
#endif

typedef enum _NET_FW_ACTION {
  NET_FW_ACTION_BLOCK = 0,
  NET_FW_ACTION_ALLOW,
  NET_FW_ACTION_MAX
} NET_FW_ACTION;

typedef enum _NET_FW_MODIFY_STATE {
  NET_FW_MODIFY_STATE_OK = 0,
  NET_FW_MODIFY_STATE_GP_OVERRIDE,
  NET_FW_MODIFY_STATE_INBOUND_BLOCKED
} NET_FW_MODIFY_STATE;

typedef enum NET_FW_PROFILE_TYPE_ {
  NET_FW_PROFILE_DOMAIN = 0,
  NET_FW_PROFILE_STANDARD,
  NET_FW_PROFILE_CURRENT,
  NET_FW_PROFILE_TYPE_MAX
} NET_FW_PROFILE_TYPE;

typedef enum NET_FW_PROFILE_TYPE2_ {
  NET_FW_PROFILE2_DOMAIN    = 0x0001,
  NET_FW_PROFILE2_PRIVATE   = 0x0002,
  NET_FW_PROFILE2_PUBLIC    = 0x0004,
  NET_FW_PROFILE2_ALL       = 0x7FFFFFFF
} NET_FW_PROFILE_TYPE2;

typedef enum NET_FW_RULE_DIRECTION_ {
  NET_FW_RULE_DIR_IN = 1,
  NET_FW_RULE_DIR_OUT,
  NET_FW_RULE_DIR_MAX 
} NET_FW_RULE_DIRECTION;

typedef enum NET_FW_SCOPE_ {
  NET_FW_SCOPE_ALL = 0,
  NET_FW_SCOPE_LOCAL_SUBNET,
  NET_FW_SCOPE_CUSTOM,
  NET_FW_SCOPE_MAX
} NET_FW_SCOPE;

typedef enum NET_FW_IP_VERSION_ {
  NET_FW_IP_VERSION_V4 = 0,
  NET_FW_IP_VERSION_V6,
  NET_FW_IP_VERSION_ANY,
  NET_FW_IP_VERSION_MAX
} NET_FW_IP_VERSION;

typedef enum NET_FW_IP_PROTOCOL_ {
  NET_FW_IP_PROTOCOL_TCP = 6,
  NET_FW_IP_PROTOCOL_UDP = 17,
  NET_FW_IP_PROTOCOL_ANY = 256
} NET_FW_IP_PROTOCOL;

typedef enum NET_FW_POLICY_TYPE_ {
  NET_FW_POLICY_GROUP = 0,
  NET_FW_POLICY_LOCAL,
  NET_FW_POLICY_EFFECTIVE,
  NET_FW_POLICY_TYPE_MAX
} NET_FW_POLICY_TYPE;

typedef enum NET_FW_SERVICE_TYPE_ {
  NET_FW_SERVICE_FILE_AND_PRINT = 0,
  NET_FW_SERVICE_UPNP,
  NET_FW_SERVICE_REMOTE_DESKTOP,
  NET_FW_SERVICE_NONE,
  NET_FW_SERVICE_TYPE_MAX
} NET_FW_SERVICE_TYPE;

typedef enum NET_FW_EDGE_TRAVERSAL_TYPE_ {
  NET_FW_EDGE_TRAVERSAL_TYPE_DENY = 0,
  NET_FW_EDGE_TRAVERSAL_TYPE_ALLOW,
  NET_FW_EDGE_TRAVERSAL_TYPE_DEFER_TO_APP,
  NET_FW_EDGE_TRAVERSAL_TYPE_DEFER_TO_USER
} NET_FW_EDGE_TRAVERSAL_TYPE;

typedef enum NET_FW_RULE_CATEGORY_ {
  NET_FW_RULE_CATEGORY_BOOT     = 0,
  NET_FW_RULE_CATEGORY_STEALTH  = 1,
  NET_FW_RULE_CATEGORY_FIREWALL = 2,
  NET_FW_RULE_CATEGORY_CONSEC   = 3,
  NET_FW_RULE_CATEGORY_MAX      = 4
} NET_FW_RULE_CATEGORY;

#ifdef __cplusplus
}
#endif

#endif /*_INC_ICFTYPES*/
