module Win32NLS where

import StdDIS
import Addr
import Word
import Win32Types


type LCID = DWORD

lOCALE_SYSTEM_DEFAULT :: LCID
lOCALE_SYSTEM_DEFAULT =
  unsafePerformIO(
    prim_lOCALE_SYSTEM_DEFAULT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SYSTEM_DEFAULT" prim_lOCALE_SYSTEM_DEFAULT :: IO (Word32)
lOCALE_USER_DEFAULT :: LCID
lOCALE_USER_DEFAULT =
  unsafePerformIO(
    prim_lOCALE_USER_DEFAULT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_USER_DEFAULT" prim_lOCALE_USER_DEFAULT :: IO (Word32)
lOCALE_NEUTRAL :: LCID
lOCALE_NEUTRAL =
  unsafePerformIO(
    prim_lOCALE_NEUTRAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_NEUTRAL" prim_lOCALE_NEUTRAL :: IO (Word32)

convertDefaultLocale :: LCID -> IO LCID
convertDefaultLocale arg1 =
  prim_convertDefaultLocale arg1
  >>= \  res1  ->
  (return (res1))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_convertDefaultLocale" prim_convertDefaultLocale :: Word32 -> IO (Word32)

-- ToDo: various enum functions.

type CodePage = UINT

cP_ACP :: CodePage
cP_ACP =
  unsafePerformIO(
    prim_cP_ACP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_cP_ACP" prim_cP_ACP :: IO (Word32)
cP_MACCP :: CodePage
cP_MACCP =
  unsafePerformIO(
    prim_cP_MACCP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_cP_MACCP" prim_cP_MACCP :: IO (Word32)
cP_OEMCP :: CodePage
cP_OEMCP =
  unsafePerformIO(
    prim_cP_OEMCP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_cP_OEMCP" prim_cP_OEMCP :: IO (Word32)

getACP :: IO CodePage
getACP =
  prim_getACP
  >>= \  res1  ->
  (return (res1))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_getACP" prim_getACP :: IO (Word32)

setThreadLocale :: LCID -> IO ()
setThreadLocale arg1 =
  prim_setThreadLocale arg1
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_setThreadLocale" prim_setThreadLocale :: Word32 -> IO ()

type LCTYPE = UINT

lOCALE_ICALENDARTYPE :: LCTYPE
lOCALE_ICALENDARTYPE =
  unsafePerformIO(
    prim_lOCALE_ICALENDARTYPE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_ICALENDARTYPE" prim_lOCALE_ICALENDARTYPE :: IO (Word32)
lOCALE_SDATE :: LCTYPE
lOCALE_SDATE =
  unsafePerformIO(
    prim_lOCALE_SDATE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SDATE" prim_lOCALE_SDATE :: IO (Word32)
lOCALE_ICURRDIGITS :: LCTYPE
lOCALE_ICURRDIGITS =
  unsafePerformIO(
    prim_lOCALE_ICURRDIGITS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_ICURRDIGITS" prim_lOCALE_ICURRDIGITS :: IO (Word32)
lOCALE_SDECIMAL :: LCTYPE
lOCALE_SDECIMAL =
  unsafePerformIO(
    prim_lOCALE_SDECIMAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SDECIMAL" prim_lOCALE_SDECIMAL :: IO (Word32)
lOCALE_ICURRENCY :: LCTYPE
lOCALE_ICURRENCY =
  unsafePerformIO(
    prim_lOCALE_ICURRENCY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_ICURRENCY" prim_lOCALE_ICURRENCY :: IO (Word32)
lOCALE_SGROUPING :: LCTYPE
lOCALE_SGROUPING =
  unsafePerformIO(
    prim_lOCALE_SGROUPING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SGROUPING" prim_lOCALE_SGROUPING :: IO (Word32)
lOCALE_IDIGITS :: LCTYPE
lOCALE_IDIGITS =
  unsafePerformIO(
    prim_lOCALE_IDIGITS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_IDIGITS" prim_lOCALE_IDIGITS :: IO (Word32)
lOCALE_SLIST :: LCTYPE
lOCALE_SLIST =
  unsafePerformIO(
    prim_lOCALE_SLIST
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SLIST" prim_lOCALE_SLIST :: IO (Word32)
lOCALE_IFIRSTDAYOFWEEK :: LCTYPE
lOCALE_IFIRSTDAYOFWEEK =
  unsafePerformIO(
    prim_lOCALE_IFIRSTDAYOFWEEK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_IFIRSTDAYOFWEEK" prim_lOCALE_IFIRSTDAYOFWEEK :: IO (Word32)
lOCALE_SLONGDATE :: LCTYPE
lOCALE_SLONGDATE =
  unsafePerformIO(
    prim_lOCALE_SLONGDATE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SLONGDATE" prim_lOCALE_SLONGDATE :: IO (Word32)
lOCALE_IFIRSTWEEKOFYEAR :: LCTYPE
lOCALE_IFIRSTWEEKOFYEAR =
  unsafePerformIO(
    prim_lOCALE_IFIRSTWEEKOFYEAR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_IFIRSTWEEKOFYEAR" prim_lOCALE_IFIRSTWEEKOFYEAR :: IO (Word32)
lOCALE_SMONDECIMALSEP :: LCTYPE
lOCALE_SMONDECIMALSEP =
  unsafePerformIO(
    prim_lOCALE_SMONDECIMALSEP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SMONDECIMALSEP" prim_lOCALE_SMONDECIMALSEP :: IO (Word32)
lOCALE_ILZERO :: LCTYPE
lOCALE_ILZERO =
  unsafePerformIO(
    prim_lOCALE_ILZERO
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_ILZERO" prim_lOCALE_ILZERO :: IO (Word32)
lOCALE_SMONGROUPING :: LCTYPE
lOCALE_SMONGROUPING =
  unsafePerformIO(
    prim_lOCALE_SMONGROUPING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SMONGROUPING" prim_lOCALE_SMONGROUPING :: IO (Word32)
lOCALE_IMEASURE :: LCTYPE
lOCALE_IMEASURE =
  unsafePerformIO(
    prim_lOCALE_IMEASURE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_IMEASURE" prim_lOCALE_IMEASURE :: IO (Word32)
lOCALE_SMONTHOUSANDSEP :: LCTYPE
lOCALE_SMONTHOUSANDSEP =
  unsafePerformIO(
    prim_lOCALE_SMONTHOUSANDSEP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SMONTHOUSANDSEP" prim_lOCALE_SMONTHOUSANDSEP :: IO (Word32)
lOCALE_INEGCURR :: LCTYPE
lOCALE_INEGCURR =
  unsafePerformIO(
    prim_lOCALE_INEGCURR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_INEGCURR" prim_lOCALE_INEGCURR :: IO (Word32)
lOCALE_SNEGATIVESIGN :: LCTYPE
lOCALE_SNEGATIVESIGN =
  unsafePerformIO(
    prim_lOCALE_SNEGATIVESIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SNEGATIVESIGN" prim_lOCALE_SNEGATIVESIGN :: IO (Word32)
lOCALE_INEGNUMBER :: LCTYPE
lOCALE_INEGNUMBER =
  unsafePerformIO(
    prim_lOCALE_INEGNUMBER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_INEGNUMBER" prim_lOCALE_INEGNUMBER :: IO (Word32)
lOCALE_SPOSITIVESIGN :: LCTYPE
lOCALE_SPOSITIVESIGN =
  unsafePerformIO(
    prim_lOCALE_SPOSITIVESIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SPOSITIVESIGN" prim_lOCALE_SPOSITIVESIGN :: IO (Word32)
lOCALE_SSHORTDATE :: LCTYPE
lOCALE_SSHORTDATE =
  unsafePerformIO(
    prim_lOCALE_SSHORTDATE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SSHORTDATE" prim_lOCALE_SSHORTDATE :: IO (Word32)
lOCALE_ITIME :: LCTYPE
lOCALE_ITIME =
  unsafePerformIO(
    prim_lOCALE_ITIME
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_ITIME" prim_lOCALE_ITIME :: IO (Word32)
lOCALE_STHOUSAND :: LCTYPE
lOCALE_STHOUSAND =
  unsafePerformIO(
    prim_lOCALE_STHOUSAND
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_STHOUSAND" prim_lOCALE_STHOUSAND :: IO (Word32)
lOCALE_S1159 :: LCTYPE
lOCALE_S1159 =
  unsafePerformIO(
    prim_lOCALE_S1159
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_S1159" prim_lOCALE_S1159 :: IO (Word32)
lOCALE_STIME :: LCTYPE
lOCALE_STIME =
  unsafePerformIO(
    prim_lOCALE_STIME
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_STIME" prim_lOCALE_STIME :: IO (Word32)
lOCALE_S2359 :: LCTYPE
lOCALE_S2359 =
  unsafePerformIO(
    prim_lOCALE_S2359
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_S2359" prim_lOCALE_S2359 :: IO (Word32)
lOCALE_STIMEFORMAT :: LCTYPE
lOCALE_STIMEFORMAT =
  unsafePerformIO(
    prim_lOCALE_STIMEFORMAT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_STIMEFORMAT" prim_lOCALE_STIMEFORMAT :: IO (Word32)
lOCALE_SCURRENCY :: LCTYPE
lOCALE_SCURRENCY =
  unsafePerformIO(
    prim_lOCALE_SCURRENCY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lOCALE_SCURRENCY" prim_lOCALE_SCURRENCY :: IO (Word32)

-- doesn't work too well with Unicode strings coming back. ToDo: fix.

setLocaleInfo :: LCID -> LCTYPE -> IO String
setLocaleInfo arg1 arg2 =
  prim_setLocaleInfo arg1 arg2
  >>= \ gc_result ->
  access_prim_setLocaleInfo_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_setLocaleInfo_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setLocaleInfo_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (unmarshall_string_ gc_res2) >>= \ gc_res1 ->
       (return (gc_res1))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_setLocaleInfo" prim_setLocaleInfo :: Word32 -> Word32 -> IO (Addr)
foreign import ccall unsafe "access_prim_setLocaleInfo_gc_res2" access_prim_setLocaleInfo_gc_res2 :: Addr -> IO (Addr)
foreign import ccall unsafe "access_prim_setLocaleInfo_gc_failed" access_prim_setLocaleInfo_gc_failed :: Addr -> IO (Int)
foreign import ccall unsafe "access_prim_setLocaleInfo_gc_failstring" access_prim_setLocaleInfo_gc_failstring :: Addr -> IO (Addr)

type LCMapFlags = DWORD

lCMAP_BYTEREV :: LCMapFlags
lCMAP_BYTEREV =
  unsafePerformIO(
    prim_lCMAP_BYTEREV
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_BYTEREV" prim_lCMAP_BYTEREV :: IO (Word32)
lCMAP_FULLWIDTH :: LCMapFlags
lCMAP_FULLWIDTH =
  unsafePerformIO(
    prim_lCMAP_FULLWIDTH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_FULLWIDTH" prim_lCMAP_FULLWIDTH :: IO (Word32)
lCMAP_HALFWIDTH :: LCMapFlags
lCMAP_HALFWIDTH =
  unsafePerformIO(
    prim_lCMAP_HALFWIDTH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_HALFWIDTH" prim_lCMAP_HALFWIDTH :: IO (Word32)
lCMAP_HIRAGANA :: LCMapFlags
lCMAP_HIRAGANA =
  unsafePerformIO(
    prim_lCMAP_HIRAGANA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_HIRAGANA" prim_lCMAP_HIRAGANA :: IO (Word32)
lCMAP_KATAKANA :: LCMapFlags
lCMAP_KATAKANA =
  unsafePerformIO(
    prim_lCMAP_KATAKANA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_KATAKANA" prim_lCMAP_KATAKANA :: IO (Word32)
lCMAP_LOWERCASE :: LCMapFlags
lCMAP_LOWERCASE =
  unsafePerformIO(
    prim_lCMAP_LOWERCASE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_LOWERCASE" prim_lCMAP_LOWERCASE :: IO (Word32)
lCMAP_SORTKEY :: LCMapFlags
lCMAP_SORTKEY =
  unsafePerformIO(
    prim_lCMAP_SORTKEY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_SORTKEY" prim_lCMAP_SORTKEY :: IO (Word32)
lCMAP_UPPERCASE :: LCMapFlags
lCMAP_UPPERCASE =
  unsafePerformIO(
    prim_lCMAP_UPPERCASE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_UPPERCASE" prim_lCMAP_UPPERCASE :: IO (Word32)
nORM_IGNORECASE :: LCMapFlags
nORM_IGNORECASE =
  unsafePerformIO(
    prim_nORM_IGNORECASE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_nORM_IGNORECASE" prim_nORM_IGNORECASE :: IO (Word32)
nORM_IGNORENONSPACE :: LCMapFlags
nORM_IGNORENONSPACE =
  unsafePerformIO(
    prim_nORM_IGNORENONSPACE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_nORM_IGNORENONSPACE" prim_nORM_IGNORENONSPACE :: IO (Word32)
nORM_IGNOREKANATYPE :: LCMapFlags
nORM_IGNOREKANATYPE =
  unsafePerformIO(
    prim_nORM_IGNOREKANATYPE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_nORM_IGNOREKANATYPE" prim_nORM_IGNOREKANATYPE :: IO (Word32)
nORM_IGNORESYMBOLS :: LCMapFlags
nORM_IGNORESYMBOLS =
  unsafePerformIO(
    prim_nORM_IGNORESYMBOLS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_nORM_IGNORESYMBOLS" prim_nORM_IGNORESYMBOLS :: IO (Word32)
nORM_IGNOREWIDTH :: LCMapFlags
nORM_IGNOREWIDTH =
  unsafePerformIO(
    prim_nORM_IGNOREWIDTH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_nORM_IGNOREWIDTH" prim_nORM_IGNOREWIDTH :: IO (Word32)
sORT_STRINGSORT :: LCMapFlags
sORT_STRINGSORT =
  unsafePerformIO(
    prim_sORT_STRINGSORT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sORT_STRINGSORT" prim_sORT_STRINGSORT :: IO (Word32)
lCMAP_LINGUISTIC_CASING :: LCMapFlags
lCMAP_LINGUISTIC_CASING =
  unsafePerformIO(
    prim_lCMAP_LINGUISTIC_CASING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_LINGUISTIC_CASING" prim_lCMAP_LINGUISTIC_CASING :: IO (Word32)
lCMAP_SIMPLIFIED_CHINESE :: LCMapFlags
lCMAP_SIMPLIFIED_CHINESE =
  unsafePerformIO(
    prim_lCMAP_SIMPLIFIED_CHINESE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_SIMPLIFIED_CHINESE" prim_lCMAP_SIMPLIFIED_CHINESE :: IO (Word32)
lCMAP_TRADITIONAL_CHINESE :: LCMapFlags
lCMAP_TRADITIONAL_CHINESE =
  unsafePerformIO(
    prim_lCMAP_TRADITIONAL_CHINESE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMAP_TRADITIONAL_CHINESE" prim_lCMAP_TRADITIONAL_CHINESE :: IO (Word32)

lCMapString :: LCID -> LCMapFlags -> String -> Int -> IO String
lCMapString arg1 arg2 gc_arg1 arg4 =
  (marshall_stringLen_ gc_arg1) >>= \ (arg3,arg3_len) ->
  prim_lCMapString arg1 arg2 arg3 arg3_len arg4
  >>= \ gc_result ->
  access_prim_lCMapString_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_lCMapString_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_lCMapString_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (unmarshall_string_ gc_res2) >>= \ gc_res1 ->
       (return (gc_res1))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCMapString" prim_lCMapString :: Word32 -> Word32 -> Addr -> Int -> Int -> IO (Addr)
foreign import ccall unsafe "access_prim_lCMapString_gc_res2" access_prim_lCMapString_gc_res2 :: Addr -> IO (Addr)
foreign import ccall unsafe "access_prim_lCMapString_gc_failed" access_prim_lCMapString_gc_failed :: Addr -> IO (Int)
foreign import ccall unsafe "access_prim_lCMapString_gc_failstring" access_prim_lCMapString_gc_failstring :: Addr -> IO (Addr)

type LocaleTestFlags = DWORD

lCID_INSTALLED :: LocaleTestFlags
lCID_INSTALLED =
  unsafePerformIO(
    prim_lCID_INSTALLED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCID_INSTALLED" prim_lCID_INSTALLED :: IO (Word32)
lCID_SUPPORTED :: LocaleTestFlags
lCID_SUPPORTED =
  unsafePerformIO(
    prim_lCID_SUPPORTED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lCID_SUPPORTED" prim_lCID_SUPPORTED :: IO (Word32)

isValidLocale :: LCID -> LocaleTestFlags -> IO Bool
isValidLocale arg1 arg2 =
  prim_isValidLocale arg1 arg2
  >>= \  res1  ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_isValidLocale" prim_isValidLocale :: Word32 -> Word32 -> IO (Int)

isValidCodePage :: CodePage -> IO Bool
isValidCodePage arg1 =
  prim_isValidCodePage arg1
  >>= \  res1  ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_isValidCodePage" prim_isValidCodePage :: Word32 -> IO (Int)

getUserDefaultLCID :: LCID
getUserDefaultLCID =
  unsafePerformIO(
    prim_getUserDefaultLCID
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_getUserDefaultLCID" prim_getUserDefaultLCID :: IO (Word32)

getUserDefaultLangID :: LANGID
getUserDefaultLangID =
  unsafePerformIO(
    prim_getUserDefaultLangID
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_getUserDefaultLangID" prim_getUserDefaultLangID :: IO (Word16)

getThreadLocale :: IO LCID
getThreadLocale =
  prim_getThreadLocale
  >>= \  res1  ->
  (return (res1))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_getThreadLocale" prim_getThreadLocale :: IO (Word32)

getSystemDefaultLCID :: LCID
getSystemDefaultLCID =
  unsafePerformIO(
    prim_getSystemDefaultLCID
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_getSystemDefaultLCID" prim_getSystemDefaultLCID :: IO (Word32)

getSystemDefaultLangID :: LANGID
getSystemDefaultLangID =
  unsafePerformIO(
    prim_getSystemDefaultLangID
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_getSystemDefaultLangID" prim_getSystemDefaultLangID :: IO (Word16)

getOEMCP :: CodePage
getOEMCP =
  unsafePerformIO(
    prim_getOEMCP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_getOEMCP" prim_getOEMCP :: IO (Word32)

type LANGID = WORD

lANGIDFROMLCID :: LCID -> LANGID
lANGIDFROMLCID arg1 =
  unsafePerformIO(
    prim_lANGIDFROMLCID arg1
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANGIDFROMLCID" prim_lANGIDFROMLCID :: Word32 -> IO (Word16)

type SubLANGID = WORD

type PrimaryLANGID = WORD

lANG_NEUTRAL :: PrimaryLANGID
lANG_NEUTRAL =
  unsafePerformIO(
    prim_lANG_NEUTRAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_NEUTRAL" prim_lANG_NEUTRAL :: IO (Word16)
lANG_BULGARIAN :: PrimaryLANGID
lANG_BULGARIAN =
  unsafePerformIO(
    prim_lANG_BULGARIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_BULGARIAN" prim_lANG_BULGARIAN :: IO (Word16)
lANG_CHINESE :: PrimaryLANGID
lANG_CHINESE =
  unsafePerformIO(
    prim_lANG_CHINESE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_CHINESE" prim_lANG_CHINESE :: IO (Word16)
lANG_CZECH :: PrimaryLANGID
lANG_CZECH =
  unsafePerformIO(
    prim_lANG_CZECH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_CZECH" prim_lANG_CZECH :: IO (Word16)
lANG_DANISH :: PrimaryLANGID
lANG_DANISH =
  unsafePerformIO(
    prim_lANG_DANISH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_DANISH" prim_lANG_DANISH :: IO (Word16)
lANG_GERMAN :: PrimaryLANGID
lANG_GERMAN =
  unsafePerformIO(
    prim_lANG_GERMAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_GERMAN" prim_lANG_GERMAN :: IO (Word16)
lANG_GREEK :: PrimaryLANGID
lANG_GREEK =
  unsafePerformIO(
    prim_lANG_GREEK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_GREEK" prim_lANG_GREEK :: IO (Word16)
lANG_ENGLISH :: PrimaryLANGID
lANG_ENGLISH =
  unsafePerformIO(
    prim_lANG_ENGLISH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_ENGLISH" prim_lANG_ENGLISH :: IO (Word16)
lANG_SPANISH :: PrimaryLANGID
lANG_SPANISH =
  unsafePerformIO(
    prim_lANG_SPANISH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_SPANISH" prim_lANG_SPANISH :: IO (Word16)
lANG_FINNISH :: PrimaryLANGID
lANG_FINNISH =
  unsafePerformIO(
    prim_lANG_FINNISH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_FINNISH" prim_lANG_FINNISH :: IO (Word16)
lANG_FRENCH :: PrimaryLANGID
lANG_FRENCH =
  unsafePerformIO(
    prim_lANG_FRENCH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_FRENCH" prim_lANG_FRENCH :: IO (Word16)
lANG_HUNGARIAN :: PrimaryLANGID
lANG_HUNGARIAN =
  unsafePerformIO(
    prim_lANG_HUNGARIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_HUNGARIAN" prim_lANG_HUNGARIAN :: IO (Word16)
lANG_ICELANDIC :: PrimaryLANGID
lANG_ICELANDIC =
  unsafePerformIO(
    prim_lANG_ICELANDIC
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_ICELANDIC" prim_lANG_ICELANDIC :: IO (Word16)
lANG_ITALIAN :: PrimaryLANGID
lANG_ITALIAN =
  unsafePerformIO(
    prim_lANG_ITALIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_ITALIAN" prim_lANG_ITALIAN :: IO (Word16)
lANG_JAPANESE :: PrimaryLANGID
lANG_JAPANESE =
  unsafePerformIO(
    prim_lANG_JAPANESE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_JAPANESE" prim_lANG_JAPANESE :: IO (Word16)
lANG_KOREAN :: PrimaryLANGID
lANG_KOREAN =
  unsafePerformIO(
    prim_lANG_KOREAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_KOREAN" prim_lANG_KOREAN :: IO (Word16)
lANG_DUTCH :: PrimaryLANGID
lANG_DUTCH =
  unsafePerformIO(
    prim_lANG_DUTCH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_DUTCH" prim_lANG_DUTCH :: IO (Word16)
lANG_NORWEGIAN :: PrimaryLANGID
lANG_NORWEGIAN =
  unsafePerformIO(
    prim_lANG_NORWEGIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_NORWEGIAN" prim_lANG_NORWEGIAN :: IO (Word16)
lANG_POLISH :: PrimaryLANGID
lANG_POLISH =
  unsafePerformIO(
    prim_lANG_POLISH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_POLISH" prim_lANG_POLISH :: IO (Word16)
lANG_PORTUGUESE :: PrimaryLANGID
lANG_PORTUGUESE =
  unsafePerformIO(
    prim_lANG_PORTUGUESE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_PORTUGUESE" prim_lANG_PORTUGUESE :: IO (Word16)
lANG_ROMANIAN :: PrimaryLANGID
lANG_ROMANIAN =
  unsafePerformIO(
    prim_lANG_ROMANIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_ROMANIAN" prim_lANG_ROMANIAN :: IO (Word16)
lANG_RUSSIAN :: PrimaryLANGID
lANG_RUSSIAN =
  unsafePerformIO(
    prim_lANG_RUSSIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_RUSSIAN" prim_lANG_RUSSIAN :: IO (Word16)
lANG_CROATIAN :: PrimaryLANGID
lANG_CROATIAN =
  unsafePerformIO(
    prim_lANG_CROATIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_CROATIAN" prim_lANG_CROATIAN :: IO (Word16)
lANG_SLOVAK :: PrimaryLANGID
lANG_SLOVAK =
  unsafePerformIO(
    prim_lANG_SLOVAK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_SLOVAK" prim_lANG_SLOVAK :: IO (Word16)
lANG_SWEDISH :: PrimaryLANGID
lANG_SWEDISH =
  unsafePerformIO(
    prim_lANG_SWEDISH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_SWEDISH" prim_lANG_SWEDISH :: IO (Word16)
lANG_TURKISH :: PrimaryLANGID
lANG_TURKISH =
  unsafePerformIO(
    prim_lANG_TURKISH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_TURKISH" prim_lANG_TURKISH :: IO (Word16)
lANG_SLOVENIAN :: PrimaryLANGID
lANG_SLOVENIAN =
  unsafePerformIO(
    prim_lANG_SLOVENIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_SLOVENIAN" prim_lANG_SLOVENIAN :: IO (Word16)
lANG_ARABIC :: PrimaryLANGID
lANG_ARABIC =
  unsafePerformIO(
    prim_lANG_ARABIC
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_ARABIC" prim_lANG_ARABIC :: IO (Word16)
lANG_CATALAN :: PrimaryLANGID
lANG_CATALAN =
  unsafePerformIO(
    prim_lANG_CATALAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_CATALAN" prim_lANG_CATALAN :: IO (Word16)
lANG_HEBREW :: PrimaryLANGID
lANG_HEBREW =
  unsafePerformIO(
    prim_lANG_HEBREW
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_HEBREW" prim_lANG_HEBREW :: IO (Word16)
lANG_SERBIAN :: PrimaryLANGID
lANG_SERBIAN =
  unsafePerformIO(
    prim_lANG_SERBIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_SERBIAN" prim_lANG_SERBIAN :: IO (Word16)
lANG_ALBANIAN :: PrimaryLANGID
lANG_ALBANIAN =
  unsafePerformIO(
    prim_lANG_ALBANIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_ALBANIAN" prim_lANG_ALBANIAN :: IO (Word16)
lANG_THAI :: PrimaryLANGID
lANG_THAI =
  unsafePerformIO(
    prim_lANG_THAI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_THAI" prim_lANG_THAI :: IO (Word16)
lANG_URDU :: PrimaryLANGID
lANG_URDU =
  unsafePerformIO(
    prim_lANG_URDU
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_URDU" prim_lANG_URDU :: IO (Word16)
lANG_INDONESIAN :: PrimaryLANGID
lANG_INDONESIAN =
  unsafePerformIO(
    prim_lANG_INDONESIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_INDONESIAN" prim_lANG_INDONESIAN :: IO (Word16)
lANG_BELARUSIAN :: PrimaryLANGID
lANG_BELARUSIAN =
  unsafePerformIO(
    prim_lANG_BELARUSIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_BELARUSIAN" prim_lANG_BELARUSIAN :: IO (Word16)
lANG_ESTONIAN :: PrimaryLANGID
lANG_ESTONIAN =
  unsafePerformIO(
    prim_lANG_ESTONIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_ESTONIAN" prim_lANG_ESTONIAN :: IO (Word16)
lANG_LATVIAN :: PrimaryLANGID
lANG_LATVIAN =
  unsafePerformIO(
    prim_lANG_LATVIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_LATVIAN" prim_lANG_LATVIAN :: IO (Word16)
lANG_LITHUANIAN :: PrimaryLANGID
lANG_LITHUANIAN =
  unsafePerformIO(
    prim_lANG_LITHUANIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_LITHUANIAN" prim_lANG_LITHUANIAN :: IO (Word16)
lANG_FARSI :: PrimaryLANGID
lANG_FARSI =
  unsafePerformIO(
    prim_lANG_FARSI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_FARSI" prim_lANG_FARSI :: IO (Word16)
lANG_VIETNAMESE :: PrimaryLANGID
lANG_VIETNAMESE =
  unsafePerformIO(
    prim_lANG_VIETNAMESE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_VIETNAMESE" prim_lANG_VIETNAMESE :: IO (Word16)
lANG_ARMENIAN :: PrimaryLANGID
lANG_ARMENIAN =
  unsafePerformIO(
    prim_lANG_ARMENIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_ARMENIAN" prim_lANG_ARMENIAN :: IO (Word16)
lANG_AZERI :: PrimaryLANGID
lANG_AZERI =
  unsafePerformIO(
    prim_lANG_AZERI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_AZERI" prim_lANG_AZERI :: IO (Word16)
lANG_BASQUE :: PrimaryLANGID
lANG_BASQUE =
  unsafePerformIO(
    prim_lANG_BASQUE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_BASQUE" prim_lANG_BASQUE :: IO (Word16)
lANG_MACEDONIAN :: PrimaryLANGID
lANG_MACEDONIAN =
  unsafePerformIO(
    prim_lANG_MACEDONIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_MACEDONIAN" prim_lANG_MACEDONIAN :: IO (Word16)
lANG_AFRIKAANS :: PrimaryLANGID
lANG_AFRIKAANS =
  unsafePerformIO(
    prim_lANG_AFRIKAANS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_AFRIKAANS" prim_lANG_AFRIKAANS :: IO (Word16)
lANG_GEORGIAN :: PrimaryLANGID
lANG_GEORGIAN =
  unsafePerformIO(
    prim_lANG_GEORGIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_GEORGIAN" prim_lANG_GEORGIAN :: IO (Word16)
lANG_FAEROESE :: PrimaryLANGID
lANG_FAEROESE =
  unsafePerformIO(
    prim_lANG_FAEROESE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_FAEROESE" prim_lANG_FAEROESE :: IO (Word16)
lANG_HINDI :: PrimaryLANGID
lANG_HINDI =
  unsafePerformIO(
    prim_lANG_HINDI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_HINDI" prim_lANG_HINDI :: IO (Word16)
lANG_MALAY :: PrimaryLANGID
lANG_MALAY =
  unsafePerformIO(
    prim_lANG_MALAY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_MALAY" prim_lANG_MALAY :: IO (Word16)
lANG_KAZAK :: PrimaryLANGID
lANG_KAZAK =
  unsafePerformIO(
    prim_lANG_KAZAK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_KAZAK" prim_lANG_KAZAK :: IO (Word16)
lANG_SWAHILI :: PrimaryLANGID
lANG_SWAHILI =
  unsafePerformIO(
    prim_lANG_SWAHILI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_SWAHILI" prim_lANG_SWAHILI :: IO (Word16)
lANG_UZBEK :: PrimaryLANGID
lANG_UZBEK =
  unsafePerformIO(
    prim_lANG_UZBEK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_UZBEK" prim_lANG_UZBEK :: IO (Word16)
lANG_TATAR :: PrimaryLANGID
lANG_TATAR =
  unsafePerformIO(
    prim_lANG_TATAR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_TATAR" prim_lANG_TATAR :: IO (Word16)
lANG_BENGALI :: PrimaryLANGID
lANG_BENGALI =
  unsafePerformIO(
    prim_lANG_BENGALI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_BENGALI" prim_lANG_BENGALI :: IO (Word16)
lANG_PUNJABI :: PrimaryLANGID
lANG_PUNJABI =
  unsafePerformIO(
    prim_lANG_PUNJABI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_PUNJABI" prim_lANG_PUNJABI :: IO (Word16)
lANG_GUJARATI :: PrimaryLANGID
lANG_GUJARATI =
  unsafePerformIO(
    prim_lANG_GUJARATI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_GUJARATI" prim_lANG_GUJARATI :: IO (Word16)
lANG_ORIYA :: PrimaryLANGID
lANG_ORIYA =
  unsafePerformIO(
    prim_lANG_ORIYA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_ORIYA" prim_lANG_ORIYA :: IO (Word16)
lANG_TAMIL :: PrimaryLANGID
lANG_TAMIL =
  unsafePerformIO(
    prim_lANG_TAMIL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_TAMIL" prim_lANG_TAMIL :: IO (Word16)
lANG_TELUGU :: PrimaryLANGID
lANG_TELUGU =
  unsafePerformIO(
    prim_lANG_TELUGU
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_TELUGU" prim_lANG_TELUGU :: IO (Word16)
lANG_KANNADA :: PrimaryLANGID
lANG_KANNADA =
  unsafePerformIO(
    prim_lANG_KANNADA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_KANNADA" prim_lANG_KANNADA :: IO (Word16)
lANG_MALAYALAM :: PrimaryLANGID
lANG_MALAYALAM =
  unsafePerformIO(
    prim_lANG_MALAYALAM
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_MALAYALAM" prim_lANG_MALAYALAM :: IO (Word16)
lANG_ASSAMESE :: PrimaryLANGID
lANG_ASSAMESE =
  unsafePerformIO(
    prim_lANG_ASSAMESE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_ASSAMESE" prim_lANG_ASSAMESE :: IO (Word16)
lANG_MARATHI :: PrimaryLANGID
lANG_MARATHI =
  unsafePerformIO(
    prim_lANG_MARATHI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_MARATHI" prim_lANG_MARATHI :: IO (Word16)
lANG_SANSKRIT :: PrimaryLANGID
lANG_SANSKRIT =
  unsafePerformIO(
    prim_lANG_SANSKRIT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_SANSKRIT" prim_lANG_SANSKRIT :: IO (Word16)
lANG_KONKANI :: PrimaryLANGID
lANG_KONKANI =
  unsafePerformIO(
    prim_lANG_KONKANI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_KONKANI" prim_lANG_KONKANI :: IO (Word16)
lANG_MANIPURI :: PrimaryLANGID
lANG_MANIPURI =
  unsafePerformIO(
    prim_lANG_MANIPURI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_MANIPURI" prim_lANG_MANIPURI :: IO (Word16)
lANG_SINDHI :: PrimaryLANGID
lANG_SINDHI =
  unsafePerformIO(
    prim_lANG_SINDHI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_SINDHI" prim_lANG_SINDHI :: IO (Word16)
lANG_KASHMIRI :: PrimaryLANGID
lANG_KASHMIRI =
  unsafePerformIO(
    prim_lANG_KASHMIRI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_KASHMIRI" prim_lANG_KASHMIRI :: IO (Word16)
lANG_NEPALI :: PrimaryLANGID
lANG_NEPALI =
  unsafePerformIO(
    prim_lANG_NEPALI
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_lANG_NEPALI" prim_lANG_NEPALI :: IO (Word16)

mAKELANGID :: PrimaryLANGID -> SubLANGID -> LANGID
mAKELANGID arg1 arg2 =
  unsafePerformIO(
    prim_mAKELANGID arg1 arg2
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_mAKELANGID" prim_mAKELANGID :: Word16 -> Word16 -> IO (Word16)

mAKELCID :: LANGID -> SortID -> LCID
mAKELCID arg1 arg2 =
  unsafePerformIO(
    prim_mAKELCID arg1 arg2
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_mAKELCID" prim_mAKELCID :: Word16 -> Word16 -> IO (Word32)

pRIMARYLANGID :: LANGID -> PrimaryLANGID
pRIMARYLANGID arg1 =
  unsafePerformIO(
    prim_pRIMARYLANGID arg1
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_pRIMARYLANGID" prim_pRIMARYLANGID :: Word16 -> IO (Word16)

sUBLANGID :: LANGID -> SubLANGID
sUBLANGID arg1 =
  unsafePerformIO(
    prim_sUBLANGID arg1
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANGID" prim_sUBLANGID :: Word16 -> IO (Word16)

sORTIDFROMLCID :: LCID -> SortID
sORTIDFROMLCID arg1 =
  unsafePerformIO(
    prim_sORTIDFROMLCID arg1
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sORTIDFROMLCID" prim_sORTIDFROMLCID :: Word32 -> IO (Word16)

type SortID = WORD

sORT_DEFAULT :: SortID
sORT_DEFAULT =
  unsafePerformIO(
    prim_sORT_DEFAULT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sORT_DEFAULT" prim_sORT_DEFAULT :: IO (Word16)
sORT_JAPANESE_XJIS :: SortID
sORT_JAPANESE_XJIS =
  unsafePerformIO(
    prim_sORT_JAPANESE_XJIS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sORT_JAPANESE_XJIS" prim_sORT_JAPANESE_XJIS :: IO (Word16)
sORT_JAPANESE_UNICODE :: SortID
sORT_JAPANESE_UNICODE =
  unsafePerformIO(
    prim_sORT_JAPANESE_UNICODE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sORT_JAPANESE_UNICODE" prim_sORT_JAPANESE_UNICODE :: IO (Word16)
sORT_CHINESE_BIG5 :: SortID
sORT_CHINESE_BIG5 =
  unsafePerformIO(
    prim_sORT_CHINESE_BIG5
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sORT_CHINESE_BIG5" prim_sORT_CHINESE_BIG5 :: IO (Word16)
sORT_CHINESE_UNICODE :: SortID
sORT_CHINESE_UNICODE =
  unsafePerformIO(
    prim_sORT_CHINESE_UNICODE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sORT_CHINESE_UNICODE" prim_sORT_CHINESE_UNICODE :: IO (Word16)
sORT_KOREAN_KSC :: SortID
sORT_KOREAN_KSC =
  unsafePerformIO(
    prim_sORT_KOREAN_KSC
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sORT_KOREAN_KSC" prim_sORT_KOREAN_KSC :: IO (Word16)
sORT_KOREAN_UNICODE :: SortID
sORT_KOREAN_UNICODE =
  unsafePerformIO(
    prim_sORT_KOREAN_UNICODE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sORT_KOREAN_UNICODE" prim_sORT_KOREAN_UNICODE :: IO (Word16)

sUBLANG_NEUTRAL :: SubLANGID
sUBLANG_NEUTRAL =
  unsafePerformIO(
    prim_sUBLANG_NEUTRAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_NEUTRAL" prim_sUBLANG_NEUTRAL :: IO (Word16)
sUBLANG_DEFAULT :: SubLANGID
sUBLANG_DEFAULT =
  unsafePerformIO(
    prim_sUBLANG_DEFAULT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_DEFAULT" prim_sUBLANG_DEFAULT :: IO (Word16)
sUBLANG_SYS_DEFAULT :: SubLANGID
sUBLANG_SYS_DEFAULT =
  unsafePerformIO(
    prim_sUBLANG_SYS_DEFAULT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SYS_DEFAULT" prim_sUBLANG_SYS_DEFAULT :: IO (Word16)
sUBLANG_CHINESE_TRADITIONAL :: SubLANGID
sUBLANG_CHINESE_TRADITIONAL =
  unsafePerformIO(
    prim_sUBLANG_CHINESE_TRADITIONAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_CHINESE_TRADITIONAL" prim_sUBLANG_CHINESE_TRADITIONAL :: IO (Word16)
sUBLANG_CHINESE_SIMPLIFIED :: SubLANGID
sUBLANG_CHINESE_SIMPLIFIED =
  unsafePerformIO(
    prim_sUBLANG_CHINESE_SIMPLIFIED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_CHINESE_SIMPLIFIED" prim_sUBLANG_CHINESE_SIMPLIFIED :: IO (Word16)
sUBLANG_CHINESE_HONGKONG :: SubLANGID
sUBLANG_CHINESE_HONGKONG =
  unsafePerformIO(
    prim_sUBLANG_CHINESE_HONGKONG
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_CHINESE_HONGKONG" prim_sUBLANG_CHINESE_HONGKONG :: IO (Word16)
sUBLANG_CHINESE_SINGAPORE :: SubLANGID
sUBLANG_CHINESE_SINGAPORE =
  unsafePerformIO(
    prim_sUBLANG_CHINESE_SINGAPORE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_CHINESE_SINGAPORE" prim_sUBLANG_CHINESE_SINGAPORE :: IO (Word16)
sUBLANG_DUTCH :: SubLANGID
sUBLANG_DUTCH =
  unsafePerformIO(
    prim_sUBLANG_DUTCH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_DUTCH" prim_sUBLANG_DUTCH :: IO (Word16)
sUBLANG_DUTCH_BELGIAN :: SubLANGID
sUBLANG_DUTCH_BELGIAN =
  unsafePerformIO(
    prim_sUBLANG_DUTCH_BELGIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_DUTCH_BELGIAN" prim_sUBLANG_DUTCH_BELGIAN :: IO (Word16)
sUBLANG_ENGLISH_US :: SubLANGID
sUBLANG_ENGLISH_US =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_US
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_US" prim_sUBLANG_ENGLISH_US :: IO (Word16)
sUBLANG_ENGLISH_UK :: SubLANGID
sUBLANG_ENGLISH_UK =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_UK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_UK" prim_sUBLANG_ENGLISH_UK :: IO (Word16)
sUBLANG_ENGLISH_AUS :: SubLANGID
sUBLANG_ENGLISH_AUS =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_AUS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_AUS" prim_sUBLANG_ENGLISH_AUS :: IO (Word16)
sUBLANG_ENGLISH_CAN :: SubLANGID
sUBLANG_ENGLISH_CAN =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_CAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_CAN" prim_sUBLANG_ENGLISH_CAN :: IO (Word16)
sUBLANG_ENGLISH_NZ :: SubLANGID
sUBLANG_ENGLISH_NZ =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_NZ
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_NZ" prim_sUBLANG_ENGLISH_NZ :: IO (Word16)
sUBLANG_ENGLISH_EIRE :: SubLANGID
sUBLANG_ENGLISH_EIRE =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_EIRE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_EIRE" prim_sUBLANG_ENGLISH_EIRE :: IO (Word16)
sUBLANG_FRENCH :: SubLANGID
sUBLANG_FRENCH =
  unsafePerformIO(
    prim_sUBLANG_FRENCH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_FRENCH" prim_sUBLANG_FRENCH :: IO (Word16)
sUBLANG_FRENCH_BELGIAN :: SubLANGID
sUBLANG_FRENCH_BELGIAN =
  unsafePerformIO(
    prim_sUBLANG_FRENCH_BELGIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_FRENCH_BELGIAN" prim_sUBLANG_FRENCH_BELGIAN :: IO (Word16)
sUBLANG_FRENCH_CANADIAN :: SubLANGID
sUBLANG_FRENCH_CANADIAN =
  unsafePerformIO(
    prim_sUBLANG_FRENCH_CANADIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_FRENCH_CANADIAN" prim_sUBLANG_FRENCH_CANADIAN :: IO (Word16)
sUBLANG_FRENCH_SWISS :: SubLANGID
sUBLANG_FRENCH_SWISS =
  unsafePerformIO(
    prim_sUBLANG_FRENCH_SWISS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_FRENCH_SWISS" prim_sUBLANG_FRENCH_SWISS :: IO (Word16)
sUBLANG_GERMAN :: SubLANGID
sUBLANG_GERMAN =
  unsafePerformIO(
    prim_sUBLANG_GERMAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_GERMAN" prim_sUBLANG_GERMAN :: IO (Word16)
sUBLANG_GERMAN_SWISS :: SubLANGID
sUBLANG_GERMAN_SWISS =
  unsafePerformIO(
    prim_sUBLANG_GERMAN_SWISS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_GERMAN_SWISS" prim_sUBLANG_GERMAN_SWISS :: IO (Word16)
sUBLANG_GERMAN_AUSTRIAN :: SubLANGID
sUBLANG_GERMAN_AUSTRIAN =
  unsafePerformIO(
    prim_sUBLANG_GERMAN_AUSTRIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_GERMAN_AUSTRIAN" prim_sUBLANG_GERMAN_AUSTRIAN :: IO (Word16)
sUBLANG_ITALIAN :: SubLANGID
sUBLANG_ITALIAN =
  unsafePerformIO(
    prim_sUBLANG_ITALIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ITALIAN" prim_sUBLANG_ITALIAN :: IO (Word16)
sUBLANG_ITALIAN_SWISS :: SubLANGID
sUBLANG_ITALIAN_SWISS =
  unsafePerformIO(
    prim_sUBLANG_ITALIAN_SWISS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ITALIAN_SWISS" prim_sUBLANG_ITALIAN_SWISS :: IO (Word16)
sUBLANG_NORWEGIAN_BOKMAL :: SubLANGID
sUBLANG_NORWEGIAN_BOKMAL =
  unsafePerformIO(
    prim_sUBLANG_NORWEGIAN_BOKMAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_NORWEGIAN_BOKMAL" prim_sUBLANG_NORWEGIAN_BOKMAL :: IO (Word16)
sUBLANG_NORWEGIAN_NYNORSK :: SubLANGID
sUBLANG_NORWEGIAN_NYNORSK =
  unsafePerformIO(
    prim_sUBLANG_NORWEGIAN_NYNORSK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_NORWEGIAN_NYNORSK" prim_sUBLANG_NORWEGIAN_NYNORSK :: IO (Word16)
sUBLANG_PORTUGUESE :: SubLANGID
sUBLANG_PORTUGUESE =
  unsafePerformIO(
    prim_sUBLANG_PORTUGUESE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_PORTUGUESE" prim_sUBLANG_PORTUGUESE :: IO (Word16)
sUBLANG_PORTUGUESE_BRAZILIAN :: SubLANGID
sUBLANG_PORTUGUESE_BRAZILIAN =
  unsafePerformIO(
    prim_sUBLANG_PORTUGUESE_BRAZILIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_PORTUGUESE_BRAZILIAN" prim_sUBLANG_PORTUGUESE_BRAZILIAN :: IO (Word16)
sUBLANG_SPANISH :: SubLANGID
sUBLANG_SPANISH =
  unsafePerformIO(
    prim_sUBLANG_SPANISH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH" prim_sUBLANG_SPANISH :: IO (Word16)
sUBLANG_SPANISH_MEXICAN :: SubLANGID
sUBLANG_SPANISH_MEXICAN =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_MEXICAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_MEXICAN" prim_sUBLANG_SPANISH_MEXICAN :: IO (Word16)
sUBLANG_SPANISH_MODERN :: SubLANGID
sUBLANG_SPANISH_MODERN =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_MODERN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_MODERN" prim_sUBLANG_SPANISH_MODERN :: IO (Word16)
sUBLANG_ARABIC_SAUDI_ARABIA :: SubLANGID
sUBLANG_ARABIC_SAUDI_ARABIA =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_SAUDI_ARABIA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_SAUDI_ARABIA" prim_sUBLANG_ARABIC_SAUDI_ARABIA :: IO (Word16)
sUBLANG_ARABIC_IRAQ :: SubLANGID
sUBLANG_ARABIC_IRAQ =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_IRAQ
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_IRAQ" prim_sUBLANG_ARABIC_IRAQ :: IO (Word16)
sUBLANG_ARABIC_EGYPT :: SubLANGID
sUBLANG_ARABIC_EGYPT =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_EGYPT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_EGYPT" prim_sUBLANG_ARABIC_EGYPT :: IO (Word16)
sUBLANG_ARABIC_LIBYA :: SubLANGID
sUBLANG_ARABIC_LIBYA =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_LIBYA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_LIBYA" prim_sUBLANG_ARABIC_LIBYA :: IO (Word16)
sUBLANG_ARABIC_ALGERIA :: SubLANGID
sUBLANG_ARABIC_ALGERIA =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_ALGERIA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_ALGERIA" prim_sUBLANG_ARABIC_ALGERIA :: IO (Word16)
sUBLANG_ARABIC_MOROCCO :: SubLANGID
sUBLANG_ARABIC_MOROCCO =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_MOROCCO
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_MOROCCO" prim_sUBLANG_ARABIC_MOROCCO :: IO (Word16)
sUBLANG_ARABIC_TUNISIA :: SubLANGID
sUBLANG_ARABIC_TUNISIA =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_TUNISIA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_TUNISIA" prim_sUBLANG_ARABIC_TUNISIA :: IO (Word16)
sUBLANG_ARABIC_OMAN :: SubLANGID
sUBLANG_ARABIC_OMAN =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_OMAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_OMAN" prim_sUBLANG_ARABIC_OMAN :: IO (Word16)
sUBLANG_ARABIC_YEMEN :: SubLANGID
sUBLANG_ARABIC_YEMEN =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_YEMEN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_YEMEN" prim_sUBLANG_ARABIC_YEMEN :: IO (Word16)
sUBLANG_ARABIC_SYRIA :: SubLANGID
sUBLANG_ARABIC_SYRIA =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_SYRIA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_SYRIA" prim_sUBLANG_ARABIC_SYRIA :: IO (Word16)
sUBLANG_ARABIC_JORDAN :: SubLANGID
sUBLANG_ARABIC_JORDAN =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_JORDAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_JORDAN" prim_sUBLANG_ARABIC_JORDAN :: IO (Word16)
sUBLANG_ARABIC_LEBANON :: SubLANGID
sUBLANG_ARABIC_LEBANON =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_LEBANON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_LEBANON" prim_sUBLANG_ARABIC_LEBANON :: IO (Word16)
sUBLANG_ARABIC_KUWAIT :: SubLANGID
sUBLANG_ARABIC_KUWAIT =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_KUWAIT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_KUWAIT" prim_sUBLANG_ARABIC_KUWAIT :: IO (Word16)
sUBLANG_ARABIC_UAE :: SubLANGID
sUBLANG_ARABIC_UAE =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_UAE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_UAE" prim_sUBLANG_ARABIC_UAE :: IO (Word16)
sUBLANG_ARABIC_BAHRAIN :: SubLANGID
sUBLANG_ARABIC_BAHRAIN =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_BAHRAIN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_BAHRAIN" prim_sUBLANG_ARABIC_BAHRAIN :: IO (Word16)
sUBLANG_ARABIC_QATAR :: SubLANGID
sUBLANG_ARABIC_QATAR =
  unsafePerformIO(
    prim_sUBLANG_ARABIC_QATAR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ARABIC_QATAR" prim_sUBLANG_ARABIC_QATAR :: IO (Word16)
sUBLANG_AZERI_CYRILLIC :: SubLANGID
sUBLANG_AZERI_CYRILLIC =
  unsafePerformIO(
    prim_sUBLANG_AZERI_CYRILLIC
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_AZERI_CYRILLIC" prim_sUBLANG_AZERI_CYRILLIC :: IO (Word16)
sUBLANG_AZERI_LATIN :: SubLANGID
sUBLANG_AZERI_LATIN =
  unsafePerformIO(
    prim_sUBLANG_AZERI_LATIN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_AZERI_LATIN" prim_sUBLANG_AZERI_LATIN :: IO (Word16)
sUBLANG_CHINESE_MACAU :: SubLANGID
sUBLANG_CHINESE_MACAU =
  unsafePerformIO(
    prim_sUBLANG_CHINESE_MACAU
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_CHINESE_MACAU" prim_sUBLANG_CHINESE_MACAU :: IO (Word16)
sUBLANG_ENGLISH_SOUTH_AFRICA :: SubLANGID
sUBLANG_ENGLISH_SOUTH_AFRICA =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_SOUTH_AFRICA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_SOUTH_AFRICA" prim_sUBLANG_ENGLISH_SOUTH_AFRICA :: IO (Word16)
sUBLANG_ENGLISH_JAMAICA :: SubLANGID
sUBLANG_ENGLISH_JAMAICA =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_JAMAICA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_JAMAICA" prim_sUBLANG_ENGLISH_JAMAICA :: IO (Word16)
sUBLANG_ENGLISH_CARIBBEAN :: SubLANGID
sUBLANG_ENGLISH_CARIBBEAN =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_CARIBBEAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_CARIBBEAN" prim_sUBLANG_ENGLISH_CARIBBEAN :: IO (Word16)
sUBLANG_ENGLISH_BELIZE :: SubLANGID
sUBLANG_ENGLISH_BELIZE =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_BELIZE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_BELIZE" prim_sUBLANG_ENGLISH_BELIZE :: IO (Word16)
sUBLANG_ENGLISH_TRINIDAD :: SubLANGID
sUBLANG_ENGLISH_TRINIDAD =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_TRINIDAD
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_TRINIDAD" prim_sUBLANG_ENGLISH_TRINIDAD :: IO (Word16)
sUBLANG_ENGLISH_PHILIPPINES :: SubLANGID
sUBLANG_ENGLISH_PHILIPPINES =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_PHILIPPINES
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_PHILIPPINES" prim_sUBLANG_ENGLISH_PHILIPPINES :: IO (Word16)
sUBLANG_ENGLISH_ZIMBABWE :: SubLANGID
sUBLANG_ENGLISH_ZIMBABWE =
  unsafePerformIO(
    prim_sUBLANG_ENGLISH_ZIMBABWE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_ENGLISH_ZIMBABWE" prim_sUBLANG_ENGLISH_ZIMBABWE :: IO (Word16)
sUBLANG_FRENCH_LUXEMBOURG :: SubLANGID
sUBLANG_FRENCH_LUXEMBOURG =
  unsafePerformIO(
    prim_sUBLANG_FRENCH_LUXEMBOURG
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_FRENCH_LUXEMBOURG" prim_sUBLANG_FRENCH_LUXEMBOURG :: IO (Word16)
sUBLANG_FRENCH_MONACO :: SubLANGID
sUBLANG_FRENCH_MONACO =
  unsafePerformIO(
    prim_sUBLANG_FRENCH_MONACO
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_FRENCH_MONACO" prim_sUBLANG_FRENCH_MONACO :: IO (Word16)
sUBLANG_GERMAN_LUXEMBOURG :: SubLANGID
sUBLANG_GERMAN_LUXEMBOURG =
  unsafePerformIO(
    prim_sUBLANG_GERMAN_LUXEMBOURG
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_GERMAN_LUXEMBOURG" prim_sUBLANG_GERMAN_LUXEMBOURG :: IO (Word16)
sUBLANG_GERMAN_LIECHTENSTEIN :: SubLANGID
sUBLANG_GERMAN_LIECHTENSTEIN =
  unsafePerformIO(
    prim_sUBLANG_GERMAN_LIECHTENSTEIN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_GERMAN_LIECHTENSTEIN" prim_sUBLANG_GERMAN_LIECHTENSTEIN :: IO (Word16)
sUBLANG_KASHMIRI_INDIA :: SubLANGID
sUBLANG_KASHMIRI_INDIA =
  unsafePerformIO(
    prim_sUBLANG_KASHMIRI_INDIA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_KASHMIRI_INDIA" prim_sUBLANG_KASHMIRI_INDIA :: IO (Word16)
sUBLANG_KOREAN :: SubLANGID
sUBLANG_KOREAN =
  unsafePerformIO(
    prim_sUBLANG_KOREAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_KOREAN" prim_sUBLANG_KOREAN :: IO (Word16)
sUBLANG_LITHUANIAN :: SubLANGID
sUBLANG_LITHUANIAN =
  unsafePerformIO(
    prim_sUBLANG_LITHUANIAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_LITHUANIAN" prim_sUBLANG_LITHUANIAN :: IO (Word16)
sUBLANG_MALAY_MALAYSIA :: SubLANGID
sUBLANG_MALAY_MALAYSIA =
  unsafePerformIO(
    prim_sUBLANG_MALAY_MALAYSIA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_MALAY_MALAYSIA" prim_sUBLANG_MALAY_MALAYSIA :: IO (Word16)
sUBLANG_MALAY_BRUNEI_DARUSSALAM :: SubLANGID
sUBLANG_MALAY_BRUNEI_DARUSSALAM =
  unsafePerformIO(
    prim_sUBLANG_MALAY_BRUNEI_DARUSSALAM
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_MALAY_BRUNEI_DARUSSALAM" prim_sUBLANG_MALAY_BRUNEI_DARUSSALAM :: IO (Word16)
sUBLANG_NEPALI_INDIA :: SubLANGID
sUBLANG_NEPALI_INDIA =
  unsafePerformIO(
    prim_sUBLANG_NEPALI_INDIA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_NEPALI_INDIA" prim_sUBLANG_NEPALI_INDIA :: IO (Word16)
sUBLANG_SERBIAN_LATIN :: SubLANGID
sUBLANG_SERBIAN_LATIN =
  unsafePerformIO(
    prim_sUBLANG_SERBIAN_LATIN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SERBIAN_LATIN" prim_sUBLANG_SERBIAN_LATIN :: IO (Word16)
sUBLANG_SERBIAN_CYRILLIC :: SubLANGID
sUBLANG_SERBIAN_CYRILLIC =
  unsafePerformIO(
    prim_sUBLANG_SERBIAN_CYRILLIC
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SERBIAN_CYRILLIC" prim_sUBLANG_SERBIAN_CYRILLIC :: IO (Word16)
sUBLANG_SPANISH_GUATEMALA :: SubLANGID
sUBLANG_SPANISH_GUATEMALA =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_GUATEMALA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_GUATEMALA" prim_sUBLANG_SPANISH_GUATEMALA :: IO (Word16)
sUBLANG_SPANISH_COSTA_RICA :: SubLANGID
sUBLANG_SPANISH_COSTA_RICA =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_COSTA_RICA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_COSTA_RICA" prim_sUBLANG_SPANISH_COSTA_RICA :: IO (Word16)
sUBLANG_SPANISH_PANAMA :: SubLANGID
sUBLANG_SPANISH_PANAMA =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_PANAMA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_PANAMA" prim_sUBLANG_SPANISH_PANAMA :: IO (Word16)
sUBLANG_SPANISH_DOMINICAN_REPUBLIC :: SubLANGID
sUBLANG_SPANISH_DOMINICAN_REPUBLIC =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_DOMINICAN_REPUBLIC
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_DOMINICAN_REPUBLIC" prim_sUBLANG_SPANISH_DOMINICAN_REPUBLIC :: IO (Word16)
sUBLANG_SPANISH_VENEZUELA :: SubLANGID
sUBLANG_SPANISH_VENEZUELA =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_VENEZUELA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_VENEZUELA" prim_sUBLANG_SPANISH_VENEZUELA :: IO (Word16)
sUBLANG_SPANISH_COLOMBIA :: SubLANGID
sUBLANG_SPANISH_COLOMBIA =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_COLOMBIA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_COLOMBIA" prim_sUBLANG_SPANISH_COLOMBIA :: IO (Word16)
sUBLANG_SPANISH_PERU :: SubLANGID
sUBLANG_SPANISH_PERU =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_PERU
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_PERU" prim_sUBLANG_SPANISH_PERU :: IO (Word16)
sUBLANG_SPANISH_ARGENTINA :: SubLANGID
sUBLANG_SPANISH_ARGENTINA =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_ARGENTINA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_ARGENTINA" prim_sUBLANG_SPANISH_ARGENTINA :: IO (Word16)
sUBLANG_SPANISH_ECUADOR :: SubLANGID
sUBLANG_SPANISH_ECUADOR =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_ECUADOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_ECUADOR" prim_sUBLANG_SPANISH_ECUADOR :: IO (Word16)
sUBLANG_SPANISH_CHILE :: SubLANGID
sUBLANG_SPANISH_CHILE =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_CHILE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_CHILE" prim_sUBLANG_SPANISH_CHILE :: IO (Word16)
sUBLANG_SPANISH_URUGUAY :: SubLANGID
sUBLANG_SPANISH_URUGUAY =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_URUGUAY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_URUGUAY" prim_sUBLANG_SPANISH_URUGUAY :: IO (Word16)
sUBLANG_SPANISH_PARAGUAY :: SubLANGID
sUBLANG_SPANISH_PARAGUAY =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_PARAGUAY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_PARAGUAY" prim_sUBLANG_SPANISH_PARAGUAY :: IO (Word16)
sUBLANG_SPANISH_BOLIVIA :: SubLANGID
sUBLANG_SPANISH_BOLIVIA =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_BOLIVIA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_BOLIVIA" prim_sUBLANG_SPANISH_BOLIVIA :: IO (Word16)
sUBLANG_SPANISH_EL_SALVADOR :: SubLANGID
sUBLANG_SPANISH_EL_SALVADOR =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_EL_SALVADOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_EL_SALVADOR" prim_sUBLANG_SPANISH_EL_SALVADOR :: IO (Word16)
sUBLANG_SPANISH_HONDURAS :: SubLANGID
sUBLANG_SPANISH_HONDURAS =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_HONDURAS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_HONDURAS" prim_sUBLANG_SPANISH_HONDURAS :: IO (Word16)
sUBLANG_SPANISH_NICARAGUA :: SubLANGID
sUBLANG_SPANISH_NICARAGUA =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_NICARAGUA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_NICARAGUA" prim_sUBLANG_SPANISH_NICARAGUA :: IO (Word16)
sUBLANG_SPANISH_PUERTO_RICO :: SubLANGID
sUBLANG_SPANISH_PUERTO_RICO =
  unsafePerformIO(
    prim_sUBLANG_SPANISH_PUERTO_RICO
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SPANISH_PUERTO_RICO" prim_sUBLANG_SPANISH_PUERTO_RICO :: IO (Word16)
sUBLANG_SWEDISH :: SubLANGID
sUBLANG_SWEDISH =
  unsafePerformIO(
    prim_sUBLANG_SWEDISH
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SWEDISH" prim_sUBLANG_SWEDISH :: IO (Word16)
sUBLANG_SWEDISH_FINLAND :: SubLANGID
sUBLANG_SWEDISH_FINLAND =
  unsafePerformIO(
    prim_sUBLANG_SWEDISH_FINLAND
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_SWEDISH_FINLAND" prim_sUBLANG_SWEDISH_FINLAND :: IO (Word16)
sUBLANG_URDU_PAKISTAN :: SubLANGID
sUBLANG_URDU_PAKISTAN =
  unsafePerformIO(
    prim_sUBLANG_URDU_PAKISTAN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_URDU_PAKISTAN" prim_sUBLANG_URDU_PAKISTAN :: IO (Word16)
sUBLANG_URDU_INDIA :: SubLANGID
sUBLANG_URDU_INDIA =
  unsafePerformIO(
    prim_sUBLANG_URDU_INDIA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_URDU_INDIA" prim_sUBLANG_URDU_INDIA :: IO (Word16)
sUBLANG_UZBEK_LATIN :: SubLANGID
sUBLANG_UZBEK_LATIN =
  unsafePerformIO(
    prim_sUBLANG_UZBEK_LATIN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_UZBEK_LATIN" prim_sUBLANG_UZBEK_LATIN :: IO (Word16)
sUBLANG_UZBEK_CYRILLIC :: SubLANGID
sUBLANG_UZBEK_CYRILLIC =
  unsafePerformIO(
    prim_sUBLANG_UZBEK_CYRILLIC
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32NLS_stub_ffi.h prim_sUBLANG_UZBEK_CYRILLIC" prim_sUBLANG_UZBEK_CYRILLIC :: IO (Word16)

-- % , SUBLANG_LITHUANIAN_CLASSIC (not in mingw-20001111)
