-- #hide
--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.OpenAL.AL.ALboolean
-- Copyright   :  (c) Sven Panne 2003-2004
-- License     :  BSD-style (see the file libraries/OpenAL/LICENSE)
-- 
-- Maintainer  :  sven.panne@aedion.de
-- Stability   :  provisional
-- Portability :  portable
--
-- This is a purely internal module for (un-)marshaling ALboolean.
--
--------------------------------------------------------------------------------

module Sound.OpenAL.AL.ALboolean (
   ALboolean, marshalALboolean, unmarshalALboolean
) where

import Sound.OpenAL.AL.BasicTypes ( ALboolean )

--------------------------------------------------------------------------------

marshalALboolean :: Bool -> ALboolean
marshalALboolean False = 0
marshalALboolean True  = 1

unmarshalALboolean :: ALboolean -> Bool
unmarshalALboolean = (/= 0)
