--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.ALUT.BuiltInSounds
-- Copyright   :  (c) Sven Panne 2005
-- License     :  BSD-style (see the file libraries/ALUT/LICENSE)
-- 
-- Maintainer  :  sven.panne@aedion.de
-- Stability   :  provisional
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Sound.ALUT.BuiltInSounds (
   helloWorld, Phase, Duration, sine, square, sawtooth, impulse, whiteNoise
)  where

import Sound.ALUT.Constants (
   alut_WAVEFORM_SINE, alut_WAVEFORM_SQUARE, alut_WAVEFORM_SAWTOOTH,
   alut_WAVEFORM_WHITENOISE, alut_WAVEFORM_IMPULSE )
import Sound.ALUT.Errors ( makeBuffer )
import Sound.OpenAL.AL.BasicTypes ( ALuint, ALenum, ALfloat )
import Sound.OpenAL.AL.Buffer ( Buffer )
import Sound.OpenAL.ALC.Context ( Frequency )

--------------------------------------------------------------------------------

helloWorld :: IO Buffer
helloWorld = makeBuffer "helloWorld" alutCreateBufferHelloWorld

foreign import CALLCONV unsafe "alutCreateBufferHelloWorld"
   alutCreateBufferHelloWorld :: IO ALuint

--------------------------------------------------------------------------------

type Phase = Float

type Duration = Float

sine :: Frequency -> Phase -> Duration -> IO Buffer
sine = createBufferWaveform "sine" alut_WAVEFORM_SINE

square :: Frequency -> Phase -> Duration -> IO Buffer
square = createBufferWaveform "square" alut_WAVEFORM_SQUARE

sawtooth :: Frequency -> Phase -> Duration -> IO Buffer
sawtooth = createBufferWaveform "sawtooth" alut_WAVEFORM_SAWTOOTH

impulse :: Frequency -> Phase -> Duration -> IO Buffer
impulse = createBufferWaveform "impulse" alut_WAVEFORM_IMPULSE

whiteNoise :: Duration -> IO Buffer
whiteNoise = createBufferWaveform "whiteNoise" alut_WAVEFORM_WHITENOISE 1 0

createBufferWaveform :: String -> ALenum -> Frequency -> Phase -> Duration -> IO Buffer
createBufferWaveform name shape frequency phase duration =
   makeBuffer name $
      alutCreateBufferWaveform shape frequency phase duration

foreign import CALLCONV unsafe "alutCreateBufferWaveform"
   alutCreateBufferWaveform :: ALenum -> ALfloat -> ALfloat -> ALfloat -> IO ALuint
