-- #hide
--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.OpenAL.ALUT.Exception
-- Copyright   :  (c) Sven Panne 2003-2004
-- License     :  BSD-style (see the file libraries/OpenGL/LICENSE)
-- 
-- Maintainer  :  sven.panne@aedion.de
-- Stability   :  provisional
-- Portability :  portable
--
-- This is a purely internal module to compensate for differences between
-- Haskell implementations.
--
--------------------------------------------------------------------------------

module Sound.OpenAL.ALUT.Exception (
   bracket_, finally
) where

#ifdef __NHC__
finally :: IO a -> IO b -> IO a
a `finally` sequel = do
   r <- a
   sequel
   return r

{-# INLINE bracket_ #-}
bracket_ :: IO a -> IO b -> IO c -> IO c
bracket_ before after thing = do
   before
   r <- thing
   after
   return r
#else
import Control.Exception ( bracket_, finally )
#endif
