with Grt.Types; use Grt.Types;

package Grt.Errors is
   pragma Preelaborate (Grt.Errors);

   --  Multi-call error procedure.
   --  Start and continue with Error_C, finish by an Error_E.
   procedure Error_C (Str : String);
   procedure Error_C (N : Integer);
   procedure Error_C (Str : Ghdl_C_String);
   --procedure Error_C (Inst : Ghdl_Instance_Name_Acc);
   procedure Error_E (Str : String);
   pragma No_Return (Error_E);

   --  Multi-call report procedure.  Do not exit at end.
   procedure Report_H (Str : String := "");
   procedure Report_C (Str : Ghdl_C_String);
   procedure Report_C (Str : String);
   procedure Report_C (N : Integer);
   procedure Report_E (Str : String);

   --  Complete error message.
   procedure Error (Str : String);

   --  Internal error.  The message must contain the subprogram name which
   --  has called this procedure.
   procedure Internal_Error (Msg : String);
   pragma No_Return (Internal_Error);

   --  Display a message which is not an error.
   procedure Info (Str : String);

   --  Called in case of premature exit.
   --  CODE is 0 for success, 1 for failure.
   procedure Ghdl_Exit (Code : Integer);

   type Exit_Cb_Type is access procedure (Code : Integer);
   pragma Convention (C, Exit_Cb_Type);

   Ghdl_Exit_Cb : Exit_Cb_Type := null;
   Ghdl_Exit_Cb1 : Exit_Cb_Type := null;

   --  If true, an error is expected and the exit status is inverted.
   Expect_Failure : Boolean := False;

private
   pragma Export (C, Ghdl_Exit_Cb, "__ghdl_exit_cb");

   pragma No_Return (Error);
   pragma No_Return (Ghdl_Exit);
end Grt.Errors;

