with System; use System;

package Grt.Stacks is
   type Stack_Type is new Address;
   Null_Stack : constant Stack_Type := Stack_Type (Null_Address);

   --  The main stack.  This is initialized by STACK_INIT.
   --  The return point.
   Main_Stack : Stack_Type;

   --  Initialize the stacks package.
   --  This may adjust stack sizes.
   --  Must be called after grt.options.decode.
   procedure Stack_Init;

   --  Create a new stack, which on first execution will call FUNC with
   --  an argument ARG.
   function Stack_Create (Func : Address; Arg : Address) return Stack_Type;

   --  Resume stack TO and save the current context to the stack pointed by
   --  CUR.
   procedure Stack_Switch (To : Stack_Type; From : Stack_Type);

   --  Delete stack STACK, which must not be currently executed.
   procedure Stack_Delete (Stack : Stack_Type);

   --  Error during stack handling:
   --  Cannot grow the stack.
   procedure Error_Grow_Failed;
   pragma No_Return (Error_Grow_Failed);

   --  Invalid memory access detected (other than dereferencing a NULL access).
   procedure Error_Memory_Access;
   pragma No_Return (Error_Memory_Access);

   --  A NULL access is dereferenced.
   procedure Error_Null_Access;
   pragma No_Return (Error_Null_Access);
private
   pragma Export (C, Main_Stack, "grt_stack_main_stack");

   pragma Import (C, Stack_Init, "grt_stack_init");
   pragma Import (C, Stack_Create, "grt_stack_create");
   pragma Import (C, Stack_Switch, "grt_stack_switch");
   pragma Import (C, Stack_Delete, "grt_stack_delete");

   pragma Export (C, Error_Grow_Failed, "grt_stack_error_grow_failed");
   pragma Export (C, Error_Memory_Access, "grt_stack_error_memory_access");
   pragma Export (C, Error_Null_Access, "grt_stack_error_null_access");
end Grt.Stacks;
