with Types; use Types;
with Std_Names; use Std_Names;
with Ieee.Std_Logic_1164;
with Ieee.Vital_Timing;
with Flags; use Flags;

package body Post_Sems is
   procedure Post_Sem_Checks (Unit : Iir_Design_Unit)
   is
      Lib_Unit : Iir;
      Lib : Iir_Library_Declaration;
      Id : Name_Id;

      Attr_List : Iir_List;
      Value : Iir_Attribute_Value;
      Spec : Iir_Attribute_Specification;
      Attr_Decl : Iir_Attribute_Declaration;
   begin
      Lib_Unit := Get_Library_Unit (Unit);
      Id := Get_Identifier (Lib_Unit);
      Lib := Get_Parent (Get_Design_File (Unit));

      if Get_Identifier (Lib) = Name_Ieee then
         --  This is a unit of IEEE.
         if Get_Kind (Lib_Unit) = Iir_Kind_Package_Declaration then
            if Id = Name_Std_Logic_1164 then
               Ieee.Std_Logic_1164.Extract_Declarations (Lib_Unit);
            elsif Id = Name_VITAL_Timing then
               Ieee.Vital_Timing.Extract_Declarations (Lib_Unit);
            end if;
         end if;
      end if;

      --  Look for VITAL attributes.
      Attr_List := Get_Attribute_Value_List (Unit);
      if Flag_Vital_Checks and then Attr_List /= Null_Iir_List then
         for I in Natural loop
            Value := Get_Nth_Element (Attr_List, I);
            exit when Value = Null_Iir;
            Spec := Get_Attribute_Specification (Value);
            Attr_Decl := Get_Attribute_Designator (Spec);
            if Attr_Decl = Ieee.Vital_Timing.Vital_Level0_Attribute then
               Ieee.Vital_Timing.Check_Vital_Level0 (Unit);
            elsif Attr_Decl = Ieee.Vital_Timing.Vital_Level1_Attribute then
               Ieee.Vital_Timing.Check_Vital_Level1 (Unit);
            end if;
         end loop;
      end if;
   end Post_Sem_Checks;
end Post_Sems;

