with Flags;
with Types; use Types;
with Iirs_Utils; use Iirs_Utils;

package body Back_End is
   -- Transform a library identifier into a file name.
   -- Very simple mechanism: just add '-simVV.cf' extension, where VV
   -- is the version.
   function Default_Library_To_File_Name (Library: Iir_Library_Declaration)
     return String
   is
   begin
      case Flags.Vhdl_Std is
         when Vhdl_87 =>
            return Image_Identifier (Library) & "-obj87.cf";
         when Vhdl_93c | Vhdl_93 | Vhdl_00 | Vhdl_02 =>
            return Image_Identifier (Library) & "-obj93.cf";
      end case;
   end Default_Library_To_File_Name;
end Back_End;
