// MM1RBN.CPP

// Copyright (C) 1998 Tommi Hassinen, Jarno Huuskonen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm1rbn.h"	// config.h is here -> we get ENABLE-macros here...

#ifdef ENABLE_GRAPHICS
#include "mm1docv.h"
#include "spline.h"

/*################################################################################################*/

// will not work if there is less than 3 residues !!!!!!!!!!!!!!!!!!!!!!!
// will not work if there is less than 3 residues !!!!!!!!!!!!!!!!!!!!!!!
// will not work if there is less than 3 residues !!!!!!!!!!!!!!!!!!!!!!!

const i32s mm1_ribbon::resol = 10;

const fGL mm1_ribbon::width = 0.15;
const fGL mm1_ribbon::helix = 0.10;

mm1_ribbon::mm1_ribbon(mm1_docv * p1, color_mode * p9, i32s p2, i32s order) : smart_object()
{
	docv = p1; cmode = p9;
	chn = p2; extra_points = order - 2;
	
	vector<mm1_chn_info> & ci_vector = (* docv->ref_civ);
	
	if (ci_vector[chn].type != mm1_chn_info::amino_acid)
	{
		docv->err->ErrorMessage("The chain type is not correct (\"amino_acid\").\nThe program will terminate.");
		exit(EXIT_FAILURE);
	}
	
	if (ci_vector[chn].length < 3)
	{
		docv->err->ErrorMessage("Tried to create a ribbon with less than 3 residues.\nThe program will terminate.");
		exit(EXIT_FAILURE);
	}
	
	char * state = new char[ci_vector[chn].length];
	
	// the default state is always loop. strands have the same places as in K&S.
	// helices are shifted: the smallest helical peptide is "4...." -> "LHHHL"!!!!!
	
	for (i32s n1 = 0;n1 < ci_vector[chn].length;n1++)
	{
		state[n1] = 'L';
		if (ci_vector[chn].state[n1] == 'S') state[n1] = 'S';
	}
	
	for (i32s n1 = 0;n1 < ((i32s) ci_vector[chn].length) - 3;n1++)
	{
		if (ci_vector[chn].state[n1] == '4')
		{
			state[n1 + 1] = 'H';
			state[n1 + 2] = 'H';
			state[n1 + 3] = 'H';
		}
	}
	
	iter_mm1al range1[2];
	docv->GetRange(1, chn, range1);
	
	length = ci_vector[chn].length - 1;
	
	cp1 = new fGL_a3[length];
	cp2 = new fGL_a3[length];
	
	data3 = new fGL_a3[length];
	
	v3d<fGL> oldv4; bool flag = true;
	for (i32s n1 = 0;n1 < length;n1++)
	{
		fGL_a4 color1 = { 0.0, 0.0, 1.0, 1.0 };		// loop
		if (state[n1 + 0] == 'H') { color1[0] = 1.0; color1[1] = 0.0; color1[2] = 0.0; }
		if (state[n1 + 0] == 'S') { color1[0] = 0.0; color1[1] = 1.0; color1[2] = 0.0; }
		
		fGL_a4 color2 = { 0.0, 0.0, 1.0, 1.0 };		// loop
		if (state[n1 + 1] == 'H') { color2[0] = 1.0; color2[1] = 0.0; color2[2] = 0.0; }
		if (state[n1 + 1] == 'S') { color2[0] = 0.0; color2[1] = 1.0; color2[2] = 0.0; }
		
		iter_mm1al range2a[2]; docv->GetRange(2, range1, n1, range2a);
		iter_mm1al range2b[2]; docv->GetRange(2, range1, n1 + 1, range2b);
		
		iter_mm1al itc1 = range2a[0]; while (itc1 != range2a[1] && ((* itc1).res_id & 0xFF) != 0x01) itc1++;
		if (itc1 == range2a[1]) { itc1 = range2a[0]; cout << "WARNING : search of C1 failed." << endl; }
		iter_mm1al itc2 = range2b[0]; while (itc2 != range2b[1] && ((* itc2).res_id & 0xFF) != 0x01) itc2++;
		if (itc2 == range2b[1]) { itc2 = range2b[0]; cout << "WARNING : search of C2 failed." << endl; }
		
		iter_mm1al ito = range2a[0]; while (ito != range2a[1] && ((* ito).res_id & 0xFF) != 0x10) ito++;
		if (ito == range2a[1]) { ito = range2a[0]; cout << "WARNING : search of O1 failed." << endl; }
		
		v3d<fGL> v1 = v3d<fGL>((* itc1).crd_vector[0].data, (* itc2).crd_vector[0].data);
		v3d<fGL> v2 = v3d<fGL>((* itc1).crd_vector[0].data, (* ito).crd_vector[0].data);
		
		v3d<fGL> v3 = v1.vpr(v2); v3 = v3 / v3.len();
		v3d<fGL> v4 = v3.vpr(v1); v4 = v4 / v4.len();
		
		v3d<fGL> v5 = v3d<fGL>((* itc1).crd_vector[0].data);
		v5 = v5 + (v1 / 2.0);
		
		i32s helix_count = 0;
		if (ci_vector[chn].state[n1 - 2] == '4') helix_count++;
		if (ci_vector[chn].state[n1 - 1] == '4') helix_count++;
		v5 = v5 + (v3 * ((fGL) helix_count * helix));
		
		v3d<fGL> v6 = v5 + (v4 * width);
		v3d<fGL> v7 = v5 - (v4 * width);
		
		if (n1 != 0 && v4.ang(oldv4) > M_PI / 2.0) flag = !flag;
		oldv4 = v4;
		
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			if (flag)
			{
				cp1[n1][n2] = v6[n2];
				cp2[n1][n2] = v7[n2];
			}
			else
			{
				cp1[n1][n2] = v7[n2];
				cp2[n1][n2] = v6[n2];
			}
			
			data3[n1][n2] = (color1[n2] + color2[n2]) / 2.0;
		}
	}
	
	ref1 = new spline(order, length + extra_points * 2);
	
	head_points1 = new fGL_a3[extra_points];
	tail_points1 = new fGL_a3[extra_points];
	
	head_refs1[0] = & cp1[1]; head_refs1[1] = & cp1[0];
	tail_refs1[0] = & cp1[length - 2]; tail_refs1[1] = & cp1[length - 1];
	
	ref2 = new spline(order, length + extra_points * 2);
	
	head_points2 = new fGL_a3[extra_points];
	tail_points2 = new fGL_a3[extra_points];
	
	head_refs2[0] = & cp2[1]; head_refs2[1] = & cp2[0];
	tail_refs2[0] = & cp2[length - 2]; tail_refs2[1] = & cp2[length - 1];
	
	UpdateExtraPoints(head_refs1, head_points1, tail_refs1, tail_points1);
	UpdateExtraPoints(head_refs2, head_points2, tail_refs2, tail_points2);
	
	for (i32s n1 = 0;n1 < extra_points;n1++)
	{
		ref1->SetPoint(n1, & head_points1[extra_points - (n1 + 1)]);
		ref2->SetPoint(n1, & head_points2[extra_points - (n1 + 1)]);
	}
	
	for (i32s n1 = 0;n1 < extra_points;n1++)
	{
		ref1->SetPoint(extra_points + length + n1, & tail_points1[n1]);
		ref2->SetPoint(extra_points + length + n1, & tail_points2[n1]);
	}
	
	for (i32s n1 = 0;n1 < length;n1++)
	{
		ref1->SetPoint(extra_points + n1, & cp1[n1]);
		ref2->SetPoint(extra_points + n1, & cp2[n1]);
	}
	
	for (i32s n1 = 0;n1 < length + extra_points * 2 + order;n1++)
	{
		ref1->SetKnot(n1, (fGL) (n1 - extra_points) - (fGL) order / 2.0);
		ref2->SetKnot(n1, (fGL) (n1 - extra_points) - (fGL) order / 2.0);
	}
	
	list_id = docv->GetDisplayListIDs(1);
	
	MakeRibbon();
}

mm1_ribbon::~mm1_ribbon(void)
{
	delete[] cp1;
	delete[] cp2;
	
	delete ref1;
	delete[] head_points1;
	delete[] tail_points1;
	
	delete ref2;
	delete[] head_points2;
	delete[] tail_points2;
	
	delete[] data1;
	delete[] data2a;
	delete[] data2b;
	delete[] data3;
	
	docv->DeleteDisplayLists(list_id, 1);
}

void mm1_ribbon::MakeRibbon(void)
{
	i32s np1 = resol * (length - 1);
	i32s np2 = np1 + 1;
	
	data1 = new fGL[np2];
	data2a = new fGL_a3[np2];
	data2b = new fGL_a3[np2];
	
	vector<mm1_chn_info> & ci_vector = (* docv->ref_civ);
	
	for (i32s n1 = 0;n1 < np2;n1++)
	{
		data1[n1] = ((fGL) (length - 1) * n1) / (fGL) np1;
		
		fGL ribbon_width = 0.75;
		if (ci_vector[chn].state != NULL)
		{
			i32s index = (i32s) floor(data1[n1] + 0.5);
			
			char state1[2]; char state2[2];
			state1[0] = ci_vector[chn].state[index - 2];
			state1[1] = ci_vector[chn].state[index - 1];
			state2[0] = ci_vector[chn].state[index + 0];
			state2[1] = ci_vector[chn].state[index + 1];
			
			fGL width1 = 0.5; if (state1[0] == '4' || state2[0] == 'S') width1 = 1.0;
			fGL width2 = 0.5; if (state1[1] == '4' || state2[1] == 'S') width2 = 1.0;
			
			fGL ang = M_PI * ((data1[n1] + 0.5) - (fGL) index) / 2.0;
			fGL p1 = cos(ang); fGL w1 = width1 * p1 * p1;
			fGL p2 = sin(ang); fGL w2 = width2 * p2 * p2;
			ribbon_width = w1 + w2;
		}
		
		fGL_a3 p1; ref1->Compute(data1[n1], p1);
		fGL_a3 p2; ref2->Compute(data1[n1], p2);
		
		v3d<fGL> v1 = v3d<fGL>(p1);
		v3d<fGL> v2 = v3d<fGL>(p1, p2); v2 = v2 / 2.0;
		
		v3d<fGL> v3 = (v1 + v2) - (v2 * ribbon_width);
		v3d<fGL> v4 = (v1 + v2) + (v2 * ribbon_width);
		
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			data2a[n1][n2] = v3[n2];
			data2b[n1][n2] = v4[n2];
		}
	}
}

void mm1_ribbon::UpdateExtraPoints(fGL_a3 ** hr, fGL_a3 * hp, fGL_a3 ** tr, fGL_a3 * tp)
{
	v3d<fGL> tmpv1; v3d<fGL> tmpv2;
	
	tmpv1 = v3d<fGL>(* hr[1]);
	tmpv2 = v3d<fGL>(* hr[0], * hr[1]);
	for (i32s n1 = 0;n1 < extra_points;n1++)
	{
		v3d<fGL> tmpv3 = tmpv1 + (tmpv2 * ((fGL) n1 + 1));
		for (i32s n2 = 0;n2 < 3;n2++) hp[n1][n2] = tmpv3[n2];
	}
	
	tmpv1 = v3d<fGL>(* tr[1]);
	tmpv2 = v3d<fGL>(* tr[0], * tr[1]);
	for (i32s n1 = 0;n1 < extra_points;n1++)
	{
		v3d<fGL> tmpv3 = tmpv1 + (tmpv2 * ((fGL) n1 + 1));
		for (i32s n2 = 0;n2 < 3;n2++) tp[n1][n2] = tmpv3[n2];
	}
}

void mm1_ribbon::Render(void)
{
	if (glIsList(list_id) == GL_TRUE) glCallList(list_id);
	else
	{
		glNewList(list_id, GL_COMPILE_AND_EXECUTE);
		
		i32s np1 = resol * (length - 1);
		
		glEnable(GL_LIGHTING);
		glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, true);
		
		glBegin(GL_TRIANGLES);
		for (i32s n1 = 0;n1 < np1;n1++)
		{
			v3d<fGL> va = v3d<fGL>(data2a[n1 + 0], data2b[n1 + 0]);
			v3d<fGL> vb = v3d<fGL>(data2a[n1 + 1], data2b[n1 + 1]);
			
			v3d<fGL> vc = v3d<fGL>(data2a[n1 + 0], data2a[n1 + 1]);
			v3d<fGL> vd = v3d<fGL>(data2b[n1 + 0], data2b[n1 + 1]);
			
			v3d<fGL> vA1 = va.vpr(vc); v3d<fGL> vA2 = vb.vpr(vc);
			v3d<fGL> vB1 = va.vpr(vd); v3d<fGL> vB2 = vb.vpr(vd);
			
			if (n1 != 0)
			{
				v3d<fGL> ve = v3d<fGL>(data2a[n1 + 0], data2a[n1 - 1]);
				v3d<fGL> vf = v3d<fGL>(data2b[n1 + 0], data2b[n1 - 1]);
				vA1 = vA1 + (ve.vpr(va)); vB1 = vB1 + (vf.vpr(va));
			}
			
			if (n1 != (np1 - 1))
			{
				v3d<fGL> vg = v3d<fGL>(data2a[n1 + 1], data2a[n1 + 2]);
				v3d<fGL> vh = v3d<fGL>(data2b[n1 + 1], data2b[n1 + 2]);
				vA2 = vA2 + (vb.vpr(vg)); vB2 = vB2 + (vb.vpr(vh));
			}
			
			vA1 = vA1 / vA1.len(); vA2 = vA2 / vA2.len();
			vB1 = vB1 / vB1.len(); vB2 = vB2 / vB2.len();
			
			i32s index = (i32s) floor(data1[n1]);
			fGL_a3 color1; fGL mod1 = data1[n1 + 0] - (fGL) index;
			fGL_a3 color2; fGL mod2 = data1[n1 + 1] - (fGL) index;
			
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				color1[n2] = data3[index][n2] * (1.0 - mod1) + data3[index + 1][n2] * mod1;
				color2[n2] = data3[index][n2] * (1.0 - mod2) + data3[index + 1][n2] * mod2;
			}
			
			glColor3fv(color2);
			glNormal3fv(vA2.data); glVertex3fv(data2a[n1 + 1]);
			
			glColor3fv(color1);
			glNormal3fv(vA1.data); glVertex3fv(data2a[n1 + 0]);
			glNormal3fv(vB1.data); glVertex3fv(data2b[n1 + 0]);
			
			glColor3fv(color1);
			glNormal3fv(vB1.data); glVertex3fv(data2b[n1 + 0]);
			
			glColor3fv(color2);
			glNormal3fv(vB2.data); glVertex3fv(data2b[n1 + 1]);
			glNormal3fv(vA2.data); glVertex3fv(data2a[n1 + 1]);
		}
		
		glEnd();	// GL_TRIANGLES
		
		glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, false);
		glDisable(GL_LIGHTING);
		
		glEndList();
	}
}

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS

// eof
