// QM2DOCV.H : a graphical user interface for qm2-models.

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef QM2DOCV_H
#define QM2DOCV_H

#ifdef ENABLE_GRAPHICS

class qm2_docv;

/*################################################################################################*/

#include "docview.h"
#include "qm2mdl.h"

/*################################################################################################*/

class qm2_docv : virtual public docview, public qm2_mdl
{
	protected:
	
	public:
	
	qm2_docv(ostream *, graphics_class_factory &);
	virtual ~qm2_docv(void);

	fGL GetDefaultFocus(void);		// virtual
	
	const char * GetType(void);			// virtual
	color_mode * GetDefaultColorMode(void);		// virtual
	
	void SelectAll(void);				// virtual
	void InvertSelection(void);			// virtual
	
	void Render(graphics_view *, rmode);		// virtual
	
	void Center(transformer *);			// virtual
	void Transform(transformer *);			// virtual
	
	void DrawEvent(graphics_view *, vector<iGLu> &);	// virtual
	void EraseEvent(graphics_view *, vector<iGLu> &);	// virtual
	void SelectEvent(graphics_view *, vector<iGLu> &);	// virtual
	void MeasureEvent(graphics_view *, vector<iGLu> &);	// virtual
	
	void ProcessCommandString(graphics_view *, const char *);	// virtual
};

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS
#endif	// QM2DOCV_H

// eof
