// T2MM2DOCV.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t2mm2docv.h"

#include "mm2alg.h"
#include "mm2rbn.h"

#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

#include <fstream>
#include <strstream>
using namespace std;

/*################################################################################################*/

glut_mm2_docv::glut_mm2_docv(ostream * p1, glut_class_factory & p2, mm2_eng_param * p3) :
	glut_docv(p1, p2), mm2_docv(p1, p2, p3), docview(p1, p2), model_simple(p1, p2)
{
}

glut_mm2_docv::~glut_mm2_docv(void)
{
}

void glut_mm2_docv::KeyEvent(graphics_view * gv, char key, int, int)
{
	i32s n1; i32s n2;
	i32s t1a; i32s t1b;
	fGL t2a; fGL t2b;
	char input;
	
	ifstream ifile;
	ofstream ofile;
	
	smart_object * NewObject;
	
	mm2_eng * eng;
	
	fGL tmp1; fGL tmp2;
	i32s sz[3] = { 50, 50, 50 };
	fGL dm[3] = { 0.55, 0.50, 0.45 };
	
	cp_param cpp;
	cpp.np = 30; cpp.docv = this; cpp.ref = (mm2_docv *) this;
	
	cs_param csp1;
	csp1.np = sz; csp1.dim = dm; csp1.docv = this;
	csp1.ref = (mm2_docv *) this; csp1.next = NULL;
	
	cs_param csp2a; cs_param csp2b;
	csp2a.np = sz; csp2a.dim = dm; csp2a.docv = this;
	csp2a.ref = (mm2_docv *) this; csp2a.next = & csp2b;
	csp2b.np = sz; csp2b.dim = dm; csp2b.docv = this;
	csp2b.ref = (mm2_docv *) this; csp2b.next = NULL;

	mm2_geomopt_param goparam;
	mm2_moldyn_param mdparam;
	
	switch (key)
	{
		case 'h':
		cout << "C         -> change color modes" << endl;
		cout << "r         -> change the rendering mode (without updating view)" << endl;
		cout << "Q         -> change labels" << endl;
		
		cout << "i         -> import ENT-files (Brookhaven PDB)" << endl;
		cout << "O         -> open a file" << endl;
		cout << "S         -> save to a file" << endl;

		cout << "s         -> process a command string" << endl;
		
		cout << "p         -> add (or \"push\") a new coordinate set" << endl;
		cout << "0         -> superimpose the crd-sets and measure RMS-error" << endl;
		cout << "T         -> change constraints for selected VA's" << endl;
		cout << "W         -> update the constraints" << endl;
		
		cout << "z         -> compare numerical and analytical gradient" << endl;
		cout << "E         -> compute energy [kJ/mol]" << endl;
		cout << "o         -> geometry optimization..." << endl;
		cout << "d         -> molecular dynamics..." << endl;

		cout << "t         -> build a protein ribbon model" << endl;
		cout << "e w n m   -> make some nice planes/surfaces..." << endl;
		
		cout << "X         -> trajectory mode on/off" << endl;
		cout << "1 2 7     -> (in traj-mode) get prev/next/desired frame" << endl;
		cout << "5         -> (in traj-mode) play the trajectory file" << endl;
		break;
		
		case 'C':
		if (gv->colormode == & mm2_docv::cm_state) gv->colormode = & mm2_docv::cm_residue;
		else if (gv->colormode == & mm2_docv::cm_residue) gv->colormode = & mm2_docv::cm_sasa;
		else if (gv->colormode == & mm2_docv::cm_sasa) gv->colormode = & mm2_docv::cm_state;
		UpdateAllGraphicsViews();
		break;
		
		case 'r':
		cout << "rendering = ";
		switch (gv->render)
		{
			case RENDER_NOTHING:
			gv->render = RENDER_WIREFRAME;
			cout << "RENDER_WIREFRAME";
			break;
			
			case RENDER_WIREFRAME:
			gv->render = RENDER_BALL_AND_STICK;
			cout << "RENDER_BALL_AND_STICK";
			break;
			
			case RENDER_BALL_AND_STICK:
			gv->render = RENDER_VAN_DER_WAALS;
			cout << "RENDER_VAN_DER_WAALS";
			break;
			
			case RENDER_VAN_DER_WAALS:
			gv->render = RENDER_ACCESSIBLE;
			cout << "RENDER_ACCESSIBLE";
			break;
			
			case RENDER_ACCESSIBLE:
			gv->render = RENDER_CYLINDERS;
			cout << "RENDER_CYLINDERS";
			break;
			
			case RENDER_CYLINDERS:
			gv->render = RENDER_NOTHING;
			cout << "RENDER_NOTHING";
			break;
		}
		cout << endl;
		break;
		
		case 'Q':
		cout << "label = ";
		switch (gv->label)
		{
			case LABEL_NOTHING:
			gv->label = LABEL_RESIDUE;
			cout << "LABEL_RESIDUE";
			break;
			
		// LABEL_INDEX to display charges???
			case LABEL_RESIDUE:
			gv->label = LABEL_INDEX;
			cout << "LABEL_INDEX";
			break;
			
			case LABEL_INDEX:
			gv->label = LABEL_NOTHING;
			cout << "LABEL_NOTHING";
			break;
		}
		cout << endl;
		break;
		
		case 'i':
		cout << "import ENT: filename ??? "; cin >> buffer;
		cout << "give the index of chain to be imported, or -1 to import all ??? "; cin >> n1;
		ImportPDB(buffer, n1); UpdateAllGraphicsViews();
		break;
		
		case 'O':
		cout << "name of file to open ??? "; cin.getline(buffer, sizeof(buffer));
		ifile.open(buffer, ios::in); ReadStream(ifile); ifile.close();
		UpdateAllGraphicsViews();
		break;
		
		case 'S':
		cout << "name of file to save ??? "; cin.getline(buffer, sizeof(buffer));
		ofile.open(buffer, ios::out); WriteStream(ofile); ofile.close();
		break;

		case 's':
		cout << "command string ??? "; cin.getline(buffer, sizeof(buffer));
		ProcessCommandString(gv, buffer);
		break;
		
		case 'p':
		PushCRDSets(1); t1a = cs_vector.size() - 1;
		while (t1a > 0) { CopyCRDSet(t1a - 1, t1a); t1a -= 1; }
		cs_vector.back()->visible = true;
		UpdateAllGraphicsViews();
		break;
		
		case '0': t2a = 0.0;
		for (t1a = 0;t1a < ((i32s) cs_vector.size()) - 1;t1a++)
		{
			// the 'p'-command above adds new sets to front, so we will
			// superimpose to the last one here (which was saved first).
			
			mm2_superimpose si(this, ((i32s) cs_vector.size()) - 1, t1a);
			for (t1b = 0;t1b < 100;t1b++) si.TakeCGStep(conjugate_gradient::Newton2An);
			
			t2b = si.GetRMS(); t2a += t2b; si.Transform();
			cout << t1a << " RMS-distance = " << t2b << endl;
		}
		cout << "average = " << (t2a / (((fGL) cs_vector.size()) - 1.0)) << endl;
		UpdateAllGraphicsViews();
		break;
		
		case 'T':
		for (n1 = 0;n1 < (i32s) chn_vector.size();n1++)
		{
			for (n2 = 0;n2 < (i32s) chn_vector[n1].res_vector.size();n2++)
			{
				if (!chn_vector[n1].res_vector[n2].sel) continue;
				switch (chn_vector[n1].res_vector[n2].state)
				{
					case STATE_HELIX:
					chn_vector[n1].res_vector[n2].state = STATE_STRAND;
					cout << "chn " << n1 << " res " << n2 << " is now S" << endl;
					break;
					
					case STATE_STRAND:
					chn_vector[n1].res_vector[n2].state = STATE_LOOP;
					cout << "chn " << n1 << " res " << n2 << " is now L" << endl;
					break;
					
					case STATE_LOOP:
					chn_vector[n1].res_vector[n2].state = STATE_HELIX;
					cout << "chn " << n1 << " res " << n2 << " is now H" << endl;
					break;
				}
			}
		}
		break;
		
		case 'W':
		cout << "do you REALLY want to UC (123 = Ok) ??? "; cin >> n1;
		if (n1 != 123) break; else UpdateConstraints();
		break;
		
		case 'z':
		eng = new mm2_eng(* this);
		CopyCRD(this, eng, 0); eng->Check(1);
		delete eng;
		break;
		
		case 'E':
		DoEnergy();
		break;
		
		case 'o':
		goparam.treshold_nsteps = 500;
		DoGeomOpt(goparam);
		break;
		
		case 'd':
		mdparam.nsteps = 10000;
		mdparam.temperature = 300.0;
		mdparam.timestep = 5.0;
		DoMolDyn(mdparam);
		break;
		
		case 't':
		for (t1a = 0;t1a < (i32s) chn_vector.size();t1a++)
		{
			NewObject = new mm2_ribbon(this, gv->colormode, t1a, 4);	// min. order is 2!!!
			AddObject(NewObject);
		}
		UpdateAllGraphicsViews();
		break;
		
		case 'e':
		cout << "give dimension of the plane [nm] (2.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) mm2_GetESPValue; cpp.cf = (ColorFunction *) GetRBRange1;
		cpp.value = 138.9354518 / 10.0; cpp.alpha = 0.75;
		
		AddObject(new color_plane_object(ol_static(), cpp, "ESP-"));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'w':
		cout << "give dimension of the volume [nm] (2.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) mm2_GetESPValue; cpp.cf = (ColorFunction *) GetRBRange1;
		cpp.value = 138.9354518 / 10.0; cpp.alpha = 0.25;
		
		AddObject(new volume_rendering_object(ol_static(), cpp, 20, tmp1 / 2.0, (* gv->cam), "ESP-"));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'n': tmp1 = 138.9354518 / 10.0;
		cout << "give dimension of the surface [nm] (5.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp2a.wireframe = csp2b.wireframe = (input == 'w' || input == 'W');
		
		csp2a.transparent = !true;
		csp2a.vf1 = (ValueFunction *) mm2_GetESPValue; csp2a.vf2 = (ValueFunction *) GetUnity;
		csp2a.cvalue = 1.0; csp2a.alpha = 0.25; csp2a.toler = 1.0e-6 * tmp1; csp2a.maxc = 500;
			csp2a.cf = (ColorFunction *) GetRedColor; csp2a.svalue = +tmp1;
			
		csp2b.transparent = !true;
		csp2b.vf1 = (ValueFunction *) mm2_GetESPValue; csp2b.vf2 = (ValueFunction *) GetUnity;
		csp2b.cvalue = 1.0; csp2b.alpha = 0.25; csp2b.toler = 1.0e-6 * tmp1; csp2b.maxc = 500;
			csp2b.cf = (ColorFunction *) GetBlueColor; csp2b.svalue = -tmp1;
			
		AddObject(new color_surface_object(ol_static(), csp2a, "ESP-"));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'm': tmp1 = 138.9354518 / 10.0;
		cout << "give dimension of the surface [nm] (5.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp1.wireframe = (input == 'w' || input == 'W');
		
		csp1.transparent = true; csp1.cf = (ColorFunction *) GetRBRange1;
		csp1.vf1 = (ValueFunction *) mm2_GetSASValue; csp1.vf2 = (ValueFunction *) mm2_GetESPValue;
		csp1.svalue = 1.0; csp1.cvalue = tmp1; csp1.alpha = 0.50; csp1.toler = 1.0e-6 * tmp1; csp1.maxc = 500;
		
		AddObject(new color_surface_object(ol_static(), csp1, "ESP-colored SA-"));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'X':
		if (GetTrajectoryFile() != NULL)
		{
			cout << "traj mode off" << endl;
			CloseTrajectory();
		}
		else
		{
			cout << "traj mode on" << endl;
			cout << "traj-file name ??? "; cin >> buffer;
			OpenTrajectory(buffer);
		}
		break;
		
		case '1':
		case '2':
		case '7':
		if (GetTrajectoryFile() != NULL)
		{
			i32s frame = GetCurrentFrame();
			
			switch (key)
			{
				case '1':
				frame--; if (frame < 0) frame = 0;
				break;
				
				case '2':
				frame++; if (frame == GetTotalFrames()) frame = GetTotalFrames() - 1;
				break;
				
				default:
				cout << "give the frame (in correct range) ??? "; cin >> frame;
			}
			
			cout << "frame = " << frame << endl;
			
			SetCurrentFrame(frame);
			ReadFrame();
			
			UpdateAllGraphicsViews();
		} else cout << "in traj-mode only!!!" << endl;
		break;
		
		case '5':
		if (GetTrajectoryFile() != NULL)
		{
			for (i32s loop = 0;loop < GetTotalFrames();loop++)
			{
				SetCurrentFrame(loop);
				ReadFrame();
				
				UpdateAllGraphicsViews(true);
			}
		} else cout << "in traj-mode only!!!" << endl;
		break;
		
		default:
		cout << "unknown command '" << key << "'" << endl;
	}
}

/*##############################################*/
/*##############################################*/

void glut_mm2_docv::GeomOptGetParam(mm2_geomopt_param & param)
{
	cout << "how many cg-steps (" << param.treshold_nsteps << " might be Ok, -1 = cancel) ??? ";
	cin >> param.treshold_nsteps;
	
	param.enable_nsteps = true;
	param.enable_grad = false; param.treshold_grad = 0.0;		// skip the other tests...
	param.enable_delta_e = false; param.treshold_delta_e = 0.0;	// skip the other tests...
	
	param.confirm = !(param.treshold_nsteps < 0);
}

#define START 10000	// see mm1docv.cpp!!!!!!!!

void glut_mm2_docv::MolDynGetParam(mm2_moldyn_param & param)
{
	cout << "how many md-steps for simulation (" << param.nsteps << " might be Ok, -1 = cancel) ??? ";
	cin >> param.nsteps;
	
	param.confirm = !(param.nsteps < 0);
	if (!param.confirm) return;
	
	cout << "there are also " << START << " heating steps, total steps = " << (START + param.nsteps) << endl;
	cout << "the trajectory file will contain " << (param.nsteps / 100) << " frames!!!" << endl;
	
	cout << "simulation temperature [K] (" << param.temperature << " might be Ok) ??? ";
	cin >> param.temperature;
	
	cout << "time-step length [fs] (" << param.timestep << " might be Ok) ??? ";
	cin >> param.timestep;
	
	cout << "traj-file name ??? ";
	cin >> param.filename;
}

/*################################################################################################*/

// eof
