// SETUP_MM1_DIALOG.CPP

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "setup_mm1_dialog.h"

#include "filetrans.h"
#include "t3mm1docv.h"
#include "t3docv.h"

#include <gnome.h>

#include <iostream>
#include <strstream>
using namespace std;

/*################################################################################################*/

setup_mm1_dialog::setup_mm1_dialog(void) : glade_dialog("glade/setup_mm1_dialog.glade")
{
	dialog = glade_xml_get_widget(xml, "setup_mm1_dialog");
	if (dialog == NULL) { cout << "setup_mm1_dialog : glade_xml_get_widget() failed!!!" << endl; return; }
	
	// initialize the widgets...
	
	GtkWidget * optmenu = glade_xml_get_widget(xml, "optionmenu1");
	GtkWidget * submenu = gtk_menu_new(); GtkWidget * item;
	
	int eng_index = 0;
	while (mm1_mdl::engtab1[eng_index] != NULL)	// this is for engines...
	{
		item = gtk_menu_item_new_with_label(mm1_mdl::engtab1[eng_index]);
		gtk_widget_show(item); gtk_menu_append(GTK_MENU(submenu), item);
		
		eng_index++;
	}
	
	gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu), submenu);
	
	gnome_mm1_docv * owner = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (!owner) cout << "ERROR: cast failed in setup_mm1_dialog ctor." << endl;
	else						// this will set the current engine...
	{
		eng_index = owner->default_eng;
		gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu), eng_index);
	}
	
	char buffer[64];
	GtkWidget * entry_dimx = glade_xml_get_widget(xml, "entry_dimx");
	GtkWidget * entry_dimy = glade_xml_get_widget(xml, "entry_dimy");
	GtkWidget * entry_dimz = glade_xml_get_widget(xml, "entry_dimz");
	
	ostrstream str_dimx(buffer, sizeof(buffer));
	str_dimx.setf(ios::fixed, ios::floatfield); str_dimx.precision(3);
	str_dimx << (owner->box_hdim[0] * 2.0) << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_dimx), buffer);
	
	ostrstream str_dimy(buffer, sizeof(buffer));
	str_dimy.setf(ios::fixed, ios::floatfield); str_dimy.precision(3);
	str_dimy << (owner->box_hdim[1] * 2.0) << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_dimy), buffer);
	
	ostrstream str_dimz(buffer, sizeof(buffer));
	str_dimz.setf(ios::fixed, ios::floatfield); str_dimz.precision(3);
	str_dimz << (owner->box_hdim[2] * 2.0) << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_dimz), buffer);
	
	// connect the handlers...
	
	glade_xml_signal_connect_data(xml, "on_dialog_destroy", (GtkSignalFunc) handler_Destroy, (gpointer) this);
	
	glade_xml_signal_connect_data(xml, "on_button_ok_clicked", (GtkSignalFunc) handler_ButtonOK, (gpointer) this);
	glade_xml_signal_connect_data(xml, "on_button_cancel_clicked", (GtkSignalFunc) handler_ButtonCancel, (gpointer) this);
	
	gnome_dialog_run(GNOME_DIALOG(dialog));		// MODAL
}

setup_mm1_dialog::~setup_mm1_dialog(void)
{
}

void setup_mm1_dialog::handler_Destroy(GtkWidget *, gpointer data)
{
	setup_mm1_dialog * ref = (setup_mm1_dialog *) data;
	cout << "handler_Destroy() : ref = " << ref << endl;
	
	delete ref;	// the object was created with new!!!
}

void setup_mm1_dialog::handler_ButtonOK(GtkWidget *, gpointer data)
{
	setup_mm1_dialog * ref = (setup_mm1_dialog *) data;
	cout << "handler_ButtonOK() : ref = " << ref << endl;

	gnome_mm1_docv * owner = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (!owner) cout << "ERROR: cast failed in setup_mm1_dialog::handler_ButtonOK()." << endl;
	else
	{
		// get the periodic box dimensions...
		
		for (int n1 = 0;n1 < 3;n1++)
		{
			GtkWidget * entry = NULL;
			
			switch (n1)
			{
				case 0:
				entry = glade_xml_get_widget(ref->xml, "entry_dimx");
				break;
				
				case 1:
				entry = glade_xml_get_widget(ref->xml, "entry_dimy");
				break;
				
				case 2:
				entry = glade_xml_get_widget(ref->xml, "entry_dimz");
				break;
			}
			
			gchar * buffer = gtk_entry_get_text(GTK_ENTRY(entry));
			
			istrstream istr(buffer, strlen(buffer) + 1);
			double value; istr >> value;
			
			owner->box_hdim[n1] = value / 2.0;
			owner->box_fdim[n1] = value;
		}
		
		// get the engine index, and do the necessary settings...
		
		GtkWidget * optmenu = glade_xml_get_widget(ref->xml, "optionmenu1");
		GtkWidget * submenu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optmenu));
		GtkWidget * item = gtk_menu_get_active(GTK_MENU(submenu));
		
		int index = g_list_index(GTK_MENU_SHELL(submenu)->children, item);
		owner->default_eng = index;
		
		bool old_periodic = owner->periodic;
		
		if (!old_periodic)	// previous was not periodic...
		{
			switch (mm1_mdl::engtab2[index])
			{
				case ENG_MM1_PERIODIC:
				owner->periodic = true;
				break;
			}
		}
		else			// previous was periodic...
		{
			switch (mm1_mdl::engtab2[index])
			{
				case ENG_MM1_NORMAL:
				owner->periodic = false;
				break;
			}
		}
		
		bool update = false;
		if (owner->periodic) update = true;			// dimensions???
		if (old_periodic != owner->periodic) update = true;	// state changed...
		if (update) owner->UpdateAllGraphicsViews();
		
		// report the changed settings to log.
		
		char mbuff1[256];
		ostrstream str1(mbuff1, sizeof(mbuff1));
		str1 << "Changed the Setup for calculations ";
		str1 << "(molecular mechanics";
		str1 << ", engine = " << owner->engtab1[owner->default_eng];
		//if (owner->periodic) str1 << "[using periodic boundary conditions]";
		str1 << ")." << endl << ends;
		owner->PrintToLog(mbuff1);
	}
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

void setup_mm1_dialog::handler_ButtonCancel(GtkWidget *, gpointer data)
{
	setup_mm1_dialog * ref = (setup_mm1_dialog *) data;
	cout << "handler_ButtonCancel() : ref = " << ref << endl;
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

/*################################################################################################*/

// eof
