// T3ERRUTIL.CPP

// Copyright (C) 2000 Geoff Hutchison

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t3errutil.h"
#include "utility.h"

#include <gnome.h>

#include <fstream>
using namespace std;

/*################################################################################################*/

// Constructor -- shouldn't need to do anything
gnome_err_util::gnome_err_util(void)
{
}

// Destructor --shouldn't need to do anything
gnome_err_util::~gnome_err_util(void)
{
}

// Print the message (no problems)
// Requires: message
// Provides: nothing
void gnome_err_util::Message(const char * msg)
{
	GtkWidget * message_dialog;
	int response;
	
	message_dialog = gnome_message_box_new (msg,
		GNOME_MESSAGE_BOX_INFO, GNOME_STOCK_BUTTON_OK,
		NULL);
		
	response = gnome_dialog_run (GNOME_DIALOG (message_dialog));
}

// Print the message (lower severity)
// Requires: message
// Provides: nothing
void gnome_err_util::WarningMessage(const char * msg)
{
	GtkWidget * warning_dialog;
	int response;
	
	warning_dialog = gnome_message_box_new (msg,
		GNOME_MESSAGE_BOX_WARNING, GNOME_STOCK_BUTTON_OK,
		NULL);
		
	response = gnome_dialog_run (GNOME_DIALOG (warning_dialog));
}

// Print the message (higher severity)
// Requires: message
// Provides: nothing
void gnome_err_util::ErrorMessage(const char * msg)
{
	GtkWidget * error_dialog;
	int response;
	
	error_dialog = gnome_message_box_new (msg,
		GNOME_MESSAGE_BOX_ERROR, GNOME_STOCK_BUTTON_OK,
		NULL);
	
	response = gnome_dialog_run (GNOME_DIALOG (error_dialog));
}

// Print the message and wait for a yes/no response
// Requires: message
// Provides: boolean of user response
bool gnome_err_util::Question(const char * msg)
{
	GtkWidget * yes_no_dialog;
	int response;
	
	yes_no_dialog = gnome_message_box_new (msg,
		GNOME_MESSAGE_BOX_QUESTION, GNOME_STOCK_BUTTON_YES,
		GNOME_STOCK_BUTTON_NO, NULL);
		
	response = gnome_dialog_run (GNOME_DIALOG (yes_no_dialog));
	
	switch (response)
	{
		case 0:		// yes
		return true;
		
		default:
		return false;
	}
}

/*################################################################################################*/

// eof
