// GTK_PLOT_VIEWS.CPP

// Copyright (C) 2005 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "gtk_plot_views.h"

/*################################################################################################*/

GtkActionEntry gtk_plot1d_view::entries[] =
{
	{ "AttachDetachPlot1D", NULL, "Attach/Detach This View", NULL, "Select whether this view is attached or in an independent window", (GCallback) gtk_plot1d_view::popup_AttachDetach },
	{ "DeleteViewPlot1D", NULL, "Delete View", NULL, "Delete this view", (GCallback) gtk_plot1d_view::popup_DeleteView }
};

const char * gtk_plot1d_view::ui_description =
"<ui>"
"  <popup name='gp1dvMenu'>"
"    <menuitem action='AttachDetachPlot1D'/>"
"    <separator/>"
"    <menuitem action='DeleteViewPlot1D'/>"
"  </popup>"
"</ui>";

gtk_plot1d_view::gtk_plot1d_view(gtk_project * p1, i32s p2, const char * s1, const char * sv)
	: gtk_ogl_view(p1), plot1d_view(p1, p2, s1, sv), ogl_view()
{
	gtk_label_set_text(GTK_LABEL(label_widget), "1D plot view");	// fixme!!!
	
	GtkActionGroup * action_group = gtk_action_group_new("gp1dvActions");
	gtk_action_group_add_actions(action_group, entries, G_N_ELEMENTS(entries), GTK_WIDGET(view_widget));
	
	gtk_ui_manager_insert_action_group(gtk_app::GetUIManager(), action_group, 0);
	
	GError * error = NULL;
	if (!gtk_ui_manager_add_ui_from_string(gtk_app::GetUIManager(), ui_description, -1, & error))
	{
		g_message("Building gp1dv menu failed : %s", error->message);
		g_error_free(error); exit(EXIT_FAILURE);
	}
	
	// set gtk_view::popupmenu so that gtk_ogl_view::ButtonHandler() will display it...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	popupmenu = gtk_ui_manager_get_widget(gtk_app::GetUIManager(), "/gp1dvMenu");
}

gtk_plot1d_view::~gtk_plot1d_view(void)
{
}

void gtk_plot1d_view::ExposeEvent(void)
{
	GdkGLContext * glcontext = gtk_widget_get_gl_context(view_widget);
	GdkGLDrawable * gldrawable = gtk_widget_get_gl_drawable(view_widget);

	SetCurrent(); Render(); glFlush();
	
	if (gdk_gl_drawable_is_double_buffered(gldrawable)) gdk_gl_drawable_swap_buffers(gldrawable);
	else glFlush();
	
//gtk_gl_area_swapbuffers(GTK_GL_AREA(view_widget));	// older way??? see gtk_graphics_view::ExposeEvent()
}

void gtk_plot1d_view::popup_AttachDetach(GtkWidget *, gpointer data)
{
	gtk_ogl_view * oglv = GetOGLV((GtkWidget *) data);
	plot1d_view * old_p1dv = dynamic_cast<plot1d_view *>(oglv);
	if (old_p1dv == NULL)
	{
		cout << "cast failed at gtk_plot1d_view::popup_AttachDetach()." << endl;
		return;
	}
	
	// first we create a new view using the requested mode...
	
	i32s ud1 = old_p1dv->getUD1();
	const char * s1 = old_p1dv->getN1();
	const char * sv = old_p1dv->getNV();
	bool flag = (oglv->detached == NULL);
	
	plot1d_view * new_p1dv = oglv->prj->AddPlot1DView(ud1, s1, sv, flag);
	
	// try to retain as much data/settings as possible.
	
	new_p1dv->ImportData(old_p1dv);
	
	// ...and then simply destroy the old one; calling popup_ViewsDeleteView()
	// below this is the same as selecting "Delete This View" from the popup-menu.
	
	popup_DeleteView(NULL, data);
//	new_p1dv->GetProject()->UpdateAllWindowTitles();
}

void gtk_plot1d_view::popup_DeleteView(GtkWidget *, gpointer data)
{
	gtk_ogl_view * oglv = GetOGLV((GtkWidget *) data);
	
	if (oglv->detached != NULL)
	{
		gtk_widget_destroy(GTK_WIDGET(oglv->detached));
	}
	else
	{
		gint page = gtk_notebook_page_num(GTK_NOTEBOOK(oglv->prj->notebook_widget), oglv->view_widget);
		gtk_notebook_remove_page(GTK_NOTEBOOK(oglv->prj->notebook_widget), page);
	}
	
	plotting_view * pv = dynamic_cast<plotting_view *>(oglv);
	if (pv == NULL) { cout << "cast failed at gtk_plot1d_view::popup_DeleteView()!" << endl; exit(EXIT_FAILURE); }
	
	oglv->prj->RemovePlottingView(pv);
	// TODO : delete the object and release memory ; is it done already???
}

/*################################################################################################*/

GtkActionEntry gtk_plot2d_view::entries[] =
{
	{ "AttachDetachPlot2D", NULL, "Attach/Detach This View", NULL, "Select whether this view is attached or in an independent window", (GCallback) gtk_plot2d_view::popup_AttachDetach },
	{ "DeleteViewPlot2D", NULL, "Delete View", NULL, "Delete this view", (GCallback) gtk_plot2d_view::popup_DeleteView }
};

const char * gtk_plot2d_view::ui_description =
"<ui>"
"  <popup name='gp2dvMenu'>"
"    <menuitem action='AttachDetachPlot2D'/>"
"    <separator/>"
"    <menuitem action='DeleteViewPlot2D'/>"
"  </popup>"
"</ui>";

gtk_plot2d_view::gtk_plot2d_view(gtk_project * p1, i32s p2, const char * s1, const char * s2, const char * sv)
	: gtk_ogl_view(p1), plot2d_view(p1, p2, s1, s2, sv), ogl_view()
{
	gtk_label_set_text(GTK_LABEL(label_widget), "2D plot view");	// fixme!!!
	
	GtkActionGroup * action_group = gtk_action_group_new("gp2dvActions");
	gtk_action_group_add_actions(action_group, entries, G_N_ELEMENTS(entries), GTK_WIDGET(view_widget));
	
	gtk_ui_manager_insert_action_group(gtk_app::GetUIManager(), action_group, 0);
	
	GError * error = NULL;
	if (!gtk_ui_manager_add_ui_from_string(gtk_app::GetUIManager(), ui_description, -1, & error))
	{
		g_message("Building gp2dv menu failed : %s", error->message);
		g_error_free(error); exit(EXIT_FAILURE);
	}
	
	// set gtk_view::popupmenu so that gtk_ogl_view::ButtonHandler() will display it...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	popupmenu = gtk_ui_manager_get_widget(gtk_app::GetUIManager(), "/gp2dvMenu");
}

gtk_plot2d_view::~gtk_plot2d_view(void)
{
}

void gtk_plot2d_view::ExposeEvent(void)
{
	GdkGLContext * glcontext = gtk_widget_get_gl_context(view_widget);
	GdkGLDrawable * gldrawable = gtk_widget_get_gl_drawable(view_widget);

	SetCurrent(); Render(); glFlush();

	if (gdk_gl_drawable_is_double_buffered(gldrawable)) gdk_gl_drawable_swap_buffers(gldrawable);
	else glFlush();
	
//gtk_gl_area_swapbuffers(GTK_GL_AREA(view_widget));	// older way??? see gtk_graphics_view::ExposeEvent()
}

void gtk_plot2d_view::popup_AttachDetach(GtkWidget *, gpointer data)
{
	gtk_ogl_view * oglv = GetOGLV((GtkWidget *) data);
	plot2d_view * old_p2dv = dynamic_cast<plot2d_view *>(oglv);
	if (old_p2dv == NULL)
	{
		cout << "cast failed at gtk_plot2d_view::popup_AttachDetach()." << endl;
		return;
	}
	
	// first we create a new view using the requested mode...
	
	i32s ud2 = old_p2dv->getUD2();
	const char * s1 = old_p2dv->getN1();
	const char * s2 = old_p2dv->getN2();
	const char * sv = old_p2dv->getNV();
	bool flag = (oglv->detached == NULL);
	
	plot2d_view * new_p2dv = oglv->prj->AddPlot2DView(ud2, s1, s2, sv, flag);
	
	// try to retain as much data/settings as possible.
	
	new_p2dv->ImportData(old_p2dv);
	
	// ...and then simply destroy the old one; calling popup_ViewsDeleteView()
	// below this is the same as selecting "Delete This View" from the popup-menu.
	
	popup_DeleteView(NULL, data);
//	new_p1dv->GetProject()->UpdateAllWindowTitles();
}

void gtk_plot2d_view::popup_DeleteView(GtkWidget *, gpointer data)
{
	gtk_ogl_view * oglv = GetOGLV((GtkWidget *) data);
	
	if (oglv->detached != NULL)
	{
		gtk_widget_destroy(GTK_WIDGET(oglv->detached));
	}
	else
	{
		gint page = gtk_notebook_page_num(GTK_NOTEBOOK(oglv->prj->notebook_widget), oglv->view_widget);
		gtk_notebook_remove_page(GTK_NOTEBOOK(oglv->prj->notebook_widget), page);
	}
	
	plotting_view * pv = dynamic_cast<plotting_view *>(oglv);
	if (pv == NULL) { cout << "cast failed at gtk_plot2d_view::popup_DeleteView()!" << endl; exit(EXIT_FAILURE); }
	
	oglv->prj->RemovePlottingView(pv);
	// TODO : delete the object and release memory ; is it done already???
}

/*################################################################################################*/

GtkActionEntry gtk_rcp_view::entries[] =
{
	{ "DeleteViewRCP", NULL, "Delete View", NULL, "Delete this view", (GCallback) gtk_rcp_view::popup_DeleteView }
};

const char * gtk_rcp_view::ui_description =
"<ui>"
"  <popup name='grcpvMenu'>"
"    <menuitem action='DeleteViewRCP'/>"
"  </popup>"
"</ui>";

gtk_rcp_view::gtk_rcp_view(gtk_project * p1, i32s p2, const char * s1, const char * sv)
	: gtk_ogl_view(p1), rcp_view(p1, p2, s1, sv), ogl_view()
{
	gtk_label_set_text(GTK_LABEL(label_widget), "RC plot view");	// fixme!!!
	
	GtkActionGroup * action_group = gtk_action_group_new("grcpvActions");
	gtk_action_group_add_actions(action_group, entries, G_N_ELEMENTS(entries), GTK_WIDGET(view_widget));
	
	gtk_ui_manager_insert_action_group(gtk_app::GetUIManager(), action_group, 0);
	
	GError * error = NULL;
	if (!gtk_ui_manager_add_ui_from_string(gtk_app::GetUIManager(), ui_description, -1, & error))
	{
		g_message("Building grcpv menu failed : %s", error->message);
		g_error_free(error); exit(EXIT_FAILURE);
	}
	
	// set gtk_view::popupmenu so that gtk_ogl_view::ButtonHandler() will display it...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	popupmenu = gtk_ui_manager_get_widget(gtk_app::GetUIManager(), "/grcpvMenu");
}

gtk_rcp_view::~gtk_rcp_view(void)
{
}

void gtk_rcp_view::ExposeEvent(void)
{
	GdkGLContext * glcontext = gtk_widget_get_gl_context(view_widget);
	GdkGLDrawable * gldrawable = gtk_widget_get_gl_drawable(view_widget);
	
	SetCurrent(); Render(); glFlush();

	if (gdk_gl_drawable_is_double_buffered(gldrawable)) gdk_gl_drawable_swap_buffers(gldrawable);
	else glFlush();
	
//gtk_gl_area_swapbuffers(GTK_GL_AREA(view_widget));	// older way??? see gtk_graphics_view::ExposeEvent()
}

void gtk_rcp_view::popup_DeleteView(GtkWidget *, gpointer data)
{
	gtk_ogl_view * oglv = GetOGLV((GtkWidget *) data);
	
	if (oglv->detached != NULL)
	{
		gtk_widget_destroy(GTK_WIDGET(oglv->detached));
	}
	else
	{
		gint page = gtk_notebook_page_num(GTK_NOTEBOOK(oglv->prj->notebook_widget), oglv->view_widget);
		gtk_notebook_remove_page(GTK_NOTEBOOK(oglv->prj->notebook_widget), page);
	}
	
	plotting_view * pv = dynamic_cast<plotting_view *>(oglv);
	if (pv == NULL) { cout << "cast failed at gtk_rcp_view::popup_DeleteView()!" << endl; exit(EXIT_FAILURE); }
	
	oglv->prj->RemovePlottingView(pv);
	// TODO : delete the object and release memory ; is it done already???
}

/*################################################################################################*/

GtkActionEntry gtk_eld_view::entries[] =
{
	{ "DeleteViewELD", NULL, "Delete View", NULL, "Delete this view", (GCallback) gtk_eld_view::popup_DeleteView }
};

const char * gtk_eld_view::ui_description =
"<ui>"
"  <popup name='geldvMenu'>"
"    <menuitem action='DeleteViewELD'/>"
"  </popup>"
"</ui>";

gtk_eld_view::gtk_eld_view(gtk_project * p1)
	: gtk_ogl_view(p1), eld_view(p1), ogl_view()
{
	gtk_label_set_text(GTK_LABEL(label_widget), "energy-level diagram view");	// fixme!!!
	
	GtkActionGroup * action_group = gtk_action_group_new("geldvActions");
	gtk_action_group_add_actions(action_group, entries, G_N_ELEMENTS(entries), GTK_WIDGET(view_widget));
	
	gtk_ui_manager_insert_action_group(gtk_app::GetUIManager(), action_group, 0);
	
	GError * error = NULL;
	if (!gtk_ui_manager_add_ui_from_string(gtk_app::GetUIManager(), ui_description, -1, & error))
	{
		g_message("Building geldv menu failed : %s", error->message);
		g_error_free(error); exit(EXIT_FAILURE);
	}
	
	// set gtk_view::popupmenu so that gtk_ogl_view::ButtonHandler() will display it...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	popupmenu = gtk_ui_manager_get_widget(gtk_app::GetUIManager(), "/geldvMenu");
}

gtk_eld_view::~gtk_eld_view(void)
{
}

void gtk_eld_view::ExposeEvent(void)
{
	GdkGLContext * glcontext = gtk_widget_get_gl_context(view_widget);
	GdkGLDrawable * gldrawable = gtk_widget_get_gl_drawable(view_widget);

	SetCurrent(); Render(); glFlush();

	if (gdk_gl_drawable_is_double_buffered(gldrawable)) gdk_gl_drawable_swap_buffers(gldrawable);
	else glFlush();
	
//gtk_gl_area_swapbuffers(GTK_GL_AREA(view_widget));	// older way??? see gtk_graphics_view::ExposeEvent()
}

void gtk_eld_view::popup_DeleteView(GtkWidget *, gpointer data)
{
	gtk_ogl_view * oglv = GetOGLV((GtkWidget *) data);
	
	if (oglv->detached != NULL)
	{
		gtk_widget_destroy(GTK_WIDGET(oglv->detached));
	}
	else
	{
		gint page = gtk_notebook_page_num(GTK_NOTEBOOK(oglv->prj->notebook_widget), oglv->view_widget);
		gtk_notebook_remove_page(GTK_NOTEBOOK(oglv->prj->notebook_widget), page);
	}
	
	plotting_view * pv = dynamic_cast<plotting_view *>(oglv);
	if (pv == NULL) { cout << "cast failed at gtk_eld_view::popup_DeleteView()!" << endl; exit(EXIT_FAILURE); }
	
	oglv->prj->RemovePlottingView(pv);
	// TODO : delete the object and release memory ; is it done already???
}

/*################################################################################################*/

// eof
