// GTK_PLOT_VIEWS.H : write a short description here...

// Copyright (C) 2005 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef GTK_PLOT_VIEWS_H
#define GTK_PLOT_VIEWS_H

#include "appconfig.h"

class gtk_plot1d_view;
class gtk_plot2d_view;

class gtk_rcp_view;		// reaction coordinate plot

class gtk_eld_view;		// energy level diagram

#include "gtk_views.h"

/*################################################################################################*/

class gtk_plot1d_view : public gtk_ogl_view, public plot1d_view
{
	protected:
	
	static GtkActionEntry entries[];
	static const char * ui_description;
	
	private:
	
	gtk_plot1d_view(gtk_project *, i32s, const char *, const char *);
	
	friend class gtk_class_factory;
	
	public:
	
	~gtk_plot1d_view(void);
	
	private:
	
	void ExposeEvent(void);		// virtual
	
	public:
	
	static void popup_AttachDetach(GtkWidget *, gpointer);
	static void popup_DeleteView(GtkWidget *, gpointer);
};

/*################################################################################################*/

class gtk_plot2d_view : public gtk_ogl_view, public plot2d_view
{
	protected:
	
	static GtkActionEntry entries[];
	static const char * ui_description;
	
	private:
	
	gtk_plot2d_view(gtk_project *, i32s, const char *, const char *, const char *);
	
	friend class gtk_class_factory;
	
	public:
	
	~gtk_plot2d_view(void);
	
	private:
	
	void ExposeEvent(void);		// virtual
	
	public:
	
	static void popup_AttachDetach(GtkWidget *, gpointer);
	static void popup_DeleteView(GtkWidget *, gpointer);
};

/*################################################################################################*/

class gtk_rcp_view : public gtk_ogl_view, public rcp_view
{
	protected:
	
	static GtkActionEntry entries[];
	static const char * ui_description;
	
	private:
	
	gtk_rcp_view(gtk_project *, i32s, const char *, const char *);
	
	friend class gtk_class_factory;
	
	public:
	
	~gtk_rcp_view(void);
	
	private:
	
	void ExposeEvent(void);		// virtual
	
	public:
	
	static void popup_DeleteView(GtkWidget *, gpointer);
};

/*################################################################################################*/

class gtk_eld_view : public gtk_ogl_view, public eld_view
{
	protected:
	
	static GtkActionEntry entries[];
	static const char * ui_description;
	
	private:
	
	gtk_eld_view(gtk_project *);
	
	friend class gtk_class_factory;
	
	public:
	
	~gtk_eld_view(void);
	
	private:
	
	void ExposeEvent(void);		// virtual
	
	public:
	
	static void popup_DeleteView(GtkWidget *, gpointer);
};

/*################################################################################################*/

#endif	// GTK_PLOT_VIEWS_H

// eof
