// GTK_VIEWS.CPP

// Copyright (C) 1998 Tommi Hassinen, Jarno Huuskonen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "gtk_views.h"	// config.h is here -> we get ENABLE-macros here...

#include <ghemical/engine.h>
#include <ghemical/utility.h>

#include "gtk_project.h"
#include "gtk_project_view.h"	// temporary ; attach/detach
#include "gtk_graphics_view.h"	// temporary ; attach/detach
#include "gtk_plot_views.h"	// temporary ; attach/detach

//#include <gnome.h>
//#include <gdk/gdkglconfig.h>

#include <gtk/gtk.h>

#include <strstream>
#include <algorithm>
using namespace std;

/*################################################################################################*/

gtk_view::gtk_view(gtk_project * p1) : view()
{
	prj = p1;
	
	label_widget = gtk_label_new("this_view_has_no_title");
	popupmenu = NULL;
}

gtk_view::~gtk_view(void)
{
}

project * gtk_view::GetProject(void)
{
	return prj;
}

void gtk_view::SetTitle(const char * p1)
{
	// if this a "detached" view, we should do the title setting differently than usual "attached" cases.
	// only gtk_graphics_view objects can be "detached". ok, this is a bit ugly solution, but see
	// gtk_graphics_view::popup_ViewsAttachDetach() for more comments...
	
// THIS IS BAD!!!!!!!!!!
// THIS IS BAD!!!!!!!!!!
// THIS IS BAD!!!!!!!!!!
// THIS IS BAD!!!!!!!!!!

/*	gtk_graphics_view * gv = dynamic_cast<gtk_graphics_view *>(this);
	if (gv != NULL && gv->detached != NULL)
	{
		char projfilename[256];
		prj->GetProjectFileName(projfilename, 256, true);
		
		char extended_title[256];
		ostrstream str(extended_title, sizeof(extended_title));
		str << projfilename << " : " << p1 << ends;
		
		gtk_window_set_title(GTK_WINDOW(gv->detached), extended_title);
		return;
	}	*/
	
	gtk_label_set_text(GTK_LABEL(label_widget), p1);
}

/*################################################################################################*/

vector<gtk_ogl_view *> gtk_ogl_view::oglv_vector;

gtk_ogl_view::gtk_ogl_view(gtk_project * p1) : ogl_view(), gtk_view(p1)
{
	detached = NULL;
	
	is_realized = false;
	oglv_vector.push_back(this);
	
	gint major; gint minor;
	gdk_gl_query_version(& major, & minor);
	g_print("OpenGL extension version - %d.%d\n", major, minor);
	
	GdkGLConfig * glconfig; GdkGLConfigMode mode;
	
	mode = (GdkGLConfigMode) (GDK_GL_MODE_RGB | GDK_GL_MODE_DEPTH | GDK_GL_MODE_DOUBLE);
	glconfig = gdk_gl_config_new_by_mode(mode);	// try double-buffered visual...
	
	if (glconfig == NULL)
	{
		g_print("*** Cannot find the double-buffered visual.\n");
		g_print("*** Trying single-buffered visual.\n");
		
		mode = (GdkGLConfigMode) (GDK_GL_MODE_RGB | GDK_GL_MODE_DEPTH);
		glconfig = gdk_gl_config_new_by_mode(mode);	// try single-buffered visual...
		
		if (glconfig == NULL)
		{
			g_print("*** No appropriate OpenGL-capable visual found.\n");
			exit (1);
		}
	}
	
	view_widget = gtk_drawing_area_new();
	gtk_widget_set_size_request(view_widget, 400, 400);	// minimum size...
	
	gtk_widget_set_gl_capability(view_widget, glconfig, NULL, TRUE, GDK_GL_RGBA_TYPE);
	
	int events = GDK_EXPOSURE_MASK;
	events |= GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK;
	events |= GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK;
	gtk_widget_set_events(GTK_WIDGET(view_widget), events);
	
	gtk_signal_connect_after(GTK_OBJECT(view_widget), "realize", GTK_SIGNAL_FUNC(RealizeHandler), NULL);	// after!!!
	
	gtk_signal_connect(GTK_OBJECT(view_widget), "expose_event", GTK_SIGNAL_FUNC(ExposeHandler), NULL);
	gtk_signal_connect(GTK_OBJECT(view_widget), "motion_notify_event", GTK_SIGNAL_FUNC(MotionNotifyHandler), NULL);
	gtk_signal_connect(GTK_OBJECT(view_widget), "button_press_event", GTK_SIGNAL_FUNC(ButtonHandler), NULL);
	gtk_signal_connect(GTK_OBJECT(view_widget), "button_release_event", GTK_SIGNAL_FUNC(ButtonHandler), NULL);
	gtk_signal_connect(GTK_OBJECT(view_widget), "configure_event", GTK_SIGNAL_FUNC(ConfigureHandler), NULL);
	
	gtk_widget_show(GTK_WIDGET(view_widget));
}

gtk_ogl_view::~gtk_ogl_view(void)
{
	vector<gtk_ogl_view *>::iterator it1;
	it1 = find(oglv_vector.begin(), oglv_vector.end(), this);
	
	if (it1 != oglv_vector.end())
	{
		oglv_vector.erase(it1);
	}
	else
	{
		cout << "WARNING : unknown view_widget at ~gtk_ogl_view()!!!" << endl;
	}
}

void gtk_ogl_view::Update(bool directly)
{
	if (!is_realized) g_print("WARNING : Update() called before widget was realized ; skipping...\n");
	else
	{
		if (directly) ExposeEvent();
		else gtk_widget_queue_draw(view_widget);
	}
	
	// here we update always directly. should emit an update request for indirect rendering!?!?!?
	// here we update always directly. should emit an update request for indirect rendering!?!?!?
	// here we update always directly. should emit an update request for indirect rendering!?!?!?
}

bool gtk_ogl_view::SetCurrent(void)
{
	if (!is_realized)
	{
		g_print("WARNING : SetCurrent() called before widget was realized ; skipping...\n");
		return false;
	}
	else
	{
		GdkGLContext * glcontext = gtk_widget_get_gl_context(view_widget);
		GdkGLDrawable * gldrawable = gtk_widget_get_gl_drawable(view_widget);
		
	//	gdk_gl_drawable_wait_gl()	what are these???
	//	gdk_gl_drawable_wait_gdk()	what are these???
		
		if (!gdk_gl_drawable_make_current(gldrawable, glcontext))
		{
			g_print("ERROR : gdk_gl_drawable_make_current() failed in SetCurrent().\n");
			return false;
		}
		else
		{
			return true;
		}
	}
}

void gtk_ogl_view::RealizeHandler(GtkWidget * widget, gpointer)
{
	gtk_ogl_view * oglv = GetOGLV(widget);
	if (!oglv) cout << "Unknown ID in RealizeHandler !!!" << endl;
	else
	{
		oglv->is_realized = true;
		oglv->InitGL();
	}
}

gint gtk_ogl_view::ExposeHandler(GtkWidget * widget, GdkEventExpose *)		// EVENT_HANDLER
{
	gtk_ogl_view * oglv = GetOGLV(widget);
	if (!oglv) cout << "Unknown ID in ExposeHandler !!!" << endl;
	else
	{
#ifdef ENABLE_THREADS
//gdk_threads_enter();
#endif	// ENABLE_THREADS
		
		oglv->ExposeEvent();
		
#ifdef ENABLE_THREADS
//gdk_threads_leave();
#endif	// ENABLE_THREADS
	}
	
//	return FALSE;	// why is that???
	return TRUE;	// why is that???
}

int button_event_lost_counter = 0;

gint gtk_ogl_view::ButtonHandler(GtkWidget * widget, GdkEventButton * eb)

// EVENT_HANDLER

{
	gtk_ogl_view * oglv = GetOGLV(widget);
	if (!oglv) cout << "Unknown ID in ButtonHandler !!!" << endl;
	else
	{
		mouse_tool::button tmpb; i32s tmps1;
		switch (eb->button)
		{
			case 1:
			tmpb = mouse_tool::Left;
			tmps1 = GDK_BUTTON1_MASK;
			break;
			
			case 3:
			tmpb = mouse_tool::Right;
			tmps1 = GDK_BUTTON3_MASK;
			break;
			
			default:
			tmpb = mouse_tool::Middle;
			tmps1 = GDK_BUTTON2_MASK;
		}
		
		mouse_tool::state tmps2 = (eb->state & tmps1) ? mouse_tool::Up : mouse_tool::Down;
		
		if (tmps2 == mouse_tool::Down)
		{
			if (button == mouse_tool::None)
			{
				if (tmpb == mouse_tool::Right)
				{
// the popup menu is created here. pointer to the gtk_drawing_area
// widget is given as "user_data", and it is also passed to the popup
// hander callback function (instead of the original value).
// 2001-08-22 quick fix : check that we open the popup for
// a graphics view only (not for energy level diagrams).
//					graphics_view * gv = dynamic_cast<graphics_view *>(window);
//					if (gv == NULL) return TRUE;	// was not a graphics_view!!!
//					gtk_graphics_view * ggv = dynamic_cast<gtk_graphics_view *>(gv);
//					if (ggv == NULL) return TRUE;	// FIXME so that all views have their own popups!!!
//				//	gtk_popup_menu_do_popup(,NULL, NULL, NULL, window->view_widget, NULL);
//				//	gtk_menu_popup(GTK_MENU(GetWindow(widget)->prj->popupmenu), NULL, NULL, NULL, NULL, eb->button, eb->time);
//					gtk_menu_popup(GTK_MENU(ggv->popupmenu), NULL, NULL, NULL, NULL, eb->button, eb->time);
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					gtk_ogl_view * oglv = GetOGLV(widget);
					if (oglv != NULL && oglv->popupmenu != NULL)
					{
						gtk_menu_popup(GTK_MENU(oglv->popupmenu), NULL, NULL, NULL, NULL, eb->button, eb->time);
					}
					
					return TRUE;
				}
				
				button = tmpb;
				
				shift_down = (eb->state & GDK_SHIFT_MASK) ? true : false;
				ctrl_down = (eb->state & GDK_CONTROL_MASK) ? true : false;
				
				state = mouse_tool::Down;
				
			//	cout << "button_event_D " << button << " " << state << " " << (ogl_view *) window << endl;
				current_tool->ButtonEvent((ogl_view *) oglv, (i32s) eb->x, (i32s) eb->y);
				button_event_lost_counter = 0;	// this is for exceptions, see below...
			}
		}
		else
		{
			if (button == mouse_tool::Left && tmpb != mouse_tool::Left) return TRUE;
			if (button == mouse_tool::Middle && tmpb != mouse_tool::Middle) return TRUE;
			if (button == mouse_tool::Right && tmpb != mouse_tool::Right) return TRUE;
			
			state = mouse_tool::Up;
			
		//	cout << "button_event_U " << button << " " << state << " " << (ogl_view *) window << endl;
			current_tool->ButtonEvent((ogl_view *) oglv, (i32s) eb->x, (i32s) eb->y);
			
			button = mouse_tool::None;
		}
	}
	
	return TRUE;
}

gint gtk_ogl_view::ConfigureHandler(GtkWidget * widget, GdkEventConfigure *)		// EVENT_HANDLER
{
	gtk_ogl_view * oglv = GetOGLV(widget);
	if (!oglv) cout << "Unknown ID in ConfigureHandler !!!" << endl;
	else
	{
#ifdef ENABLE_THREADS
//gdk_threads_enter();
#endif	// ENABLE_THREADS
		
		oglv->SetCurrent();
		oglv->SetSize(widget->allocation.width, widget->allocation.height);
		
#ifdef ENABLE_THREADS
//gdk_threads_leave();
#endif	// ENABLE_THREADS
	}
	
	return TRUE;
}

gint gtk_ogl_view::MotionNotifyHandler(GtkWidget * widget, GdkEventMotion * event)	// EVENT_HANDLER
{
#ifdef ENABLE_THREADS
//gdk_threads_enter();
#endif	// ENABLE_THREADS
	
	int x; int y; GdkModifierType mbstate;
	if (event->is_hint) gdk_window_get_pointer(event->window, & x, & y, & mbstate);
	else { x = (int) event->x; y = (int) event->y; mbstate = (GdkModifierType) event->state; }
	
	// here it is good to check if we have lost a "mouse button up" message.
	// it can happen if a user moves the mouse outside to the graphics window,
	// and then changes the mousebutton state.
	
	// if we think that a mouse button should be down, but GTK+ says it's not,
	// then immediately send a "mouse button down" message...
	
	bool no_buttons_down = !(mbstate & (GDK_BUTTON1_MASK | GDK_BUTTON2_MASK | GDK_BUTTON3_MASK));
	if (no_buttons_down && button != mouse_tool::None)
	{
		button_event_lost_counter++;
		if (button_event_lost_counter > 1)
		{
			gtk_ogl_view * oglv = GetOGLV(widget);
			if (!oglv) cout << "Unknown ID in MotionNotifyHandler !!!" << endl;
			else
			{
				cout << "WARNING ; a mouse-button-up event was lost!" << endl;
				
				state = mouse_tool::Up;
				
			//	cout << "button_event_U " << button << " " << state << " " << (ogl_view *) window << endl;
				current_tool->ButtonEvent((ogl_view *) oglv, (i32s) x, (i32s) y);
				
				button = mouse_tool::None;
			}
		}
	}
	
	// the normal operation starts here...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	if (button != mouse_tool::None)
	{
		gtk_ogl_view * oglv = GetOGLV(widget);
		if (!oglv) cout << "Unknown ID in MotionNotifyHandler !!!" << endl;
		else
		{
		//	cout << "motion_event " << button << " " << state << endl;
			current_tool->MotionEvent((ogl_view *) oglv, x, y);
		}
	}
	
#ifdef ENABLE_THREADS
//gdk_threads_leave();
#endif	// ENABLE_THREADS
	
	return TRUE;
}

gint gtk_ogl_view::DetachedDeleteHandler(GtkWidget *, GdkEvent *)
{
	// when we create detached view windows as GTK_WINDOW_TOPLEVEL, the window will have the "close" button
	// at titlebar. now if the user presses the "close" button, the window-closing sequence will start.
	// we will grab the resulting delete_event here and return TRUE, that will deny the user's request to
	// close the window. the user should use the stardard popup-way of closing the window...
	
	return TRUE;
}

gtk_ogl_view * gtk_ogl_view::GetOGLV(GtkWidget * widget)
{
	vector<gtk_ogl_view *>::iterator it1 = oglv_vector.begin();
	while (it1 != oglv_vector.end())
	{
		vector<gtk_ogl_view *>::iterator it2 = it1++;
		if ((* it2)->view_widget == widget) return (* it2);
	}
	
	// return NULL if the search failed...
	// return NULL if the search failed...
	// return NULL if the search failed...
	
	return NULL;
}

/*################################################################################################*/

gtk_class_factory * gtk_class_factory::instance = NULL;
singleton_cleaner<gtk_class_factory> gtk_class_factory_cleaner(gtk_class_factory::GetInstance());

gtk_class_factory::gtk_class_factory(void) : graphics_class_factory()
{
}

gtk_class_factory::~gtk_class_factory(void)
{
}

gtk_class_factory * gtk_class_factory::GetInstance(void)
{
	if (instance != NULL) return instance;
	else return (instance = new gtk_class_factory());
}

project_view * gtk_class_factory::ProduceProjectView(project * prj1)
{
	gtk_project * prj2 = dynamic_cast<gtk_project *>(prj1);
	
	gtk_project_view * pv = new gtk_project_view(prj2);
	gtk_notebook_append_page(GTK_NOTEBOOK(prj2->notebook_widget), pv->view_widget, pv->label_widget);
//	gtk_notebook_set_page(GTK_NOTEBOOK(prj2->notebook_widget), -1);		// activate the last page. // currently has no effect...
	
	gtk_widget_show(GTK_WIDGET(prj2->notebook_widget));
	return pv;
}

graphics_view * gtk_class_factory::ProduceGraphicsView(project * prj1, camera * cam, bool detach)
{
	gtk_project * prj2 = dynamic_cast<gtk_project *>(prj1);
	gtk_graphics_view * gv = new gtk_graphics_view(prj2, cam);
	
	if (detach)
	{
		gv->detached = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_default_size(GTK_WINDOW(gv->detached), 400, 400);
		
		gtk_container_add(GTK_CONTAINER(gv->detached), gv->view_widget);
		gtk_signal_connect(GTK_OBJECT(gv->detached), "delete_event", GTK_SIGNAL_FUNC(gtk_graphics_view::DetachedDeleteHandler), NULL);
		
		gtk_widget_show(gv->detached);
	}
	else
	{
		gtk_notebook_append_page(GTK_NOTEBOOK(prj2->notebook_widget), gv->view_widget, gv->label_widget);
		gtk_notebook_set_page(GTK_NOTEBOOK(prj2->notebook_widget), -1);		// activate the last page.
	}
	
	return gv;
}

plot1d_view * gtk_class_factory::ProducePlot1DView(project * prj1, i32s ud1, const char * s1, const char * sv, bool detach)
{
	gtk_project * prj2 = dynamic_cast<gtk_project *>(prj1);
	gtk_plot1d_view * p1dv = new gtk_plot1d_view(prj2, ud1, s1, sv);
	
	if (detach)
	{
		p1dv->detached = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_default_size(GTK_WINDOW(p1dv->detached), 400, 400);
		
		gtk_container_add(GTK_CONTAINER(p1dv->detached), p1dv->view_widget);
		gtk_signal_connect(GTK_OBJECT(p1dv->detached), "delete_event", GTK_SIGNAL_FUNC(gtk_plot1d_view::DetachedDeleteHandler), NULL);
		
		gtk_widget_show(p1dv->detached);
	}
	else
	{
		gtk_notebook_append_page(GTK_NOTEBOOK(prj2->notebook_widget), p1dv->view_widget, p1dv->label_widget);
		gtk_notebook_set_page(GTK_NOTEBOOK(prj2->notebook_widget), -1);		// activate the last page.
	}
	
	return p1dv;
}

plot2d_view * gtk_class_factory::ProducePlot2DView(project * prj1, i32s ud2, const char * s1, const char * s2, const char * sv, bool detach)
{
	gtk_project * prj2 = dynamic_cast<gtk_project *>(prj1);
	gtk_plot2d_view * p2dv = new gtk_plot2d_view(prj2, ud2, s1, s2, sv);
	
	if (detach)
	{
		p2dv->detached = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_default_size(GTK_WINDOW(p2dv->detached), 400, 400);
		
		gtk_container_add(GTK_CONTAINER(p2dv->detached), p2dv->view_widget);
		gtk_signal_connect(GTK_OBJECT(p2dv->detached), "delete_event", GTK_SIGNAL_FUNC(gtk_plot2d_view::DetachedDeleteHandler), NULL);
		
		gtk_widget_show(p2dv->detached);
	}
	else
	{
		gtk_notebook_append_page(GTK_NOTEBOOK(prj2->notebook_widget), p2dv->view_widget, p2dv->label_widget);
		gtk_notebook_set_page(GTK_NOTEBOOK(prj2->notebook_widget), -1);		// activate the last page.
	}
	
	return p2dv;
}

rcp_view * gtk_class_factory::ProduceRCPView(project * prj1, i32s ud1, const char * s1, const char * sv, bool detach)
{
	gtk_project * prj2 = dynamic_cast<gtk_project *>(prj1);
	gtk_rcp_view * rcpv = new gtk_rcp_view(prj2, ud1, s1, sv);
	
	if (detach)
	{
		rcpv->detached = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_default_size(GTK_WINDOW(rcpv->detached), 400, 400);
		
		gtk_container_add(GTK_CONTAINER(rcpv->detached), rcpv->view_widget);
		gtk_signal_connect(GTK_OBJECT(rcpv->detached), "delete_event", GTK_SIGNAL_FUNC(gtk_rcp_view::DetachedDeleteHandler), NULL);
		
		gtk_widget_show(rcpv->detached);
	}
	else
	{
		gtk_notebook_append_page(GTK_NOTEBOOK(prj2->notebook_widget), rcpv->view_widget, rcpv->label_widget);
		gtk_notebook_set_page(GTK_NOTEBOOK(prj2->notebook_widget), -1);		// activate the last page.
	}
	
	return rcpv;
}

eld_view * gtk_class_factory::ProduceELDView(project * mdl, bool detach)
{
	gtk_project * prj2 = dynamic_cast<gtk_project *>(mdl);
	gtk_eld_view * eldv = new gtk_eld_view(prj2);
	
	if (detach)
	{
		eldv->detached = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_default_size(GTK_WINDOW(eldv->detached), 400, 400);
		
		gtk_container_add(GTK_CONTAINER(eldv->detached), eldv->view_widget);
		gtk_signal_connect(GTK_OBJECT(eldv->detached), "delete_event", GTK_SIGNAL_FUNC(gtk_rcp_view::DetachedDeleteHandler), NULL);
		
		gtk_widget_show(eldv->detached);
	}
	else
	{
		gtk_notebook_append_page(GTK_NOTEBOOK(prj2->notebook_widget), eldv->view_widget, eldv->label_widget);
		gtk_notebook_set_page(GTK_NOTEBOOK(prj2->notebook_widget), -1);		// activate the last page.
	}
	
	gtk_widget_show(GTK_WIDGET(prj2->notebook_widget));
	return eldv;
}

/*################################################################################################*/

// eof
