// GTK_VIEWS.H : gtk/bonobo implementations of "view" classes.

// Copyright (C) 1998 Tommi Hassinen, Jarno Huuskonen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef GTK_VIEWS_H
#define GTK_VIEWS_H

//#include "ghemicalconfig2.h"

class gtk_view;
class gtk_ogl_view;

class gtk_class_factory;

/*################################################################################################*/

class camera;		// camera.h

class color_mode;	// model.h
class project;		// project.h

#include "mtools.h"
#include "gtk_project.h"

#include <gtk/gtk.h>
#include <gtk/gtkgl.h>

#include <vector>
using namespace std;

/*################################################################################################*/

/// GTK-dependent part of "##view" class.

class gtk_view : virtual public view
{
	protected:
	
	gtk_project * prj;
	
	GtkWidget * view_widget;
	GtkWidget * label_widget;
	
	GtkWidget * popupmenu;
	
	public:
	
	gtk_view(gtk_project *);
	virtual ~gtk_view(void);
	
	project * GetProject(void);		// virtual
	void SetTitle(const char *);		// virtual
};

/*################################################################################################*/

/// A GTK-version of "##ogl_view".

class gtk_ogl_view : public gtk_view, virtual public ogl_view
{
	private:
	
	static vector<gtk_ogl_view *> oglv_vector;
	
	protected:
	
	bool is_realized;
	
/**	If the "##detached" pointer is different from NULL, it means that the view is
	displayed on a separate window (and not as a part of the GtkNotebook).
*/
	GtkWidget * detached;
	
friend class gtk_plot1d_view;
friend class gtk_plot2d_view;
friend class gtk_rcp_view;
friend class gtk_eld_view;
friend class gtk_ssc_view;
	
	public:
	
	gtk_ogl_view(gtk_project *);
	virtual ~gtk_ogl_view(void);
	
	void Update(bool);			// virtual
	bool SetCurrent(void);			// virtual
	
	private:
	
	virtual void ExposeEvent(void) = 0;
	
	static void RealizeHandler(GtkWidget *, gpointer);
	static gint ExposeHandler(GtkWidget *, GdkEventExpose *);
	static gint ButtonHandler(GtkWidget *, GdkEventButton *);
	static gint MotionNotifyHandler(GtkWidget *, GdkEventMotion *);
	static gint ConfigureHandler(GtkWidget *, GdkEventConfigure *);
	
	protected:
	
	static gint DetachedDeleteHandler(GtkWidget *, GdkEvent *);
	
	static gtk_ogl_view * GetOGLV(GtkWidget *);
};

/*################################################################################################*/

/// This class has a private constructor, so you can't use this in the usual way; use the GetInstance() instead.

class gtk_class_factory : public graphics_class_factory
{
	private:
	
	static gtk_class_factory * instance;
	gtk_class_factory(void);
	
	public:
	
	~gtk_class_factory(void);
	static gtk_class_factory * GetInstance(void);
	
	project_view * ProduceProjectView(project *);				// virtual
	
	graphics_view * ProduceGraphicsView(project *, camera *, bool);		// virtual
	
	plot1d_view * ProducePlot1DView(project *, i32s, const char *, const char *, bool);			// virtual
	plot2d_view * ProducePlot2DView(project *, i32s, const char *, const char *, const char *, bool);	// virtual
	
	rcp_view * ProduceRCPView(project *, i32s, const char *, const char *, bool);		// virtual
	
	eld_view * ProduceELDView(project *, bool);						// virtual
	ssc_view * ProduceSSCView(project *, bool);						// virtual
};

/*################################################################################################*/

#endif	// GTK_VIEWS_H

// eof
