// W32_APP.H : a Win32 application class.

// Copyright (C) 2006 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef W32_APP_H
#define W32_APP_H

#include "ghemicalconfig2.h"

#include "custom_app.h"
#include "w32_project.h"
#include "w32_tb_button.h"

#include <windows.h>

#include <sstream>
using namespace std;

/*################################################################################################*/

class w32_app :
	public custom_app
{
	private:
	
	static w32_app * instance;
	static const char frame_classname[];
	
	protected:
	
	HINSTANCE hinst;
	LPSTR myCmdLine;
	int myCmdShow;
	
	static HWND frame_hwnd;
	
	static w32_tb_button * bTLB_draw;
	static w32_tb_button * bTLB_erase;
	static w32_tb_button * bTLB_select;
	static w32_tb_button * bTLB_zoom;
	static w32_tb_button * bTLB_clipping;
	static w32_tb_button * bTLB_transl_xy;
	static w32_tb_button * bTLB_transl_z;
	static w32_tb_button * bTLB_orbit_xy;
	static w32_tb_button * bTLB_orbit_z;
	static w32_tb_button * bTLB_rotate_xy;
	static w32_tb_button * bTLB_rotate_z;
	static w32_tb_button * bTLB_measure;
	
	static w32_tb_button * bTLB_element;
	static w32_tb_button * bTLB_bondtype;
	static w32_tb_button * bTLB_setup;
	
	static HWND clientMDI_hwnd;
	
	static HWND clientLOG_hwnd;
	
	static float splitter_rel_pos;
	static int splitter_abs_pos;
	
	stringstream logs;
	
// friends...
// ^^^^^^^^^^
	
	friend class w32_wnd;		// for accessing client_hwnd...
	friend class w32_tb_button;	// for accessing bTLB_XXX...
	
	public:
	
	w32_app(HINSTANCE, LPSTR, int);
	void DoSafeStart(void);
	~w32_app(void);
	
	static w32_app * GetAppX(void);
	static w32_project * GetPrjX(void);
	
	static HINSTANCE GetHINST(void);
	
	static HWND GetFrame(void);
	static HWND GetClientMDI(void);
	
	protected:
	
	void SetNewProject(void);	// virtual
	
	public:
	
	static void sMessage(const char *);
	static void sWarningMessage(const char *);
	static void sErrorMessage(const char *);
	
	static bool sQuestion(const char *);
	static void sPrintToLog(const char *);
	
	void Message(const char *);		// virtual
	void WarningMessage(const char *);	// virtual
	void ErrorMessage(const char *);	// virtual
	
	bool Question(const char *);		// virtual
	void PrintToLog(const char *);		// virtual
	
	protected:
	
	static bool register_wnd_class(HINSTANCE);
	static bool unregister_wnd_class(HINSTANCE);
	
	static LRESULT CALLBACK frame_wnd_proc(HWND, UINT, WPARAM, LPARAM);
	
	public:
	
	static void handler_WM_CLOSE(HWND);
	static void handler_WM_DESTROY(void);
	
	void UpdateAllWindowTitles(void);	// virtual
	
	void CameraAdded(custom_camera *);		// virtual
	void CameraRemoved(custom_camera *);		// virtual
	
	void LightAdded(ogl_light *);			// virtual
	void LightRemoved(ogl_light *);			// virtual
	
	void GraphicsClientAdded(oglview_wcl *);	// virtual
	void GraphicsClientRemoved(oglview_wcl *);	// virtual
	
	void PlottingClientAdded(base_wcl *);		// virtual
	void PlottingClientRemoved(base_wcl *);		// virtual
	
	void ObjectAdded(ogl_smart_object *);		// virtual
	void ObjectRemoved(ogl_smart_object *);		// virtual
	
	void BuildChainsView(void);			// virtual
	void ClearChainsView(void);			// virtual
	
	void AtomAdded(atom *);				// virtual
	void AtomUpdateItem(atom *);			// virtual
	void AtomRemoved(atom *);			// virtual
	
	void BondAdded(bond *);				// virtual
	void BondUpdateItem(bond *);			// virtual
	void BondRemoved(bond *);			// virtual
	
// the splitter stuff starts here ; the splitter stuff starts here
// the splitter stuff starts here ; the splitter stuff starts here
// the splitter stuff starts here ; the splitter stuff starts here
	
	static void splitter_DrawXorBar(HDC, int, int, int, int);
	static void splitter_SizeWindowContents(int, int);
	
	static LRESULT splitter_OnLButtonDown(HWND, UINT, WPARAM, LPARAM);
	static LRESULT splitter_OnLButtonUp(HWND, UINT, WPARAM, LPARAM);
	
	static LRESULT splitter_OnMouseMove(HWND, UINT, WPARAM, LPARAM);
	
// the toolbar-button callbacks start here ; the toolbar-button callbacks start here
// the toolbar-button callbacks start here ; the toolbar-button callbacks start here
// the toolbar-button callbacks start here ; the toolbar-button callbacks start here
	
// the main-menu callbacks start here ; the main-menu callbacks start here
// the main-menu callbacks start here ; the main-menu callbacks start here
// the main-menu callbacks start here ; the main-menu callbacks start here
	
/*	static void mainmenu_FileNew(gpointer, guint, GtkWidget *);
	static void mainmenu_FileOpen(gpointer, guint, GtkWidget *);
	static void mainmenu_FileClose(gpointer, guint, GtkWidget *);
	
	static void mainmenu_HelpHelp(gpointer, guint, GtkWidget *);
	static void mainmenu_HelpAbout(gpointer, guint, GtkWidget *);	*/
};

/*################################################################################################*/

#endif	// W32_APP_H

// eof
