#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

static FILE *LOG;

// close the logfile
void LogClose(void)
{
	if(LOG) {
		fclose(LOG);
		LOG=NULL;
	}
}

// open the logfile
void LogOpen(char *logfile)
{
	if(LOG) LogClose(); // close old logfile when necessary
	fclose(stdin);
	umask(0066); // logfiles should have mode 600
	if(!(LOG=fopen(logfile, "a")))
		fprintf(stderr,"Warning: Unable to open logfile \"%s\" for writing (%s)\n", logfile, strerror(errno));
}

// write one log entry
void Log(char *fmt, ...)
{
	time_t tt = time(NULL);
	char *tm = ctime(&tt);
	va_list ap;
	
	if(!LOG) return;
	tm[strlen(tm)-1]=0;
	va_start(ap, fmt);
//	fprintf(LOG, "%s (%i) ", tm, getpid());
	fprintf(LOG, "%010lu:%05i ", tt, getpid());
	vfprintf(LOG, fmt, ap);
	fprintf(LOG, "\n");
	va_end(ap);
	fflush(LOG);
}

// log error occured in some function
void LogError(char *fnct)
{
	Log("%s(): %s", fnct, strerror(errno));
	exit(-1);
}
	
