/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "main.h"

#include <gtk/gtk.h>

#include "ui.h"

#include "ui_util.h"

/**/

static gpointer parent_class = NULL;

static void giftui_notebook_init (GiftuiNotebook *parent);
static void giftui_notebook_class_init (GiftuiNotebookClass *class);

static void notebook_insert_child (GiftuiParent *, GtkWidget *, GtkWidget *);
static void notebook_remove_child (GiftuiParent *, GtkWidget *);
static void notebook_move_child (GiftuiParent *, GtkWidget *, GtkWidget *);
static void notebook_raise_child (GiftuiParent *, GtkWidget *);

static GtkWidget *notebook_current_child (GiftuiParent *);

/**/

GType
giftui_notebook_get_type (void)
{
	static GType notebook_type = 0;
	
	if (!notebook_type)
	{
		static const GTypeInfo notebook_type_info =
			{
				sizeof (GiftuiNotebookClass),
				NULL,		/* base_init */
				NULL,		/* base_finalize */
				(GClassInitFunc) giftui_notebook_class_init,
				NULL,		/* class_finalize */
				NULL,		/* class_data */
				sizeof (GiftuiNotebook),
				0,		/* n_preallocs */
				(GInstanceInitFunc) giftui_notebook_init,
				NULL
			};
		
		notebook_type = g_type_register_static (GIFTUI_TYPE_PARENT, "GiftuiNotebook",
							&notebook_type_info, 0);
	}
	
	return notebook_type;
}

static void
giftui_notebook_class_init (GiftuiNotebookClass *class)
{
	GiftuiParentClass *p_class = GIFTUI_PARENT_CLASS (class);
	
	parent_class = g_type_class_peek_parent (class);
	
	p_class->insert = notebook_insert_child;
	p_class->remove = notebook_remove_child;
	p_class->move = notebook_move_child;
	p_class->raise = notebook_raise_child;
	
	p_class->current = notebook_current_child;
	
	return;
}

static void
giftui_notebook_init (GiftuiNotebook *parent)
{
	parent->notebook = gtk_notebook_new ();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (parent->notebook), GTK_POS_TOP);
	gtk_notebook_popup_enable (GTK_NOTEBOOK (parent->notebook));
	gtk_notebook_set_scrollable (GTK_NOTEBOOK (parent->notebook), TRUE);
	gtk_box_pack_start_defaults (GTK_BOX (parent), parent->notebook);
	
	return;
}

/**/

static void
giftui_notebook_changed (GtkNotebook *notebook, GtkNotebookPage *p,
			 gint page, gpointer data)
{
	GtkWidget *widget;
	
	widget = gtk_notebook_get_nth_page (notebook, page);
	giftui_child_set_highlight (GIFTUI_CHILD (widget), FALSE);
	
	return;
}

GtkWidget *
giftui_notebook_new (void)
{
       	GiftuiNotebook *pn;
	
	pn = g_object_new (GIFTUI_TYPE_NOTEBOOK, NULL);
	
	g_signal_connect (pn->notebook, "switch-page",
			  G_CALLBACK (giftui_notebook_changed),
			  NULL);
	
	gtk_widget_show_all (GTK_WIDGET (pn));
	
	return GTK_WIDGET (pn);
}

/**/

static void
notebook_insert_child (GiftuiParent *pa, GtkWidget *pos, GtkWidget *ch)
{
	gint new;
	GiftuiNotebook *no = GIFTUI_NOTEBOOK (pa);
	
	if (pos)
		new = gtk_notebook_page_num (GTK_NOTEBOOK (no->notebook),
					     pos);
	else
		new = -1;
	
	gtk_notebook_insert_page_menu (GTK_NOTEBOOK (no->notebook), ch,
				       GIFTUI_CHILD (ch)->hbox,
				       GIFTUI_CHILD (ch)->menu_label,
				       new + 1);
	
	return;
}

static void
notebook_remove_child (GiftuiParent *pa, GtkWidget *ch)
{
	gint num;
	GiftuiNotebook *no = GIFTUI_NOTEBOOK (pa);
	
	num = gtk_notebook_page_num (GTK_NOTEBOOK (no->notebook), ch);
	gtk_notebook_remove_page (GTK_NOTEBOOK (no->notebook), num);
	
	return;
}

static void
notebook_move_child (GiftuiParent *pa, GtkWidget *pos, GtkWidget *ch)
{
	gint new, current;
	GiftuiNotebook *no = GIFTUI_NOTEBOOK (pa);
	
	current = gtk_notebook_page_num (GTK_NOTEBOOK (no->notebook),
					 ch);
	
	if (pos)
		new = gtk_notebook_page_num (GTK_NOTEBOOK (no->notebook), pos);
	else
		new = -1;
	
	if ((new - current) > 0)
		gtk_notebook_reorder_child (GTK_NOTEBOOK (no->notebook),
					    ch, new);
	else
		gtk_notebook_reorder_child (GTK_NOTEBOOK (no->notebook),
					    ch, new + 1);
	
	return;
}

static void
notebook_raise_child (GiftuiParent *pa, GtkWidget *ch)
{
	gint num;
	GiftuiNotebook *no = GIFTUI_NOTEBOOK (pa);
	
	num = gtk_notebook_page_num (GTK_NOTEBOOK (no->notebook), ch);
	if (num >= 0)
		gtk_notebook_set_current_page (GTK_NOTEBOOK (no->notebook), num);
	
	return;
}

/* infos */

static GtkWidget *
notebook_current_child (GiftuiParent *pa)
{
	GList *t;
	GiftuiNotebook *no = GIFTUI_NOTEBOOK (pa);
	
	t = g_list_nth (g_list_first (pa->children),
			gtk_notebook_current_page (GTK_NOTEBOOK (no->notebook)));
	
	if (t)
		return GTK_WIDGET (t->data);
	
	return NULL;
}
