/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <stdio.h>
#include <gtk/gtk.h>

#include "configure.h"

#include "ui_parent.h"
#include "ui_child.h"

/**/

static gpointer parent_class = NULL;

static void giftui_parent_init (GiftuiParent *parent);
static void giftui_parent_class_init (GiftuiParentClass *class);
static void giftui_parent_finalize (GObject *object);

/**/

GType
giftui_parent_get_type (void)
{
	static GType parent_type = 0;
	
	if (!parent_type)
	{
		static const GTypeInfo parent_type_info =
			{
				sizeof (GiftuiParentClass),
				NULL,		/* base_init */
				NULL,		/* base_finalize */
				(GClassInitFunc) giftui_parent_class_init,
				NULL,		/* class_finalize */
				NULL,		/* class_data */
				sizeof (GiftuiParent),
				0,		/* n_preallocs */
				(GInstanceInitFunc) giftui_parent_init,
				NULL
			};
		
		parent_type = g_type_register_static (GTK_TYPE_VBOX, "GiftuiParent",
						      &parent_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	
	return parent_type;
}

static void
giftui_parent_class_init (GiftuiParentClass *class)
{
	GObjectClass *object_class = G_OBJECT_CLASS (class);
	
	parent_class = g_type_class_peek_parent (class);
	
	object_class->finalize = giftui_parent_finalize;
	
	class->insert = NULL;
	class->remove = NULL;
	class->move = NULL;
	class->raise = NULL;
	
	class->current = NULL;
	
	return;
}

static void
giftui_parent_init (GiftuiParent *parent)
{
	parent->children = NULL;
	
	return;
}

static void
giftui_parent_finalize (GObject *object)
{
	GiftuiParent *parent = GIFTUI_PARENT (object);
	
	if (parent->children)
		g_list_free (parent->children);
	
	G_OBJECT_CLASS (parent_class)->finalize (object);
	
	return;
}

/* Informations */

GtkWidget *
giftui_parent_current_child (GiftuiParent *pa)
{
	GiftuiParentClass *class;
	
	g_return_val_if_fail (GIFTUI_IS_PARENT (pa), NULL);
	
	class = GIFTUI_PARENT_GET_CLASS (pa);
	
	g_return_val_if_fail (class->current, NULL);
	
	if (!pa->children)
		return NULL;
	
	return GTK_WIDGET (class->current (pa));
}

GtkWidget *
giftui_parent_next_child (GiftuiParent *pa, GtkWidget *ch)
{
	GList *n;
	
	g_return_val_if_fail (GIFTUI_IS_PARENT (pa), NULL);
	g_return_val_if_fail (GIFTUI_IS_CHILD (ch), NULL);
	
	if (!(n = g_list_find (pa->children, ch)))
		return NULL;
	
	n = n->next;
	if (n)
		return GTK_WIDGET (n->data);
	
	return NULL;
}

GtkWidget *
giftui_parent_prev_child (GiftuiParent *pa, GtkWidget *ch)
{
	GList *n;
	
	g_return_val_if_fail (GIFTUI_IS_PARENT (pa), NULL);
	g_return_val_if_fail (GIFTUI_IS_CHILD (ch), NULL);
	
	if (!(n = g_list_find (pa->children, ch)))
		return NULL;
	
	n = n->prev;
	if (n)
		return GTK_WIDGET (n->data);
	
	return NULL;
}

/* actions */

void
giftui_parent_insert_child (GiftuiParent *pa, GtkWidget *pos, GtkWidget *ch)
{
	GiftuiParentClass *class;
	
	g_return_if_fail (GIFTUI_IS_PARENT (pa));
	g_return_if_fail (GIFTUI_IS_CHILD (ch));
	
	class = GIFTUI_PARENT_GET_CLASS (pa);
	
	g_return_if_fail (class->insert != NULL);
	
	/* Already in ? */
	if (g_list_find (pa->children, ch))
		return;
	
	if (pos)
	{
		gint p;
		
		if ((p = g_list_index (pa->children, pos)) < 0)
			return;
		
		pa->children = g_list_insert (pa->children, ch, p + 1);
	}
	else
		pa->children = g_list_prepend (pa->children, ch);
	GIFTUI_CHILD (ch)->parent = GTK_WIDGET (pa);
	pa->children = g_list_first (pa->children);
	
	class->insert (pa, pos, ch);
	
	return;
}

void
giftui_parent_remove_child (GiftuiParent *pa, GtkWidget *ch)
{
	GList *l;
	GiftuiParentClass *class;
	
	g_return_if_fail (GIFTUI_IS_PARENT (pa));
	g_return_if_fail (GIFTUI_IS_CHILD (ch));
	
	class = GIFTUI_PARENT_GET_CLASS (pa);
	
	g_return_if_fail (class->remove != NULL);
	
	if (!(l = g_list_find (pa->children, ch)))
		return;
	
	pa->children = g_list_first (g_list_delete_link (pa->children, l));
	
	g_object_ref (G_OBJECT (ch));
	
	class->remove (pa, ch);
	GIFTUI_CHILD (ch)->parent = NULL;
	
	return;
}

void
giftui_parent_move_child (GiftuiParent *pa, GtkWidget *pos, GtkWidget *ch)
{
	GList *n, *f;
	GiftuiParentClass *class;
	
	g_return_if_fail (GIFTUI_IS_PARENT (pa));
	g_return_if_fail (GIFTUI_IS_CHILD (ch));
	
	class = GIFTUI_PARENT_GET_CLASS (pa);
	
	if (!class->move)
		return;
	
	if (!(n = g_list_find (pa->children, ch)))
		return;
	
	/* Hands modification */
	if (pos)
	{
		if (!(f = g_list_find (pa->children, pos)))
			return;
		
		pa->children = g_list_remove_link (pa->children, n);
		
		n->prev = f;
		n->next = f->next;
		if (n->next)
			n->next->prev = n;
		f->next = n;
	}
	else
	{
		pa->children = g_list_remove_link (pa->children, n);
		f = g_list_first (pa->children);
		
		n->prev = f->prev;
		n->next = f;
		f->prev = n;
	}
	pa->children = g_list_first (pa->children);
	
	class->move (pa, pos, ch);
	
	return;
}

void
giftui_parent_raise_child (GiftuiParent *pa, GtkWidget *ch)
{
	GiftuiParentClass *class;
	
	g_return_if_fail (GIFTUI_IS_PARENT (pa));
	g_return_if_fail (GIFTUI_IS_CHILD (ch));
	
	class = GIFTUI_PARENT_GET_CLASS (pa);
	
	g_return_if_fail (class->raise != NULL);
	
	if (!g_list_find (pa->children, ch))
		return;
	
	class->raise (pa, ch);
	
	return;
}

void
giftui_parent_save_children_positions (GiftuiParent *pa)
{
	gchar *s, str[1024];
	GList *l;
	
	g_return_if_fail (GIFTUI_IS_PARENT (pa));
	
	l = g_list_last (pa->children);
	s = str;
	
	*s = '\0';
	while (l)
	{
		s += sprintf (s, "%i", GIFTUI_CHILD (l->data)->type);
		*(s++) = '/';
		l = l->prev;
	}
	*(s - 1) = '\0';
	
	giftui_config_set_str ("/apps/giftui/main/tabs", str);
	
	return;
}
