
import datetime
import os
import urllib

import gtk

from gimmie_base import ItemSource
from gimmie_file import FileItem
from gimmie_util import recent_model


class RecentlyUsed(ItemSource):
    '''
    Recently-used documents, log stored in ~/.recently-used.
    '''
    def __init__(self, name, icon = "stock_calendar"):
        ItemSource.__init__(self, name, icon)
        
        recent_model.connect("changed", self._model_changed)

    def _model_changed(self, model = None, list = None):
        self.emit("reload")

    def do_reload(self):
        recent_items = []

        for item in recent_model.get_list():
            # skip private items (like porn)
            if item.get_private():
                continue

            # Check whether to include this item
            if self.include_recent_item(item):
                recent_item = FileItem(item.get_uri(), item.get_timestamp())
                recent_items.append(recent_item)

        self.set_items(recent_items)

    def include_recent_item(self, item):
        return True


class RecentlyUsedOfMimeType(RecentlyUsed):
    '''
    Recently-used items filtered by a set of mimetypes.
    '''
    def __init__(self, name, icon, mimetype_list):
        RecentlyUsed.__init__(self, name, icon)
        self.mimetype_list = mimetype_list

    def include_recent_item(self, item):
        item_mime = item.get_mime_type()
        for mimetype in self.mimetype_list:
            if hasattr(mimetype, "match") and mimetype.match(item_mime) \
                   or item_mime == mimetype:
                return True
        return False

