/** @file registrar.cpp
 *
 *  GiNaC's class registrar (for class basic and all classes derived from it). */

/*
 *  GiNaC Copyright (C) 1999-2005 Johannes Gutenberg University Mainz, Germany
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <string>
#include <map>
#include <stdexcept>

#include "registrar.h"

namespace GiNaC {

unsigned find_tinfo_key(const std::string &class_name)
{
	return registered_class_info::find(class_name)->options.get_id();
}

unarch_func find_unarch_func(const std::string &class_name)
{
	return registered_class_info::find(class_name)->options.get_unarch_func();
}

} // namespace GiNaC
