/*
 *
 *  $Id: countdownmessage.cpp 4721 2012-02-17 14:01:14Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */

#include "countdownmessage.h"
#include <wx/ginkgostyle/ginkgostyle.h>
#include <main/gui/mainwindow/ventanaprincipal.h>
#include <main/controllers/inactivitycontroller.h>
#include <main/entorno.h>

namespace GNC {
	namespace GUI {
		CountdownMessage::CountdownMessage(wxWindow* pParent): CountdownMessageBase(pParent)
		{
			m_pFormPanel->Layout();
			m_pBody->Layout();
			Layout();
		}

		CountdownMessage::~CountdownMessage()
		{
			GNC::GCS::InactivityController::Instance()->DetachForm();
		}

		bool CountdownMessage::Show(bool show)
		{
			if (show && !IsShown()) {
				m_last = 6;			
				Notify();
			} else {
				if (IsRunning()) {
					Stop();
				}
				GNC::GCS::InactivityController::Instance()->RestartMonitoring();
			}
			return CountdownMessageBase::Show(show);
		}

		void CountdownMessage::Notify()
		{
			if (m_last > 0) {
				Freeze();
				m_last--; 
				m_pLabelInactivity->SetLabel(wxString::Format(_("Ginkgo CADx has detected inactivity and it will be closed in %d seconds.\nDo you want to continue?"), m_last));
				m_pFormPanel->Layout();
				m_pBody->Layout();
				Layout();
				this->Start(1000, true);
				Thaw();
			} else {
				GNC::Entorno::Instance()->GetVentanaPrincipal()->Close();
			}
		}

		void CountdownMessage::OnCancel(wxCommandEvent &)
		{
			GNC::GCS::InactivityController::Instance()->RestartMonitoring();
			if (IsRunning()) {
				Stop();
			}
			////////	
			Hide();
		}

		void CountdownMessage::OnCloseButton(wxCommandEvent &/*event*/)
		{
			GNC::Entorno::Instance()->GetVentanaPrincipal()->Close();
		}
		void CountdownMessage::OnClose(wxCloseEvent &event)
		{
			GNC::GCS::InactivityController::Instance()->RestartMonitoring();
			if (IsRunning()) {
				Stop();
			}
			event.Veto();
			Hide();
		}
	}
}
