/*
 *  
 *  $Id: panelgrid.h 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <main/gui/mainwindow/ventanaprincipalbase.h>
#include <api/icontroladorvistas.h>

class VentanaPrincipal;
class IconoImagenCtrl;

namespace GNC {
	namespace GUI {
		class DialogoDesencajado: public DialogoDesencajadoBase, public GNC::GCS::IObservadorVistas
		{
		public:
			DialogoDesencajado(wxWindow* pParent, VentanaPrincipal* pVentanaPrincipal);
			~DialogoDesencajado();
			void AddPanel(wxWindow* pWin, const wxString& titulo);
			void SetTitulo(const wxString& titulo);
			wxWindow* GetWindow();
			wxString GetTitulo();

		protected:
			void OnBotonTitulo(wxCommandEvent &);
			virtual void OnCloseDialogo(wxCloseEvent &event);
			virtual void OnVistaActivada(GNC::GCS::IVista* pVista);
			virtual void RefrescarVista(GNC::GCS::IVista* pVista);

			wxWindow* m_pWindow;
			VentanaPrincipal* m_pVentanaPrincipal;

			IconoImagenCtrl* m_pBCerrar;
			IconoImagenCtrl* m_pBOpciones;
		};

		class PanelGrid: public PanelGridBase
		{
		public:
			PanelGrid(wxWindow* pParent, VentanaPrincipal* pVentanaPrincipal);
			~PanelGrid();
			void AddPanel(wxWindow* pWin, const wxString& titulo);
			void SetTitulo(const wxString& titulo);
			wxWindow* GetWindow();
			wxString GetTitulo();
			bool Cerrar();
		protected:
			virtual void OnPanelGridClose(wxCommandEvent &event);
			virtual void OnPrimerPlano(wxCommandEvent &event);
			void OnBotonTitulo(wxCommandEvent &);
			virtual void OnMenuTitulo( wxMouseEvent& event );
			virtual void OnRightButtonUp( wxMouseEvent& event );
			void MostrarMenu();

			void OnMosaicoHorizontal(wxCommandEvent& event);
			void OnMosaicoVertical(wxCommandEvent& event);
			void OnMosaicoRestaurar(wxCommandEvent& event);
			void OnMosaicoGrid2Col(wxCommandEvent& event);
			void OnMosaicoGrid3Col(wxCommandEvent& event);
			void OnPantallaCompleta(wxCommandEvent& event);
			void OnMenuCerrarTodosTabsClick(wxCommandEvent& event);

			void OnSize(wxSizeEvent &event);
			void OnPaint(wxPaintEvent& event);
			void OnEraseBackground(wxEraseEvent& event);

			wxWindow* m_pWindow;
			VentanaPrincipal* m_pVentanaPrincipal;
			IconoImagenCtrl* m_pBCerrar;
			IconoImagenCtrl* m_pBPrimerPlano;
			IconoImagenCtrl* m_pBReagrupar;
			wxString m_titulo;
		};
	}
}
