/*
 *
 *  $Id: reconstructioninteractor.cpp 3395 2011-02-23 13:05:49Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */


#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include "reconstructioninteractor.h"
#include <vtkAbstractPropPicker.h>
#include <vtkAssemblyPath.h>
#include <vtkMath.h>
#include <vtkObjectFactory.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkImageData.h>
#include <vtkRenderWindow.h>
#include <vtkCamera.h>
#include <vtkRenderer.h>
#include <vtkCommand.h>
#include <vtkDebugLeaks.h>

vtkCxxRevisionMacro(GinkgoInteractorStyleReconstruction, "$Revision: 1 $")
vtkInstantiatorNewMacro(GinkgoInteractorStyleReconstruction)

GinkgoInteractorStyleReconstruction * GinkgoInteractorStyleReconstruction::New()
{
  return new GinkgoInteractorStyleReconstruction;
}

//----------------------------------------------------------------------------

GinkgoInteractorStyleReconstruction::GinkgoInteractorStyleReconstruction() : vtkInteractorStyleImage()
{
	vtkDebugLeaks::ConstructClass("GinkgoInteractorStyleReconstruction");
	this->LevelStep = 0.0;
	this->WindowStep = 0.0;
}

//----------------------------------------------------------------------------

GinkgoInteractorStyleReconstruction::~GinkgoInteractorStyleReconstruction()
{
}

//----------------------------------------------------------------------------

void GinkgoInteractorStyleReconstruction::OnMouseMove()
{
	int x = this->Interactor->GetEventPosition()[0];
	int y = this->Interactor->GetEventPosition()[1];

	switch (this->State) {
		case VTKIS_WINDOW_LEVEL:
			this->FindPokedRenderer(x, y);
			this->WindowLevel();
			this->InvokeEvent(vtkCommand::InteractionEvent, NULL);
		default:
			break;
	}
}


//----------------------------------------------------------------------------

void GinkgoInteractorStyleReconstruction::OnLeftButtonDown()
{

	int x = this->Interactor->GetEventPosition()[0];
	int y = this->Interactor->GetEventPosition()[1];

	this->FindPokedRenderer(x, y);
	if (!this->CurrentRenderer) {
		return;
	}

	this->WindowLevelStartPosition[0] = x;
	this->WindowLevelStartPosition[1] = y;
	this->StartWindowLevel();
}

//----------------------------------------------------------------------------

void GinkgoInteractorStyleReconstruction::OnLeftButtonUp()
{
	 this->EndWindowLevel();
}


//----------------------------------------------------------------------------

void GinkgoInteractorStyleReconstruction::OnMiddleButtonDown()
{
	int x = this->Interactor->GetEventPosition()[0];
	int y = this->Interactor->GetEventPosition()[1];

	this->FindPokedRenderer(x, y);
	if (!this->CurrentRenderer) {
		return;
	}

	this->WindowLevelStartPosition[0] = x;
	this->WindowLevelStartPosition[1] = y;
	this->StartWindowLevel();
}

//----------------------------------------------------------------------------

void GinkgoInteractorStyleReconstruction::OnMiddleButtonUp()
{
	this->EndWindowLevel();
}

//----------------------------------------------------------------------------

void GinkgoInteractorStyleReconstruction::OnRightButtonDown()
{

	int x = this->Interactor->GetEventPosition()[0];
	int y = this->Interactor->GetEventPosition()[1];

	this->FindPokedRenderer(x, y);
	if (!this->CurrentRenderer) {
		return;
	}

	this->WindowLevelStartPosition[0] = x;
	this->WindowLevelStartPosition[1] = y;
	this->StartWindowLevel();
}

//----------------------------------------------------------------------------

void GinkgoInteractorStyleReconstruction::OnRightButtonUp()
{
	switch (this->State) {
		case VTKIS_WINDOW_LEVEL:
			this->EndWindowLevel();
			break;
	}
}

//----------------------------------------------------------------------------

void GinkgoInteractorStyleReconstruction::OnChar()
{
}

//----------------------------------------------------------------------------//----------------------------------------------------------------------------

void GinkgoInteractorStyleReconstruction::WindowLevel()
{

	vtkRenderWindowInteractor *rwi = this->Interactor;

	this->WindowLevelCurrentPosition[0] = rwi->GetEventPosition()[0];
	this->WindowLevelCurrentPosition[1] = rwi->GetEventPosition()[1];

	int *size = rwi->GetRenderWindow()->GetSize();

	// Compute normalized delta
	double dx = 4.0 * (this->GetWindowLevelCurrentPosition()[0] - this->GetWindowLevelStartPosition()[0]) / size[0];
	double dy = 4.0 * (this->GetWindowLevelStartPosition()[1] - this->GetWindowLevelCurrentPosition()[1]) / size[1];

	this->SetWindowStep(dx);
	this->SetLevelStep(dy);

	this->InvokeEvent(vtkCommand::WindowLevelEvent, this);
}

void GinkgoInteractorStyleReconstruction::WindowLevelWheelForward()
{
	vtkRenderWindowInteractor *rwi = this->Interactor;

	int *size = rwi->GetRenderWindow()->GetSize();

	double dy = 4.0 * (double) (this->MouseWheelMotionFactor) / size[1];

	this->SetWindowStep(0.0);
	this->SetLevelStep(dy);

	this->InvokeEvent(vtkCommand::WindowLevelEvent, this);
}

void GinkgoInteractorStyleReconstruction::WindowLevelWheelBackward()
{
	vtkRenderWindowInteractor *rwi = this->Interactor;
	int *size = rwi->GetRenderWindow()->GetSize();

	double dy = 4.0 * (double) (-1.0 * this->MouseWheelMotionFactor) / size[1];

	this->SetWindowStep(0.0);
	this->SetLevelStep(dy);

	this->InvokeEvent(vtkCommand::WindowLevelEvent, this);
}
//----------------------------------------------------------------------------

void GinkgoInteractorStyleReconstruction::OnMouseWheelForward()
{
	int x = this->Interactor->GetEventPosition()[0];
	int y = this->Interactor->GetEventPosition()[1];

	//double factor = 0.0;

	this->FindPokedRenderer(x, y);

	if (this->CurrentRenderer == NULL) {
		return;
	}

	this->StartWindowLevel();
	this->WindowLevelWheelForward();
	this->EndWindowLevel();
}

void GinkgoInteractorStyleReconstruction::OnMouseWheelBackward()
{
	int x = this->Interactor->GetEventPosition()[0];
	int y = this->Interactor->GetEventPosition()[1];

	//double factor = 0.0;

	this->FindPokedRenderer(x, y);

	if (this->CurrentRenderer == NULL) {
		return;
	}
	this->StartWindowLevel();
	this->WindowLevelWheelBackward();
	this->EndWindowLevel();
}
