/*
 *  
 *  $Id: icontroladoracciones.h 3066 2010-12-21 10:10:14Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once

#include<yasper/yasper.h>
#include <string>

namespace GNC {
	namespace GCS {
		class IVista;
	}
}

namespace GNC {
	namespace GCS {
		class Accion {
		public:
			Accion(const std::string& nombre, bool puedeRehacerse = true, const int peso = 1)
			{
				m_nombre = nombre;
				m_peso = peso;
				m_puedeRehacerse = puedeRehacerse;
			}
			virtual ~Accion() {}

			virtual const std::string& GetNombre()
			{
				return m_nombre;
			}
			virtual void Deshacer() = 0;
			virtual bool PuedeRehacer()
			{
				return m_puedeRehacerse;
			}
			virtual void Hacer() {}
		protected:
			virtual void SetPuedeRehacerse(bool puedeRehacerse = true)
			{
				m_puedeRehacerse = puedeRehacerse;
			}

			std::string m_nombre;
			int m_peso;
			bool m_puedeRehacerse;
		};

		class IControladorAcciones
		{
		public:
			IControladorAcciones(){}
			~IControladorAcciones(){}
			
			virtual void PushAccion(GNC::GCS::IVista* pVista, GnkPtr<Accion> pAccion) = 0;
		protected:
		};
	}
}

