/*
 *  
 *  $Id$
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *  Code based in VTK
 */
#include "hackimageactor.h"
#include <vtkRenderWindow.h>
#include <vtkgl.h>

vtkHackedTempImageActor::vtkHackedTempImageActor(vtkImageActor* realActor)
{
	vtkHackedTempImageActor* realhia =  ((vtkHackedTempImageActor* ) ((vtkOpenGLImageActor*)realActor) );
	m_IdTextura = realhia->Index;
	m_vtkRenderWindow = realhia->RenderWindow;
	
	m_TextureDimensions[0] = realhia->TextureSize[0];
	m_TextureDimensions[1] = realhia->TextureSize[1];
	this->SetReferenceCount(0);

}

vtkHackedTempImageActor::~vtkHackedTempImageActor()
{
}

long vtkHackedTempImageActor::GetTextureId() const
{
	return m_IdTextura;
}

const int* vtkHackedTempImageActor::GetTextureDimensions() const
{
	return m_TextureDimensions;
}

 vtkHackedTempImageActor::operator long () const
{
	return m_IdTextura;
}

bool vtkHackedTempImageActor::TextureDefined() const
{
 const unsigned int tid = m_IdTextura;

 if (m_vtkRenderWindow == NULL)
	 return false;

 return tid != 0;
}

 bool vtkHackedTempImageActor::TextureLoaded() const
 {
	 int width;
	 if (m_IdTextura != 0) {
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, m_IdTextura);
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 0, GL_TEXTURE_WIDTH, &width);
		glBindTexture(GL_TEXTURE_2D, 0);

		// Supermegahackkkkkkkkkk!
		if (glGetError() != 0)
			return false;

		glDisable(GL_TEXTURE_2D);
		if (width == m_TextureDimensions[0]) {
			return true;
		}
		else {
			return false;
		}
	 }
	 return true;

	/* 
	GLboolean resident = GL_FALSE;
	 const unsigned int tid = m_IdTextura;
	 if (tid != 0) {
		glAreTexturesResident(1, &tid, &resident);
	 }
	 else {
		 resident = GL_TRUE;
	 }
	 return (resident == GL_TRUE);
	 */
 }
