/*
 *
 *  $Id: dicomizecommand.cpp 3681 2011-04-12 10:53:31Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/globals.h>
#include <sstream>
#include <api/icontexto.h>
#include "dicomizecommand.h"
#include <map>
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/file.h>
#include <wx/msgdlg.h>
#include <wx/image.h>

#include <api/icontroladoreventos.h>
#include <api/icontroladorcomandos.h>
#include <api/controllers/ipacscontroller.h>
#include <api/dicom/idicomizador.h>
#include <api/dicom/idicommanager.h>
#include <api/dicom/imodelodicom.h>
#include <eventos/eventosginkgo.h>
#include <commands/comandoavisarficheros.h>

#include <export/tagsprivadoscomunes.h>
#include <main/controllers/controladorlog.h>




//0-1000000 are metaemotion's reserved
//it's used to implement politics of command preferences, pararell execution...
#define IDC_Dicomization           1000001

// Singleton de persistencia
namespace FooExtension {
	namespace GADAPI {

		DicomizeCommandParameters::DicomizeCommandParameters(GnkPtr< ::FooExtension::GUI::ImportationPersistentData > pPersistentData, GNC::GCS::IEntorno* pEntorno) 
		{
			m_pPersistentData = pPersistentData;
			m_pEntorno = pEntorno;
			//creates new temp dir
			wxString wxNewTmpDir;
			do {
				wxNewTmpDir = FROMPATH(m_pEntorno->GetGinkgoTempDir()) + wxFileName::GetPathSeparator(wxPATH_NATIVE) + wxT("_gnktmp_") + wxString::Format(wxT("%d"), rand());
			} while(wxDir::Exists(wxNewTmpDir));

	#ifdef _WIN32
			wxFileName::Mkdir(wxNewTmpDir);
	#else
			wxFileName::Mkdir(wxNewTmpDir.c_str(), 0777);
	#endif
			m_TmpDir = TOPATH(wxNewTmpDir);
			///
			m_errorMessage = "";
		}

		DicomizeCommandParameters::~DicomizeCommandParameters() {
		}


		DicomizeCommand::DicomizeCommand(DicomizeCommandParameters* pParams) : IComando(pParams)
		{
			m_pDicomizationParameters = pParams;
			//this is used to set command dependencies like WaitFor(EsperaA), Cancel(CancelaA), AbortIf(AbortaSi)
			SetId(IDC_Dicomization);
			//this command waits untill last IDC_Dicomization command has finished
			EsperaA(IDC_Dicomization);
		}

		//background processing
		void DicomizeCommand::Execute()
		{
			//dicomizeFiles
			if (ImportFiles())
			{
				//copy to Ginkgo CADx
				CopyDICOMToGinkgoCADx();
			}
		}

		//synchronized processing
		void DicomizeCommand::Update()
		{
			//shows an error or finish message
			if(m_pDicomizationParameters->m_errorMessage != "") {
				wxString mensaje = _("Import process failed:\n\t") + wxString::FromUTF8(m_pDicomizationParameters->m_errorMessage.c_str());
				wxMessageBox(mensaje,_("Error"), wxOK|wxICON_WARNING);
			} else {
				wxMessageBox(_("Importation has finished successfully"),_("Info"), wxOK|wxICON_INFORMATION);
			}
			RemoveTempDir(FROMPATH(m_pDicomizationParameters->m_TmpDir));
		}

		//called if the command is cancelled
		void DicomizeCommand::OnAbort()
		{
			RemoveTempDir(FROMPATH(m_pDicomizationParameters->m_TmpDir));
		}

		//performs importation, in this example we are going to call itk algorithm and performs dicomization
		bool DicomizeCommand::ImportFiles()
		{
			bool isFirst=true;

			GIL::DICOM::IPACSController* pCI = m_pDicomizationParameters->m_pEntorno->GetPACSController();

			int instanceNumber = 0;

			int fileNumber = 1;

			for(FooExtension::GUI::ImportationPersistentData::TFileList::iterator it= m_pDicomizationParameters->m_pPersistentData->m_dicomizedFiles.begin(); it!= m_pDicomizationParameters->m_pPersistentData->m_dicomizedFiles.end(); it++, fileNumber++) 
			{
				//progress message...
				{
					std::ostringstream ostr;
					ostr <<  _Std("Importing file ") << fileNumber << " of " << m_pDicomizationParameters->m_pPersistentData->m_dicomizedFiles.size();
					NotificarProgreso(0.05f, ostr.str() );
				}
				
				//perform some proccessing, for example blur image
				wxImage img(FROMPATH((*it).imagePath));
				img = img.Blur(50);
				//

				//dicomManager, to read dicomized files
				GIL::DICOM::IDICOMManager*	pDICOMManager = NULL;
				//dicomizer
				GIL::DICOM::IDICOMImg2DCM* pI2D = NULL;

				//end itk processing, stores output in tempFilePathSobel
				try {

					//we create instance of importation, it will help us in importation process
					pI2D = pCI->CrearInstanciaDeImportacion();

					//initialization of dicomizer with filtered image
					GIL::DICOM::IDICOMImg2DCM::TImageFile file(img.GetData(), img.GetWidth(), img.GetHeight());
					pI2D->Inicializar(file);

					//common tags
					GIL::DICOM::TipoJerarquia base = m_pDicomizationParameters->m_pPersistentData->baseImages;

					//instance number, it's a sequence for this series
					{
						std::ostringstream ostr;
						ostr << instanceNumber++;
						base.tags[std::string("0020|0013")] = ostr.str();
					}

					//insert tags
					pI2D->InsertarJerarquia(base);

					//we are going to write dicomized file in temp dir
					wxFileName inputFileName = wxFileName::FileName(FROMPATH((*it).imagePath));
					wxString tempFilePath = FROMPATH(m_pDicomizationParameters->m_TmpDir) + wxFileName::GetPathSeparator(wxPATH_NATIVE) + inputFileName.GetName() + wxT(".dcm");
					while (wxFile::Exists(tempFilePath)) {
						tempFilePath = FROMPATH(m_pDicomizationParameters->m_TmpDir) + wxFileName::GetPathSeparator(wxPATH_NATIVE) + inputFileName.GetName() + wxString::Format(wxT("%d.dcm"),rand());
					}

					//write DCM
					std::string outDCM(TOPATH(tempFilePath));
					pI2D->Convertir(outDCM);

					//free dicomizer
					pCI->LiberarInstanciaDeImportacion(pI2D);
					pI2D = NULL;

					//we are going to read tags from dicomized file
					{						
						std::string tag;
						//create instance
						pDICOMManager = pCI->CrearInstanciaDeDICOMManager();
						//load DICOM file
						pDICOMManager->CargarFichero(outDCM);
						if(isFirst || m_pDicomizationParameters->m_pPersistentData->AccessionNumber=="" || m_pDicomizationParameters->m_pPersistentData->StudyInstanceUID == "" || m_pDicomizationParameters->m_pPersistentData->SeriesUID == ""){
							isFirst=false;

							if(pDICOMManager->GetTag(0x0008,0x0050,tag)) {//accession number
								m_pDicomizationParameters->m_pPersistentData->AccessionNumber = tag;
								//set accession number in common tags
								m_pDicomizationParameters->m_pPersistentData->baseImages.tags[std::string("0008|0050")] = tag;
							}

							if(pDICOMManager->GetTag(0x0020,0x000d,tag)) {//studyUID
								m_pDicomizationParameters->m_pPersistentData->StudyInstanceUID = tag;
								//set study instance UID in common tags
								m_pDicomizationParameters->m_pPersistentData->baseImages.tags[std::string("0020|000d")] = tag;
							}

							if(pDICOMManager->GetTag(0x0020,0x000e,tag)) {//series instance uid
								m_pDicomizationParameters->m_pPersistentData->SeriesUID = tag;
								//set series instance UID in common tags
								m_pDicomizationParameters->m_pPersistentData->baseImages.tags[std::string("0020|000e")] = tag;
							}
						}
						pDICOMManager->GetTag(0x0008,0x0018,(*it).sopInstanceUID); //sop instance uid
						pDICOMManager->GetTag(0x0008,0x0016,(*it).sopClassUID);//sop class uid

						pCI->LiberarInstanciaDeDICOMManager(pDICOMManager);
						pDICOMManager = NULL;

						(*it).pathDCM = outDCM;
					}//fin leer tags

				}
				catch (GIL::DICOM::I2DException& e) {
					LOG_ERROR("DICOMIZATION", "Error in dicomization process: " << e);
					if (pI2D != NULL) {						
						pCI->LiberarInstanciaDeImportacion(pI2D);
					}
					if (pDICOMManager != NULL) {
						pCI->LiberarInstanciaDeDICOMManager(pDICOMManager);
					}
					return false;
				}				
				catch (std::exception& e) {
					LOG_ERROR("DICOMIZATION", "Error doing dicomization: " << e.what() );
					if (pI2D != NULL) {						
						pCI->LiberarInstanciaDeImportacion(pI2D);
					}
					if (pDICOMManager != NULL) {
						pCI->LiberarInstanciaDeDICOMManager(pDICOMManager);
					}
					return false;
				}
				catch (...) {
					LOG_ERROR("Internal error in dicomization process", "DICOMIZATION");
					if (pI2D != NULL) {
						pCI->LiberarInstanciaDeImportacion(pI2D);
					}
					if (pDICOMManager != NULL) {
						pCI->LiberarInstanciaDeDICOMManager(pDICOMManager);
					}
					return false;
				}
				
			}
			return true;
		}


		bool DicomizeCommand::CopyDICOMToGinkgoCADx()
		{
			bool correct = true;

			std::list<std::string> fileList;
			//we are going to move imported files to it's place into de DicomDir, to know where to move it, we have to ask entorno the series path
			wxDir dir;
			if (dir.Open(FROMPATH(m_pDicomizationParameters->m_TmpDir))) {
				wxString sourcePathWx,targetPathWx;
				bool cont = dir.GetFirst(&sourcePathWx,wxT("*.dcm"));
				std::string targetPathStd,sourcePathStd;
				GIL::DICOM::IDICOMManager*	pDICOMManager;
				GIL::DICOM::TipoJerarquia base;

				while (cont) {
					sourcePathWx=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +sourcePathWx;
					sourcePathStd = TOPATH(sourcePathWx);

					std::string idPaciente,uidEstudio,uidSerie,uidImagen;
					pDICOMManager= m_pDicomizationParameters->m_pEntorno->GetPACSController()->CrearInstanciaDeDICOMManager();
					pDICOMManager->CargarFichero(sourcePathStd);
					pDICOMManager->GetTag(0x0010,0x0020,idPaciente);
					pDICOMManager->GetTag(0x0020,0x000d,uidEstudio);
					pDICOMManager->GetTag(0x0020,0x000e,uidSerie);
					pDICOMManager->GetTag(0x0008,0x0018,uidImagen);
					m_pDicomizationParameters->m_pEntorno->GetPACSController()->LiberarInstanciaDeDICOMManager(pDICOMManager);

					//we ask for the path
					correct = correct && m_pDicomizationParameters->m_pEntorno->GetPACSController()->GetRutaImagen(idPaciente,uidEstudio,uidSerie,uidImagen,targetPathStd);
					targetPathWx = FROMPATH(targetPathStd);

					correct = correct && wxCopyFile(sourcePathWx,targetPathWx,true);

					fileList.push_back(targetPathStd);

					cont = dir.GetNext(&sourcePathWx);
				}
			}

			if(correct) {
				//add files to the history
				::GADAPI::ComandoAvisarFicherosParams * pParams = new ::GADAPI::ComandoAvisarFicherosParams(fileList);
				::GADAPI::ComandoAvisarFicheros * pCmd = new ::GADAPI::ComandoAvisarFicheros(pParams);
				m_pDicomizationParameters->m_pEntorno->GetControladorComandos()->ProcessAsync("Including files", pCmd, NULL);
			}
			return correct;
		}

		bool  DicomizeCommand::RemoveTempDir(const wxString& dirPath)
		{
			//delete on cascade
			if(!wxRmdir(dirPath)){
				wxDir dir;
				if (dir.Open(dirPath)) {
					wxString fileName;
					bool cont = dir.GetFirst(&fileName);
					while (cont) {
						fileName=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +fileName;
						if(wxDir::Exists(fileName)){
							if (RemoveTempDir(fileName)) {
								cont = dir.GetFirst(&fileName);
							} else {
								cont = dir.GetNext(&fileName);
							}
						}else{
							if (wxRemoveFile(fileName)) {
								cont = dir.GetFirst(&fileName);
							} else {
								cont = dir.GetNext(&fileName);
							}
						}
					}
				}
			}
			if(wxDir::Exists(dirPath)){
				return wxRmdir(dirPath);
			}
			return true;
		}
	}
}

