/*
 *  $Id: lightvisualizatorcontroller.cpp 3921 2011-07-06 11:36:02Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
#include <api/globals.h>
#include <vector>
#include <set>
#include <string>
#include <sstream>
#include <iostream>
#include <wx/config.h>

#include <wx/wx.h>
#include <wx/notebook.h>
#include <wx/aui/aui.h>
#include <wx/dir.h>
#include <wx/file.h>
#include <wx/filename.h>
#include <wx/mstream.h>

#include <api/ientorno.h>
#include <api/ivista.h>
#include <api/ianotador.h>
#include <api/dicom/imodelodicom.h>
#include <api/controllers/ipacscontroller.h>
#include <api/icontroladorvistas.h>
#include <api/icontroladorcarga.h>
#include <api/icontroladorhistorial.h>


#include <api/icontroladorpermisos.h>

#include "lightvisualizatorcontroller.h"
#include <lightvisualizator/views/lightvisualizatorview.h>
#include <lightvisualizator/studies/lightvisualizatorstudy.h>
#include <lightvisualizator/tools/toolwindowlevellight.h>


#include <api/icontroladorinternacionalizacion.h>
#include <lightvisualizator/license.h>


namespace LightVisualizator {
	//Controller mode of lightvisualizator extension, lightvisualizator extension can open 
	class LightVisualizatorControllerMode: public GNC::GCS::ModoControlador
	{
	public:
		//LightVisualizatorControllerMode: defines ways of Dicom viewing of this extension
		//id: unique in this controller
		//listaModalidades: modality supporting list
		//abreSeriesSueltas: true if it opens series, false if it opens studies
		//bitmap: bitmap of this mode (for visualization purposes)
		LightVisualizatorControllerMode(int id, const std::string& descripcion, TipoListaModalidades listaModalidades, TipoListaUIDsImportacion listaUIDsImportacion, bool abreSeriesSueltas, wxBitmap * bitmap = NULL):GNC::GCS::ModoControlador(id, descripcion, listaModalidades, listaUIDsImportacion, abreSeriesSueltas, bitmap)
		{
		}
		~LightVisualizatorControllerMode() {}

		//returns true if this mode supports this pair of modality-transfer syntax
		virtual bool SupportsModalityFile(const std::string &modalidad, const std::string& transferSyntax){
			for(TipoListaModalidades::iterator it = m_listaModalidades.begin(); it!= m_listaModalidades.end(); ++it){
				if((*it) == modalidad){					
					return true;
				}
			}
			return false;
		}
	};

	/* Constructor */
	LightVisualizatorController::LightVisualizatorController(GNC::GCS::IEntorno* pEntorno) : IControladorModulo(pEntorno, LIGHT_VISUALIZATOR_CONTROLLER_UID,6 )
	{
		//First we register internationalization catalog
		{
			pEntorno->GetControladorInternacionalizacion()->AddCatalog("lightvisualizator");
		}

		m_pEntorno = pEntorno;
		//name
		m_Nombre = LIGHT_VISUALIZATOR_DESCRIPTION;
		//copyright
		m_CopyRight = "(c) 2009 MetaEmotion S.L.";
		//author
		m_Author = "MetaEmotion S.L.";
		m_VersionMayor = LIGHT_VISUALIZATOR_VERSION;
		m_VersionMinor = LIGHT_VISUALIZATOR_SUB_VERSION;
		m_VersionRelease = LIGHT_VISUALIZATOR_SUB_RELEASE;
		m_CodeName = LIGHT_VISUALIZATOR_CODENAME;
		
		std::ostringstream ostr;
		ostr << m_VersionMayor << "." << m_VersionMinor << "." << m_VersionRelease << " " << m_CodeName;
		m_Version = ostr.str();

		
		GNC::GCS::IControladorHerramientas* cH = pEntorno->GetControladorHerramientas();
		cH->RegistrarHerramienta(new LightVisualizator::ToolWindowLevelLight());
	}

	LightVisualizatorController::~LightVisualizatorController()
	{
		GNC::GCS::IControladorHerramientas* cH = m_pEntorno->GetControladorHerramientas();
		LightVisualizator::IToolWindowLevelLight*    hWL          = NULL;
		try{
			hWL = cH->ObtenerHerramientaConcreta<LightVisualizator::IToolWindowLevelLight>(LightVisualizator::IToolWindowLevelLight::ID);
			if (hWL != NULL) {
				cH->DesRegistrarHerramienta(hWL);
				delete hWL;
			}
		}
		catch (GNC::GCS::ControladorHerramientasException& ex) {
			std::cerr << "Error al registrar herramientas de Oftal: No se pudo subscribir la herramienta: " << ex.getCause() << std::endl;
		}

		for (int i = 0; i < m_ListaModos.size(); ++i) {
			delete m_ListaModos[i];
		}

		if (m_Bitmap != NULL) {
			delete m_Bitmap;
			m_Bitmap = NULL;
		}
	}

	//It's mandatory to implement this method, here you have to register views of this module (Controller modes), this will register LightVisualizatorView .
	 void LightVisualizatorController::RegistrarVistas()
	 {
		 GNC::GCS::ModoControlador::TipoListaModalidades listaModalidades;
		listaModalidades.push_back(std::string("MR")); //resonancia
		listaModalidades.push_back(std::string("CR")); //computed radiography
		listaModalidades.push_back(std::string("US")); //ultrasonido
		listaModalidades.push_back(std::string("BI")); //biomagnetic image
		listaModalidades.push_back(std::string("CT")); //computed tomography
		listaModalidades.push_back(std::string("XA")); //XRAY angiografia
		listaModalidades.push_back(std::string("SC")); //secondary capture
		listaModalidades.push_back(std::string("NM")); //nuclear medicine
		listaModalidades.push_back(std::string("CD")); //Color flow doppler
		listaModalidades.push_back(std::string("DD")); //Duplex Doppler
		listaModalidades.push_back(std::string("DG")); //Diaphanography
		listaModalidades.push_back(std::string("ES")); //Endoscopy
		listaModalidades.push_back(std::string("LS")); //Laser surface scan
		listaModalidades.push_back(std::string("PT")); //Positron emission tomography (PET)
		listaModalidades.push_back(std::string("RG")); //Radiographic imaging
		listaModalidades.push_back(std::string("ST")); //Single-photon emission computed tomography (SPECT)
		listaModalidades.push_back(std::string("MG")); //Mammography
		listaModalidades.push_back(std::string("IO")); //Intra-Oral
		listaModalidades.push_back(std::string("TG")); //Thermography
		listaModalidades.push_back(std::string("RF")); //Radio Fluoroscopy
		listaModalidades.push_back(std::string("RTIMAGE")); //Radiotherapy Image
		listaModalidades.push_back(std::string("RTDOSE")); //Radiotherapy Dose
		listaModalidades.push_back(std::string("RTSTRUCT")); //Radiotherapy Structure Set
		listaModalidades.push_back(std::string("RTPLAN")); //Radiotherapy Plan
		listaModalidades.push_back(std::string("RTRECORD")); //RT Treatment Record
		listaModalidades.push_back(std::string("HC")); //Hard Copy
		listaModalidades.push_back(std::string("DX")); //Digital Radiography
		listaModalidades.push_back(std::string("PX")); //Panoramic X-Ray
		listaModalidades.push_back(std::string("GM")); //General Microscopy
		listaModalidades.push_back(std::string("SM")); //Slide Microscopy
		listaModalidades.push_back(std::string("XC")); //External-camera Photography
		listaModalidades.push_back(std::string("PR")); //Presentation State
		//listaModalidades.push_back(std::string("SR")); //SR Document
		listaModalidades.push_back(std::string("IVUS")); //Intravascular Ultrasound
		listaModalidades.push_back(std::string("OP")); //Stereometric Relationship
		listaModalidades.push_back(std::string("OT")); //Other
		listaModalidades.push_back(std::string("SMR")); //Intra-oral Radiography
		listaModalidades.push_back(std::string("OCT")); //Optical Coherence Tomography
		listaModalidades.push_back(std::string("OT"));  //Other
		listaModalidades.push_back(std::string("OPR")); //Ophthalmic Refraction
		listaModalidades.push_back(std::string("OPV")); //Ophthalmic Visual Field
		listaModalidades.push_back(std::string("OPM")); //Ophthalmic Mapping
		listaModalidades.push_back(std::string("KO"));  //Key Object Selection
		listaModalidades.push_back(std::string("SEG")); //Segmentation
		listaModalidades.push_back(std::string("REG")); //Registration
		listaModalidades.push_back(std::string("OPT")); //Ophthalmic Tomography
		listaModalidades.push_back(std::string("BDUS"));//Bone Densitometry (ultrasound)
		listaModalidades.push_back(std::string("BMD")); //Bone Densitometry (X-Ray)

		GNC::GCS::ModoControlador::TipoListaUIDsImportacion listaUIDsImportacion;

		m_ListaModos.push_back(new LightVisualizatorControllerMode(0, LIGHT_VISUALIZATOR_DESCRIPTION, listaModalidades, listaUIDsImportacion, true));
	 }


	//it's call by Ginkgo CADx core when this extension has to open a series with required module and required Diagnostic Study UID, returns an IVista (view)
	GNC::GCS::IVista* LightVisualizatorController::AbrirVista(int modo, ListaDescriptoresSerie& series, const std::string& uidEstudioDiagnostico)
	{
		LightVisualizator::LightVisualizatorView * pView = NULL;

		if (modo < 0 || modo >= (int) m_ListaModos.size()) {
			wxMessageDialog dialog( m_pEntorno->GetVentanaRaiz(), _("Error opening study"), _("Unknown mode"),  wxOK | wxICON_INFORMATION);
			dialog.ShowModal();
			return NULL;
		}

		//this module opens series, so we extract unique series, and we open one view for each series
		std::set<std::string> uidsSeries;
		{
			for(ListaDescriptoresSerie::iterator it = series.begin(); it!= series.end(); it++){
				if(m_ListaModos[modo]->SupportsModalityFile((*it).m_modalidad, (*it).m_uidTransferSyntax))
				{
					uidsSeries.insert((*it).m_uidSerie);
				}
			}
		}
		//

		for(std::set<std::string>::iterator it = uidsSeries.begin(); it!= uidsSeries.end(); it++)
		{
			//this call returns paths ordered
			std::vector<std::string> paths = m_pEntorno->GetControladorHistorial()->GetPathsSerieOrdenados((*it));

			//this is the view controller
			GNC::GCS::IControladorVistas* pCtrlVistas = m_pEntorno->GetControladorVistas();
			wxWindow* pVentanaPadre = NULL;

			{
				//this is to prevent flickering
				pVentanaPadre = pCtrlVistas->GetRootWindow();
				pCtrlVistas->Freeze();
				//
				try{
					if (modo == m_ListaModos[0]->GetId()) {
						wxWindowDisabler disabler;

						GnkPtr<LightVisualizator::LightVisualizatorStudy> study = new LightVisualizator::LightVisualizatorStudy();
						study->ListaUIDsSerie.push_back((*it));
						study->Entorno = m_pEntorno;
						study->Modulo = this;
						study->VentanaPadre = pVentanaPadre;
						study->InicializarContextoEstudio(paths, "", GNC::GCS::IContextoEstudio::TMF_UNDiagnostico);
						pView = new LightVisualizator::LightVisualizatorView (study);
						//register this new view
						pCtrlVistas->Registrar(pView);
					}
				}
				catch(GNC::GCS::VistaException &ex){
					if (pView != NULL) {
						pCtrlVistas->Destruir(pView);
					}
					pCtrlVistas->Thaw();
					wxString mensaje = wxString::FromUTF8(ex.GetCause().c_str());
					wxMessageDialog dialogo( m_pEntorno->GetVentanaRaiz(), mensaje, _("Error opening study"),  wxOK | wxICON_INFORMATION);
					dialogo.ShowModal();
					return NULL;
				}
				catch (...) {
					if (pView != NULL) {
						pCtrlVistas->Destruir(pView);
					}
					pCtrlVistas->Thaw();
					wxMessageDialog dialogo( m_pEntorno->GetVentanaRaiz(), _("Error opening study"), _("Error opening study"),  wxOK | wxICON_INFORMATION);
					dialogo.ShowModal();
					return NULL;
				}
				pCtrlVistas->Thaw();
			}//ends window freeze
			m_pEntorno->GetVentanaRaiz()->Update();

			if (pView == NULL ) {
				pCtrlVistas->Freeze();
				pCtrlVistas->Destruir(pView);
				pCtrlVistas->Thaw();
				return NULL;
			}
			else {
				//starts loader command, this command is asyncronous and makes all loading work
				GnkPtr<GIL::IModeloIntegracion> pModelo;
				m_pEntorno->GetControladorCarga()->CargaAsincrona(pView,pModelo, "");
			}
		}

		return pView;
	}

	//it supports importation workflow?
	bool LightVisualizatorController::SoportaImportacion() const {
		return false;
	}

	//returns importation steps
	void LightVisualizatorController::GetPasosImportacion(IWizard* pWizard,std::list<IPasoWizard*> &listaPasos, wxWindow* pParent, std::string &dirTemporal, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion)
	{
	}
};




