/*
 *  
 *  $Id: vista2d.h 3830 2011-05-06 13:30:18Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/ivista.h>
#include <export/icontratoscore.h>
#include <api/icontroladoreventos.h>
#include <api/controllers/ipacscontroller.h>
#include <api/icontroladorcarga.h> // TODO: Promover a IVista

class GVistaCompleja;
class wxWindow;
class wxVtkPageView;
namespace GNKVisualizator{
	class VisualizatorStudy;
	namespace GUI{
		class PanelResultados;
		class ContenedorHerramientas;
	}

	class Vista2D : public GNC::GCS::IVista, GNC::GCS::IObservador, public GNC::GCS::IContratoExportacionImages {
	public:
		/* Constructor */
		Vista2D(const GnkPtr<GNKVisualizator::VisualizatorStudy>& estudio);

		//----------------------------------------------------------------------------------------------------
		//region Interfaz de Carga

		// Comienzo de carga. Metodo sincrono con la interfaz.
		virtual void OnCargaIniciada();

		// Paso 1: Cargar los ficheros en memoria. Metodo NO sincrono con la interfaz.
		virtual void CargarEstudio(GNC::GCS::IComando* pCmdInvocador);

		// Finalizacion de la carga. Metodo sincrono con la interfaz.
		virtual void OnCargaFinalizada();

		// Paso 2: Inicializacion del pipeline. Metodo sincrono con la interfaz.
		virtual void IniciarPipeline();

		// Parada del pipeline. Metodo sincrono con la interfaz Se invoca en el caso de que ocurra un error de carga.
		virtual void DetenerPipeline();

		//endregion

		//region Interfaz IVista
		virtual bool SoportaHerramienta(GNC::GCS::IHerramienta* h);
		//endregion

		/* Destructor */
		~Vista2D();

		virtual bool SoportaGuardar();

		virtual bool SoportaExportar();

		std::string GetDICOMTagOriginal(std::string tagId);

		std::string GetDICOMTagDiagnostico(std::string tagId);

		virtual void OnFocus();

		virtual void Activar();

		virtual void Desactivar();

		//ListaRutas GetPathDiagnosticos();
		//ListaRutas GetDicomsActivos();

		virtual wxWindow* GetWindow();

		virtual bool Guardar();

		//virtual bool GuardarFichero(GNKVisualizator::FicheroDICOMGNKVisualizator* pFichero);

		virtual void PreProcesarEvento(GNC::GCS::Eventos::IEvento *, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& );

		void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);

		// Asigna los valores de los apuntadores a la la imagen y el slice actual
		void AsignarConexionesDeFiltrado(vtkImageData** pImagen, int* slice, vtkImageData** pChroma);

		void ActualizarImagen();

		virtual void OnConfiguracionCambiada();

		virtual void ActivarRuta(const std::string & path);

		//region "IContratoExportacionImagenes interface realization"
		void GetImageActual(ImageType::Pointer& img, MapaMapasValoracion& mapasValoracion, bool conWidgets, const GNC::GCS::Vector& size);
		void GetImage(ImageType::Pointer& img, int index, MapaMapasValoracion& mapasValoracion, bool conWidgets, const GNC::GCS::Vector& size);
		MapaMapasValoracion GetMapasValoracion();

		GIL::DICOM::TipoJerarquia  m_tagsActualizados;

		void SetModeloIntegracion(GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion);

		GnkPtr<GIL::IModeloIntegracion> GetModeloIntegracion();

		void ComienzaDestruccion();

		GnkPtr<GNKVisualizator::VisualizatorStudy>& GetVisualizatorStudy()
		{
			return VisualizatorStudy;
		}

		virtual void ActivarVista() {}

		virtual void DesactivarVista() {}

		GVistaCompleja*             GVista;
		GnkPtr<GNKVisualizator::VisualizatorStudy>  VisualizatorStudy;
	protected:
		bool					         m_IgnorarModificaciones;

		void GenerarTitulo();
	};
}

