/*
*
*  $Id: ipipeline.h 3404 2011-02-23 14:07:56Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#pragma once
#include <string>
#include <vtkSmartPointer.h>
#include <yasper/yasper.h>

class wxWindow;
class vtkImageData;
class vtkRenderer;

namespace MedicalViewer {
	namespace Reconstruction {
		namespace DataSet {
			class Slice;
			class DataSet;
		}
	}
}


namespace MedicalViewer {
	namespace Reconstruction {
		namespace Pipelines {
			class IReconstructionNotifier {
			public:
				virtual bool NotifyReconstructionProgress(const std::string& texto, float progress) = 0;
			};

			class IPipeline {
			public:
				typedef MedicalViewer::Reconstruction::DataSet::DataSet     TDataSet;
				typedef std::list< GnkPtr<TDataSet> >                       TDataSetList;

			protected:

				IPipeline(const std::string& name, wxWindow* win3d);

			public:
				virtual ~IPipeline();

				GnkPtr<TDataSet> FindDataSet(unsigned int vol);
				TDataSetList& GetDataSetList() {return DataSets;}

			public:

				const vtkSmartPointer<vtkRenderer>& GetRenderer() { return Renderer; }

				virtual void ResetCamera();

				virtual void Update() = 0;

				virtual void Print(const std::string& dest);

				virtual void Render();

				void RotateDemo(double angle);

				bool IsInitiallized() { return Initiallized; }

			protected:

				const std::string             PipelineName;

				TDataSetList                  DataSets;
				vtkSmartPointer<vtkImageData> CurrentImage;

				vtkSmartPointer<vtkRenderer>  Renderer;

				bool         Initiallized;

				wxWindow*    Win3D;

			};
		}
	}
}
