/*
 *  
 *  $Id: herramientarejillametrica.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <export/iherramientarejillametrica.h>
#include <widgets/wrejilla.h>
#include <api/icontroladoreventos.h>
#include <api/api.h>

#include <map>

namespace GNC {

	namespace GUI {
		class HerramientaOpcionesLupaGUI;
	}

	class EXTAPI HerramientaRejillaMetrica : public GNC::GCS::IHerramientaRejillaMetrica {

	public:

		HerramientaRejillaMetrica();
		~HerramientaRejillaMetrica();
		//menu de la rejilla
		virtual bool AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent);

		//region "Realización de la interfaz IHerramienta"

		// Eventos refinados desde los paneles
		bool IsVisible();
		void ToggleRejilla();
		void ActivarRejilla(bool activar, bool force=false);

		void SetEscalaX(double escala);
		void SetEscalaY(double escala);

		double GetEscalaX();
		double GetEscalaY();

		// Setup de paneles
		void CrearPaneles( wxPanel* panel );
		
		//endregion

		void SolicitarActivacion();

		void ConectarContratoFalso(bool activar);
		void SetVistaActiva(GNC::GCS::IVista* pVista);
		void ConectarContratos(bool activar);

	protected:
		bool m_RejillaVisible;

	};
}
