/*
 *  
 *  $Id: visualizator.cpp 4365 2011-11-03 14:01:58Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "visualizator.h"
#include <visualizator/license.h>
#include "visualizator/controllers/visualizatorcontroller.h"
#include <api/ientorno.h>
#include <iostream>
#include <wx/msgdlg.h>
#include <visualizator/resources/logo_visualizator.h>

#if defined(_WIN32) && defined(_GINKGO_DEBUG)
//#include <vld.h>
#endif

IMPLEMENT_PrivateExtension(GNKVisualizatorExtension)


GNKVisualizatorExtension::GNKVisualizatorExtension():PrivateExtension(EXT_SID, EXT_PROVIDER, EXT_DESCRIPTION, EXT_VERSION, EXT_SUBVERSION, EXT_RELEASE, EXT_BUILD, EXT_CODENAME, EXT_UPDATEURL, logo_visualizator, sizeof(logo_visualizator))
{
}

GNKVisualizatorExtension::~GNKVisualizatorExtension()
{
}
GNC::GCS::IControladorModulo* GNKVisualizatorExtension::InitializeLibrary(GNC::GCS::IEntorno* pEntorno)
{
	return new GNKVisualizator::ControladorAtencionPrimaria(pEntorno);
}
bool GNKVisualizatorExtension::IsActivated()
{
	return true;
}
void GNKVisualizatorExtension::ShowActivationDialog(wxWindow* pParent)
{
	wxMessageBox(_("Ginkgo CADx visualizator is Open Source"), _("Info"));
}

