/*
 *  
 *  $Id: datospersistentesimportacion.h 4303 2011-10-18 10:31:44Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <string>
#include <vector>
#include <yasper/yasper.h>
#include <api/imodelointegracion.h>
#include <sstream>

#include <api/controllers/ipacscontroller.h>

namespace GNKVisualizator {
	namespace GUI {
		typedef struct TipoWizardImportacion{
			//centro y medico
			std::string NombreCentro,NombreMedico;
			//datos de la serie
			std::string SerieFecha,SerieHora,SerieDescripcion,SerieUID;
			//datos del estudio
			std::string AccessionNumber,EstudioFecha,EstudioHora,EstudioDescripcion,StudyInstanceUID;
			//datos del paciente
			std::string PacienteNombre,PacienteApellido1,PacienteApellido2,PacienteIdentificador,PacienteFechaNacimiento,PacienteEdad,PacientePeso,PacienteAltura,PacienteSexo;

			//para la subida
			GnkPtr<GIL::IModeloIntegracion> m_pModeloImportacion;

			GIL::DICOM::TipoJerarquia baseImagenes;

			typedef struct TFicheroDicomizacionGNKVisualizator {
				std::string pathImagen;
				std::string sopInstanceUID;
				std::string pathDCM;
				std::string sopClassUID;
			} TFicheroDicomizacionGNKVisualizator;
			typedef std::list<TFicheroDicomizacionGNKVisualizator> TListaFicheros;
			
			TListaFicheros m_listaFicherosADicomizar;
			

			TipoWizardImportacion(GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion){
				AccessionNumber = "";
				SerieFecha="";
				SerieHora="";
				SerieDescripcion="";
				SerieUID="";

				EstudioFecha="";
				EstudioHora="";
				EstudioDescripcion="";
				StudyInstanceUID="";

				PacienteNombre="";
				PacienteApellido1="";
				PacienteApellido2="";
				PacienteIdentificador="";
				PacienteFechaNacimiento="";
				PacienteEdad="";
				PacientePeso="";
				PacienteAltura="";
				PacienteSexo="";		

				m_pModeloImportacion = pModeloIntegracion;
				if(pModeloIntegracion.IsValid()) {
					{
						std::ostringstream ostr;
						ostr<<pModeloIntegracion->Medico.apellido1 << '^' << pModeloIntegracion->Medico.apellido2 << '^' << pModeloIntegracion->Medico.nombre;
						NombreMedico = ostr.str();
					}
					NombreCentro = pModeloIntegracion->Medico.nombreCentro;

					PacienteNombre = pModeloIntegracion->Paciente.nombre;
					PacienteApellido1 = pModeloIntegracion->Paciente.apellido1;
					PacienteApellido2 = pModeloIntegracion->Paciente.apellido2;

					PacienteIdentificador = pModeloIntegracion->Paciente.GetIdentificadorPreferido().valor;
				} 
			}
			~TipoWizardImportacion()
			{
			}
			
		}TipoWizardImportacion;
	};
};
