// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservice

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/directoryservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the active log subscriptions for the Amazon Web Services account.
func (c *Client) ListLogSubscriptions(ctx context.Context, params *ListLogSubscriptionsInput, optFns ...func(*Options)) (*ListLogSubscriptionsOutput, error) {
	if params == nil {
		params = &ListLogSubscriptionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLogSubscriptions", params, optFns, c.addOperationListLogSubscriptionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLogSubscriptionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLogSubscriptionsInput struct {

	// If a DirectoryID is provided, lists only the log subscription associated with
	// that directory. If no DirectoryId is provided, lists all log subscriptions
	// associated with your Amazon Web Services account. If there are no log
	// subscriptions for the Amazon Web Services account or the directory, an empty
	// list will be returned.
	DirectoryId *string

	// The maximum number of items returned.
	Limit *int32

	// The token for the next set of items to return.
	NextToken *string

	noSmithyDocumentSerde
}

type ListLogSubscriptionsOutput struct {

	// A list of active LogSubscription objects for calling the Amazon Web Services
	// account.
	LogSubscriptions []types.LogSubscription

	// The token for the next set of items to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLogSubscriptionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListLogSubscriptions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListLogSubscriptions{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLogSubscriptions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListLogSubscriptions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ds",
		OperationName: "ListLogSubscriptions",
	}
}
