// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information about an action. Each rule must include exactly one of the following
// types of actions: forward, fixed-response, or redirect, and it must be the last
// action to be performed.
type Action struct {

	// The type of action.
	//
	// This member is required.
	Type ActionTypeEnum

	// [HTTPS listeners] Information for using Amazon Cognito to authenticate users.
	// Specify only when Type is authenticate-cognito.
	AuthenticateCognitoConfig *AuthenticateCognitoActionConfig

	// [HTTPS listeners] Information about an identity provider that is compliant with
	// OpenID Connect (OIDC). Specify only when Type is authenticate-oidc.
	AuthenticateOidcConfig *AuthenticateOidcActionConfig

	// [Application Load Balancer] Information for creating an action that returns a
	// custom HTTP response. Specify only when Type is fixed-response.
	FixedResponseConfig *FixedResponseActionConfig

	// Information for creating an action that distributes requests among one or more
	// target groups. For Network Load Balancers, you can specify a single target
	// group. Specify only when Type is forward. If you specify both ForwardConfig and
	// TargetGroupArn, you can specify only one target group using ForwardConfig and it
	// must be the same target group specified in TargetGroupArn.
	ForwardConfig *ForwardActionConfig

	// The order for the action. This value is required for rules with multiple
	// actions. The action with the lowest value for order is performed first.
	Order *int32

	// [Application Load Balancer] Information for creating a redirect action. Specify
	// only when Type is redirect.
	RedirectConfig *RedirectActionConfig

	// The Amazon Resource Name (ARN) of the target group. Specify only when Type is
	// forward and you want to route to a single target group. To route to one or more
	// target groups, use ForwardConfig instead.
	TargetGroupArn *string

	noSmithyDocumentSerde
}

// Request parameters to use when integrating with Amazon Cognito to authenticate
// users.
type AuthenticateCognitoActionConfig struct {

	// The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
	//
	// This member is required.
	UserPoolArn *string

	// The ID of the Amazon Cognito user pool client.
	//
	// This member is required.
	UserPoolClientId *string

	// The domain prefix or fully-qualified domain name of the Amazon Cognito user
	// pool.
	//
	// This member is required.
	UserPoolDomain *string

	// The query parameters (up to 10) to include in the redirect request to the
	// authorization endpoint.
	AuthenticationRequestExtraParams map[string]string

	// The behavior if the user is not authenticated. The following are possible
	// values:
	//
	// * deny - Return an HTTP 401 Unauthorized error.
	//
	// * allow - Allow the
	// request to be forwarded to the target.
	//
	// * authenticate - Redirect the request to
	// the IdP authorization endpoint. This is the default value.
	OnUnauthenticatedRequest AuthenticateCognitoActionConditionalBehaviorEnum

	// The set of user claims to be requested from the IdP. The default is openid. To
	// verify which scope values your IdP supports and how to separate multiple values,
	// see the documentation for your IdP.
	Scope *string

	// The name of the cookie used to maintain session information. The default is
	// AWSELBAuthSessionCookie.
	SessionCookieName *string

	// The maximum duration of the authentication session, in seconds. The default is
	// 604800 seconds (7 days).
	SessionTimeout *int64

	noSmithyDocumentSerde
}

// Request parameters when using an identity provider (IdP) that is compliant with
// OpenID Connect (OIDC) to authenticate users.
type AuthenticateOidcActionConfig struct {

	// The authorization endpoint of the IdP. This must be a full URL, including the
	// HTTPS protocol, the domain, and the path.
	//
	// This member is required.
	AuthorizationEndpoint *string

	// The OAuth 2.0 client identifier.
	//
	// This member is required.
	ClientId *string

	// The OIDC issuer identifier of the IdP. This must be a full URL, including the
	// HTTPS protocol, the domain, and the path.
	//
	// This member is required.
	Issuer *string

	// The token endpoint of the IdP. This must be a full URL, including the HTTPS
	// protocol, the domain, and the path.
	//
	// This member is required.
	TokenEndpoint *string

	// The user info endpoint of the IdP. This must be a full URL, including the HTTPS
	// protocol, the domain, and the path.
	//
	// This member is required.
	UserInfoEndpoint *string

	// The query parameters (up to 10) to include in the redirect request to the
	// authorization endpoint.
	AuthenticationRequestExtraParams map[string]string

	// The OAuth 2.0 client secret. This parameter is required if you are creating a
	// rule. If you are modifying a rule, you can omit this parameter if you set
	// UseExistingClientSecret to true.
	ClientSecret *string

	// The behavior if the user is not authenticated. The following are possible
	// values:
	//
	// * deny - Return an HTTP 401 Unauthorized error.
	//
	// * allow - Allow the
	// request to be forwarded to the target.
	//
	// * authenticate - Redirect the request to
	// the IdP authorization endpoint. This is the default value.
	OnUnauthenticatedRequest AuthenticateOidcActionConditionalBehaviorEnum

	// The set of user claims to be requested from the IdP. The default is openid. To
	// verify which scope values your IdP supports and how to separate multiple values,
	// see the documentation for your IdP.
	Scope *string

	// The name of the cookie used to maintain session information. The default is
	// AWSELBAuthSessionCookie.
	SessionCookieName *string

	// The maximum duration of the authentication session, in seconds. The default is
	// 604800 seconds (7 days).
	SessionTimeout *int64

	// Indicates whether to use the existing client secret when modifying a rule. If
	// you are creating a rule, you can omit this parameter or set it to false.
	UseExistingClientSecret *bool

	noSmithyDocumentSerde
}

// Information about an Availability Zone.
type AvailabilityZone struct {

	// [Network Load Balancers] If you need static IP addresses for your load balancer,
	// you can specify one Elastic IP address per Availability Zone when you create an
	// internal-facing load balancer. For internal load balancers, you can specify a
	// private IP address from the IPv4 range of the subnet.
	LoadBalancerAddresses []LoadBalancerAddress

	// [Application Load Balancers on Outposts] The ID of the Outpost.
	OutpostId *string

	// The ID of the subnet. You can specify one subnet per Availability Zone.
	SubnetId *string

	// The name of the Availability Zone.
	ZoneName *string

	noSmithyDocumentSerde
}

// Information about an SSL server certificate.
type Certificate struct {

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string

	// Indicates whether the certificate is the default certificate. Do not set this
	// value when specifying a certificate as an input. This value is not included in
	// the output when describing a listener, but is included when describing listener
	// certificates.
	IsDefault *bool

	noSmithyDocumentSerde
}

// Information about a cipher used in a policy.
type Cipher struct {

	// The name of the cipher.
	Name *string

	// The priority of the cipher.
	Priority int32

	noSmithyDocumentSerde
}

// Information about an action that returns a custom HTTP response.
type FixedResponseActionConfig struct {

	// The HTTP response code (2XX, 4XX, or 5XX).
	//
	// This member is required.
	StatusCode *string

	// The content type. Valid Values: text/plain | text/css | text/html |
	// application/javascript | application/json
	ContentType *string

	// The message.
	MessageBody *string

	noSmithyDocumentSerde
}

// Information about a forward action.
type ForwardActionConfig struct {

	// The target group stickiness for the rule.
	TargetGroupStickinessConfig *TargetGroupStickinessConfig

	// One or more target groups. For Network Load Balancers, you can specify a single
	// target group.
	TargetGroups []TargetGroupTuple

	noSmithyDocumentSerde
}

// Information about a host header condition.
type HostHeaderConditionConfig struct {

	// One or more host names. The maximum size of each name is 128 characters. The
	// comparison is case insensitive. The following wildcard characters are supported:
	// * (matches 0 or more characters) and ? (matches exactly 1 character). If you
	// specify multiple strings, the condition is satisfied if one of the strings
	// matches the host name.
	Values []string

	noSmithyDocumentSerde
}

// Information about an HTTP header condition. There is a set of standard HTTP
// header fields. You can also define custom HTTP header fields.
type HttpHeaderConditionConfig struct {

	// The name of the HTTP header field. The maximum size is 40 characters. The header
	// name is case insensitive. The allowed characters are specified by RFC 7230.
	// Wildcards are not supported. You can't use an HTTP header condition to specify
	// the host header. Use HostHeaderConditionConfig to specify a host header
	// condition.
	HttpHeaderName *string

	// One or more strings to compare against the value of the HTTP header. The maximum
	// size of each string is 128 characters. The comparison strings are case
	// insensitive. The following wildcard characters are supported: * (matches 0 or
	// more characters) and ? (matches exactly 1 character). If the same header appears
	// multiple times in the request, we search them in order until a match is found.
	// If you specify multiple strings, the condition is satisfied if one of the
	// strings matches the value of the HTTP header. To require that all of the strings
	// are a match, create one condition per string.
	Values []string

	noSmithyDocumentSerde
}

// Information about an HTTP method condition. HTTP defines a set of request
// methods, also referred to as HTTP verbs. For more information, see the HTTP
// Method Registry
// (https://www.iana.org/assignments/http-methods/http-methods.xhtml). You can also
// define custom HTTP methods.
type HttpRequestMethodConditionConfig struct {

	// The name of the request method. The maximum size is 40 characters. The allowed
	// characters are A-Z, hyphen (-), and underscore (_). The comparison is case
	// sensitive. Wildcards are not supported; therefore, the method name must be an
	// exact match. If you specify multiple strings, the condition is satisfied if one
	// of the strings matches the HTTP request method. We recommend that you route GET
	// and HEAD requests in the same way, because the response to a HEAD request may be
	// cached.
	Values []string

	noSmithyDocumentSerde
}

// Information about an Elastic Load Balancing resource limit for your Amazon Web
// Services account.
type Limit struct {

	// The maximum value of the limit.
	Max *string

	// The name of the limit. The possible values are:
	//
	// * application-load-balancers
	//
	// *
	// condition-values-per-alb-rule
	//
	// * condition-wildcards-per-alb-rule
	//
	// *
	// gateway-load-balancers
	//
	// * gateway-load-balancers-per-vpc
	//
	// *
	// geneve-target-groups
	//
	// * listeners-per-application-load-balancer
	//
	// *
	// listeners-per-network-load-balancer
	//
	// * network-load-balancers
	//
	// *
	// rules-per-application-load-balancer
	//
	// * target-groups
	//
	// *
	// target-groups-per-action-on-application-load-balancer
	//
	// *
	// target-groups-per-action-on-network-load-balancer
	//
	// *
	// target-groups-per-application-load-balancer
	//
	// *
	// targets-per-application-load-balancer
	//
	// *
	// targets-per-availability-zone-per-gateway-load-balancer
	//
	// *
	// targets-per-availability-zone-per-network-load-balancer
	//
	// *
	// targets-per-network-load-balancer
	Name *string

	noSmithyDocumentSerde
}

// Information about a listener.
type Listener struct {

	// [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN)
	// policy.
	AlpnPolicy []string

	// [HTTPS or TLS listener] The default certificate for the listener.
	Certificates []Certificate

	// The default actions for the listener.
	DefaultActions []Action

	// The Amazon Resource Name (ARN) of the listener.
	ListenerArn *string

	// The Amazon Resource Name (ARN) of the load balancer.
	LoadBalancerArn *string

	// The port on which the load balancer is listening.
	Port *int32

	// The protocol for connections from clients to the load balancer.
	Protocol ProtocolEnum

	// [HTTPS or TLS listener] The security policy that defines which protocols and
	// ciphers are supported.
	SslPolicy *string

	noSmithyDocumentSerde
}

// Information about a load balancer.
type LoadBalancer struct {

	// The subnets for the load balancer.
	AvailabilityZones []AvailabilityZone

	// The ID of the Amazon Route 53 hosted zone associated with the load balancer.
	CanonicalHostedZoneId *string

	// The date and time the load balancer was created.
	CreatedTime *time.Time

	// [Application Load Balancers on Outposts] The ID of the customer-owned address
	// pool.
	CustomerOwnedIpv4Pool *string

	// The public DNS name of the load balancer.
	DNSName *string

	// The type of IP addresses used by the subnets for your load balancer. The
	// possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and IPv6
	// addresses).
	IpAddressType IpAddressType

	// The Amazon Resource Name (ARN) of the load balancer.
	LoadBalancerArn *string

	// The name of the load balancer.
	LoadBalancerName *string

	// The nodes of an Internet-facing load balancer have public IP addresses. The DNS
	// name of an Internet-facing load balancer is publicly resolvable to the public IP
	// addresses of the nodes. Therefore, Internet-facing load balancers can route
	// requests from clients over the internet. The nodes of an internal load balancer
	// have only private IP addresses. The DNS name of an internal load balancer is
	// publicly resolvable to the private IP addresses of the nodes. Therefore,
	// internal load balancers can route requests only from clients with access to the
	// VPC for the load balancer.
	Scheme LoadBalancerSchemeEnum

	// The IDs of the security groups for the load balancer.
	SecurityGroups []string

	// The state of the load balancer.
	State *LoadBalancerState

	// The type of load balancer.
	Type LoadBalancerTypeEnum

	// The ID of the VPC for the load balancer.
	VpcId *string

	noSmithyDocumentSerde
}

// Information about a static IP address for a load balancer.
type LoadBalancerAddress struct {

	// [Network Load Balancers] The allocation ID of the Elastic IP address for an
	// internal-facing load balancer.
	AllocationId *string

	// [Network Load Balancers] The IPv6 address.
	IPv6Address *string

	// The static IP address.
	IpAddress *string

	// [Network Load Balancers] The private IPv4 address for an internal load balancer.
	PrivateIPv4Address *string

	noSmithyDocumentSerde
}

// Information about a load balancer attribute.
type LoadBalancerAttribute struct {

	// The name of the attribute. The following attribute is supported by all load
	// balancers:
	//
	// * deletion_protection.enabled - Indicates whether deletion
	// protection is enabled. The value is true or false. The default is false.
	//
	// The
	// following attributes are supported by both Application Load Balancers and
	// Network Load Balancers:
	//
	// * access_logs.s3.enabled - Indicates whether access
	// logs are enabled. The value is true or false. The default is false.
	//
	// *
	// access_logs.s3.bucket - The name of the S3 bucket for the access logs. This
	// attribute is required if access logs are enabled. The bucket must exist in the
	// same region as the load balancer and have a bucket policy that grants Elastic
	// Load Balancing permissions to write to the bucket.
	//
	// * access_logs.s3.prefix -
	// The prefix for the location in the S3 bucket for the access logs.
	//
	// *
	// ipv6.deny_all_igw_traffic - Blocks internet gateway (IGW) access to the load
	// balancer. It is set to false for internet-facing load balancers and true for
	// internal load balancers, preventing unintended access to your internal load
	// balancer through an internet gateway.
	//
	// The following attributes are supported by
	// only Application Load Balancers:
	//
	// * idle_timeout.timeout_seconds - The idle
	// timeout value, in seconds. The valid range is 1-4000 seconds. The default is 60
	// seconds.
	//
	// * routing.http.desync_mitigation_mode - Determines how the load
	// balancer handles requests that might pose a security risk to your application.
	// The possible values are monitor, defensive, and strictest. The default is
	// defensive.
	//
	// * routing.http.drop_invalid_header_fields.enabled - Indicates
	// whether HTTP headers with invalid header fields are removed by the load balancer
	// (true) or routed to targets (false). The default is false.
	//
	// *
	// routing.http.preserve_host_header.enabled - Indicates whether the Application
	// Load Balancer should preserve the Host header in the HTTP request and send it to
	// the target without any change. The possible values are true and false. The
	// default is false.
	//
	// * routing.http.x_amzn_tls_version_and_cipher_suite.enabled -
	// Indicates whether the two headers (x-amzn-tls-version and
	// x-amzn-tls-cipher-suite), which contain information about the negotiated TLS
	// version and cipher suite, are added to the client request before sending it to
	// the target. The x-amzn-tls-version header has information about the TLS protocol
	// version negotiated with the client, and the x-amzn-tls-cipher-suite header has
	// information about the cipher suite negotiated with the client. Both headers are
	// in OpenSSL format. The possible values for the attribute are true and false. The
	// default is false.
	//
	// * routing.http.xff_client_port.enabled - Indicates whether
	// the X-Forwarded-For header should preserve the source port that the client used
	// to connect to the load balancer. The possible values are true and false. The
	// default is false.
	//
	// * routing.http.xff_header_processing.mode - Enables you to
	// modify, preserve, or remove the X-Forwarded-For header in the HTTP request
	// before the Application Load Balancer sends the request to the target. The
	// possible values are append, preserve, and remove. The default is append.
	//
	// * If
	// the value is append, the Application Load Balancer adds the client IP address
	// (of the last hop) to the X-Forwarded-For header in the HTTP request before it
	// sends it to targets.
	//
	// * If the value is preserve the Application Load Balancer
	// preserves the X-Forwarded-For header in the HTTP request, and sends it to
	// targets without any change.
	//
	// * If the value is remove, the Application Load
	// Balancer removes the X-Forwarded-For header in the HTTP request before it sends
	// it to targets.
	//
	// * routing.http2.enabled - Indicates whether HTTP/2 is enabled.
	// The possible values are true and false. The default is true. Elastic Load
	// Balancing requires that message header names contain only alphanumeric
	// characters and hyphens.
	//
	// * waf.fail_open.enabled - Indicates whether to allow a
	// WAF-enabled load balancer to route requests to targets if it is unable to
	// forward the request to Amazon Web Services WAF. The possible values are true and
	// false. The default is false.
	//
	// The following attribute is supported by Network
	// Load Balancers and Gateway Load Balancers:
	//
	// * load_balancing.cross_zone.enabled
	// - Indicates whether cross-zone load balancing is enabled. The possible values
	// are true and false. The default is false.
	Key *string

	// The value of the attribute.
	Value *string

	noSmithyDocumentSerde
}

// Information about the state of the load balancer.
type LoadBalancerState struct {

	// The state code. The initial state of the load balancer is provisioning. After
	// the load balancer is fully set up and ready to route traffic, its state is
	// active. If load balancer is routing traffic but does not have the resources it
	// needs to scale, its state isactive_impaired. If the load balancer could not be
	// set up, its state is failed.
	Code LoadBalancerStateEnum

	// A description of the state.
	Reason *string

	noSmithyDocumentSerde
}

// The codes to use when checking for a successful response from a target. If the
// protocol version is gRPC, these are gRPC codes. Otherwise, these are HTTP codes.
type Matcher struct {

	// You can specify values between 0 and 99. You can specify multiple values (for
	// example, "0,1") or a range of values (for example, "0-5"). The default value is
	// 12.
	GrpcCode *string

	// For Application Load Balancers, you can specify values between 200 and 499, and
	// the default value is 200. You can specify multiple values (for example,
	// "200,202") or a range of values (for example, "200-299"). For Network Load
	// Balancers and Gateway Load Balancers, this must be "200–399". Note that when
	// using shorthand syntax, some values such as commas need to be escaped.
	HttpCode *string

	noSmithyDocumentSerde
}

// Information about a path pattern condition.
type PathPatternConditionConfig struct {

	// One or more path patterns to compare against the request URL. The maximum size
	// of each string is 128 characters. The comparison is case sensitive. The
	// following wildcard characters are supported: * (matches 0 or more characters)
	// and ? (matches exactly 1 character). If you specify multiple strings, the
	// condition is satisfied if one of them matches the request URL. The path pattern
	// is compared only to the path of the URL, not to its query string. To compare
	// against the query string, use QueryStringConditionConfig.
	Values []string

	noSmithyDocumentSerde
}

// Information about a query string condition. The query string component of a URI
// starts after the first '?' character and is terminated by either a '#' character
// or the end of the URI. A typical query string contains key/value pairs separated
// by '&' characters. The allowed characters are specified by RFC 3986. Any
// character can be percentage encoded.
type QueryStringConditionConfig struct {

	// One or more key/value pairs or values to find in the query string. The maximum
	// size of each string is 128 characters. The comparison is case insensitive. The
	// following wildcard characters are supported: * (matches 0 or more characters)
	// and ? (matches exactly 1 character). To search for a literal '*' or '?'
	// character in a query string, you must escape these characters in Values using a
	// '\' character. If you specify multiple key/value pairs or values, the condition
	// is satisfied if one of them is found in the query string.
	Values []QueryStringKeyValuePair

	noSmithyDocumentSerde
}

// Information about a key/value pair.
type QueryStringKeyValuePair struct {

	// The key. You can omit the key.
	Key *string

	// The value.
	Value *string

	noSmithyDocumentSerde
}

// Information about a redirect action. A URI consists of the following components:
// protocol://hostname:port/path?query. You must modify at least one of the
// following components to avoid a redirect loop: protocol, hostname, port, or
// path. Any components that you do not modify retain their original values. You
// can reuse URI components using the following reserved keywords:
//
// *
// #{protocol}
//
// * #{host}
//
// * #{port}
//
// * #{path} (the leading "/" is removed)
//
// *
// #{query}
//
// For example, you can change the path to "/new/#{path}", the hostname
// to "example.#{host}", or the query to "#{query}&value=xyz".
type RedirectActionConfig struct {

	// The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary
	// (HTTP 302).
	//
	// This member is required.
	StatusCode RedirectActionStatusCodeEnum

	// The hostname. This component is not percent-encoded. The hostname can contain
	// #{host}.
	Host *string

	// The absolute path, starting with the leading "/". This component is not
	// percent-encoded. The path can contain #{host}, #{path}, and #{port}.
	Path *string

	// The port. You can specify a value from 1 to 65535 or #{port}.
	Port *string

	// The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP
	// to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
	Protocol *string

	// The query parameters, URL-encoded when necessary, but not percent-encoded. Do
	// not include the leading "?", as it is automatically added. You can specify any
	// of the reserved keywords.
	Query *string

	noSmithyDocumentSerde
}

// Information about a rule.
type Rule struct {

	// The actions. Each rule must include exactly one of the following types of
	// actions: forward, redirect, or fixed-response, and it must be the last action to
	// be performed.
	Actions []Action

	// The conditions. Each rule can include zero or one of the following conditions:
	// http-request-method, host-header, path-pattern, and source-ip, and zero or more
	// of the following conditions: http-header and query-string.
	Conditions []RuleCondition

	// Indicates whether this is the default rule.
	IsDefault bool

	// The priority.
	Priority *string

	// The Amazon Resource Name (ARN) of the rule.
	RuleArn *string

	noSmithyDocumentSerde
}

// Information about a condition for a rule. Each rule can optionally include up to
// one of each of the following conditions: http-request-method, host-header,
// path-pattern, and source-ip. Each rule can also optionally include one or more
// of each of the following conditions: http-header and query-string. Note that the
// value for a condition cannot be empty.
type RuleCondition struct {

	// The field in the HTTP request. The following are the possible values:
	//
	// *
	// http-header
	//
	// * http-request-method
	//
	// * host-header
	//
	// * path-pattern
	//
	// *
	// query-string
	//
	// * source-ip
	Field *string

	// Information for a host header condition. Specify only when Field is host-header.
	HostHeaderConfig *HostHeaderConditionConfig

	// Information for an HTTP header condition. Specify only when Field is
	// http-header.
	HttpHeaderConfig *HttpHeaderConditionConfig

	// Information for an HTTP method condition. Specify only when Field is
	// http-request-method.
	HttpRequestMethodConfig *HttpRequestMethodConditionConfig

	// Information for a path pattern condition. Specify only when Field is
	// path-pattern.
	PathPatternConfig *PathPatternConditionConfig

	// Information for a query string condition. Specify only when Field is
	// query-string.
	QueryStringConfig *QueryStringConditionConfig

	// Information for a source IP condition. Specify only when Field is source-ip.
	SourceIpConfig *SourceIpConditionConfig

	// The condition value. Specify only when Field is host-header or path-pattern.
	// Alternatively, to specify multiple host names or multiple path patterns, use
	// HostHeaderConfig or PathPatternConfig. If Field is host-header and you are not
	// using HostHeaderConfig, you can specify a single host name (for example,
	// my.example.com) in Values. A host name is case insensitive, can be up to 128
	// characters in length, and can contain any of the following characters.
	//
	// * A-Z,
	// a-z, 0-9
	//
	// * - .
	//
	// * * (matches 0 or more characters)
	//
	// * ? (matches exactly 1
	// character)
	//
	// If Field is path-pattern and you are not using PathPatternConfig,
	// you can specify a single path pattern (for example, /img/*) in Values. A path
	// pattern is case-sensitive, can be up to 128 characters in length, and can
	// contain any of the following characters.
	//
	// * A-Z, a-z, 0-9
	//
	// * _ - . $ / ~ " ' @ :
	// +
	//
	// * & (using &)
	//
	// * * (matches 0 or more characters)
	//
	// * ? (matches exactly 1
	// character)
	Values []string

	noSmithyDocumentSerde
}

// Information about the priorities for the rules for a listener.
type RulePriorityPair struct {

	// The rule priority.
	Priority *int32

	// The Amazon Resource Name (ARN) of the rule.
	RuleArn *string

	noSmithyDocumentSerde
}

// Information about a source IP condition. You can use this condition to route
// based on the IP address of the source that connects to the load balancer. If a
// client is behind a proxy, this is the IP address of the proxy not the IP address
// of the client.
type SourceIpConditionConfig struct {

	// One or more source IP addresses, in CIDR format. You can use both IPv4 and IPv6
	// addresses. Wildcards are not supported. If you specify multiple addresses, the
	// condition is satisfied if the source IP address of the request matches one of
	// the CIDR blocks. This condition is not satisfied by the addresses in the
	// X-Forwarded-For header. To search for addresses in the X-Forwarded-For header,
	// use HttpHeaderConditionConfig.
	Values []string

	noSmithyDocumentSerde
}

// Information about a policy used for SSL negotiation.
type SslPolicy struct {

	// The ciphers.
	Ciphers []Cipher

	// The name of the policy.
	Name *string

	// The protocols.
	SslProtocols []string

	// The supported load balancers.
	SupportedLoadBalancerTypes []string

	noSmithyDocumentSerde
}

// Information about a subnet mapping.
type SubnetMapping struct {

	// [Network Load Balancers] The allocation ID of the Elastic IP address for an
	// internet-facing load balancer.
	AllocationId *string

	// [Network Load Balancers] The IPv6 address.
	IPv6Address *string

	// [Network Load Balancers] The private IPv4 address for an internal load balancer.
	PrivateIPv4Address *string

	// The ID of the subnet.
	SubnetId *string

	noSmithyDocumentSerde
}

// Information about a tag.
type Tag struct {

	// The key of the tag.
	//
	// This member is required.
	Key *string

	// The value of the tag.
	Value *string

	noSmithyDocumentSerde
}

// The tags associated with a resource.
type TagDescription struct {

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string

	// Information about the tags.
	Tags []Tag

	noSmithyDocumentSerde
}

// Information about a target.
type TargetDescription struct {

	// The ID of the target. If the target type of the target group is instance,
	// specify an instance ID. If the target type is ip, specify an IP address. If the
	// target type is lambda, specify the ARN of the Lambda function. If the target
	// type is alb, specify the ARN of the Application Load Balancer target.
	//
	// This member is required.
	Id *string

	// An Availability Zone or all. This determines whether the target receives traffic
	// from the load balancer nodes in the specified Availability Zone or from all
	// enabled Availability Zones for the load balancer. This parameter is not
	// supported if the target type of the target group is instance or alb. If the
	// target type is ip and the IP address is in a subnet of the VPC for the target
	// group, the Availability Zone is automatically detected and this parameter is
	// optional. If the IP address is outside the VPC, this parameter is required. With
	// an Application Load Balancer, if the target type is ip and the IP address is
	// outside the VPC for the target group, the only supported value is all. If the
	// target type is lambda, this parameter is optional and the only supported value
	// is all.
	AvailabilityZone *string

	// The port on which the target is listening. If the target group protocol is
	// GENEVE, the supported port is 6081. If the target type is alb, the targeted
	// Application Load Balancer must have at least one listener whose port matches the
	// target group port. Not used if the target is a Lambda function.
	Port *int32

	noSmithyDocumentSerde
}

// Information about a target group.
type TargetGroup struct {

	// Indicates whether health checks are enabled.
	HealthCheckEnabled *bool

	// The approximate amount of time, in seconds, between health checks of an
	// individual target.
	HealthCheckIntervalSeconds *int32

	// The destination for health checks on the targets.
	HealthCheckPath *string

	// The port to use to connect with the target.
	HealthCheckPort *string

	// The protocol to use to connect with the target. The GENEVE, TLS, UDP, and
	// TCP_UDP protocols are not supported for health checks.
	HealthCheckProtocol ProtocolEnum

	// The amount of time, in seconds, during which no response means a failed health
	// check.
	HealthCheckTimeoutSeconds *int32

	// The number of consecutive health checks successes required before considering an
	// unhealthy target healthy.
	HealthyThresholdCount *int32

	// The type of IP address used for this target group. The possible values are ipv4
	// and ipv6. This is an optional parameter. If not specified, the IP address type
	// defaults to ipv4.
	IpAddressType TargetGroupIpAddressTypeEnum

	// The Amazon Resource Names (ARN) of the load balancers that route traffic to this
	// target group.
	LoadBalancerArns []string

	// The HTTP or gRPC codes to use when checking for a successful response from a
	// target.
	Matcher *Matcher

	// The port on which the targets are listening. Not used if the target is a Lambda
	// function.
	Port *int32

	// The protocol to use for routing traffic to the targets.
	Protocol ProtocolEnum

	// [HTTP/HTTPS protocol] The protocol version. The possible values are GRPC, HTTP1,
	// and HTTP2.
	ProtocolVersion *string

	// The Amazon Resource Name (ARN) of the target group.
	TargetGroupArn *string

	// The name of the target group.
	TargetGroupName *string

	// The type of target that you must specify when registering targets with this
	// target group. The possible values are instance (register targets by instance
	// ID), ip (register targets by IP address), lambda (register a single Lambda
	// function as a target), or alb (register a single Application Load Balancer as a
	// target).
	TargetType TargetTypeEnum

	// The number of consecutive health check failures required before considering the
	// target unhealthy.
	UnhealthyThresholdCount *int32

	// The ID of the VPC for the targets.
	VpcId *string

	noSmithyDocumentSerde
}

// Information about a target group attribute.
type TargetGroupAttribute struct {

	// The name of the attribute. The following attribute is supported by all load
	// balancers:
	//
	// * deregistration_delay.timeout_seconds - The amount of time, in
	// seconds, for Elastic Load Balancing to wait before changing the state of a
	// deregistering target from draining to unused. The range is 0-3600 seconds. The
	// default value is 300 seconds. If the target is a Lambda function, this attribute
	// is not supported.
	//
	// The following attributes are supported by both Application
	// Load Balancers and Network Load Balancers:
	//
	// * stickiness.enabled - Indicates
	// whether sticky sessions are enabled. The value is true or false. The default is
	// false.
	//
	// * stickiness.type - The type of sticky sessions. The possible values are
	// lb_cookie and app_cookie for Application Load Balancers or source_ip for Network
	// Load Balancers.
	//
	// The following attributes are supported only if the load
	// balancer is an Application Load Balancer and the target is an instance or an IP
	// address:
	//
	// * load_balancing.algorithm.type - The load balancing algorithm
	// determines how the load balancer selects targets when routing requests. The
	// value is round_robin or least_outstanding_requests. The default is
	// round_robin.
	//
	// * slow_start.duration_seconds - The time period, in seconds,
	// during which a newly registered target receives an increasing share of the
	// traffic to the target group. After this time period ends, the target receives
	// its full share of traffic. The range is 30-900 seconds (15 minutes). The default
	// is 0 seconds (disabled).
	//
	// * stickiness.app_cookie.cookie_name - Indicates the
	// name of the application-based cookie. Names that start with the following
	// prefixes are not allowed: AWSALB, AWSALBAPP, and AWSALBTG; they're reserved for
	// use by the load balancer.
	//
	// * stickiness.app_cookie.duration_seconds - The time
	// period, in seconds, during which requests from a client should be routed to the
	// same target. After this time period expires, the application-based cookie is
	// considered stale. The range is 1 second to 1 week (604800 seconds). The default
	// value is 1 day (86400 seconds).
	//
	// * stickiness.lb_cookie.duration_seconds - The
	// time period, in seconds, during which requests from a client should be routed to
	// the same target. After this time period expires, the load balancer-generated
	// cookie is considered stale. The range is 1 second to 1 week (604800 seconds).
	// The default value is 1 day (86400 seconds).
	//
	// The following attribute is
	// supported only if the load balancer is an Application Load Balancer and the
	// target is a Lambda function:
	//
	// * lambda.multi_value_headers.enabled - Indicates
	// whether the request and response headers that are exchanged between the load
	// balancer and the Lambda function include arrays of values or strings. The value
	// is true or false. The default is false. If the value is false and the request
	// contains a duplicate header field name or query parameter key, the load balancer
	// uses the last value sent by the client.
	//
	// The following attributes are supported
	// only by Network Load Balancers:
	//
	// *
	// deregistration_delay.connection_termination.enabled - Indicates whether the load
	// balancer terminates connections at the end of the deregistration timeout. The
	// value is true or false. The default is false.
	//
	// * preserve_client_ip.enabled -
	// Indicates whether client IP preservation is enabled. The value is true or false.
	// The default is disabled if the target group type is IP address and the target
	// group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP
	// preservation cannot be disabled for UDP and TCP_UDP target groups.
	//
	// *
	// proxy_protocol_v2.enabled - Indicates whether Proxy Protocol version 2 is
	// enabled. The value is true or false. The default is false.
	Key *string

	// The value of the attribute.
	Value *string

	noSmithyDocumentSerde
}

// Information about the target group stickiness for a rule.
type TargetGroupStickinessConfig struct {

	// The time period, in seconds, during which requests from a client should be
	// routed to the same target group. The range is 1-604800 seconds (7 days).
	DurationSeconds *int32

	// Indicates whether target group stickiness is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Information about how traffic will be distributed between multiple target groups
// in a forward rule.
type TargetGroupTuple struct {

	// The Amazon Resource Name (ARN) of the target group.
	TargetGroupArn *string

	// The weight. The range is 0 to 999.
	Weight *int32

	noSmithyDocumentSerde
}

// Information about the current health of a target.
type TargetHealth struct {

	// A description of the target health that provides additional details. If the
	// state is healthy, a description is not provided.
	Description *string

	// The reason code. If the target state is healthy, a reason code is not provided.
	// If the target state is initial, the reason code can be one of the following
	// values:
	//
	// * Elb.RegistrationInProgress - The target is in the process of being
	// registered with the load balancer.
	//
	// * Elb.InitialHealthChecking - The load
	// balancer is still sending the target the minimum number of health checks
	// required to determine its health status.
	//
	// If the target state is unhealthy, the
	// reason code can be one of the following values:
	//
	// * Target.ResponseCodeMismatch -
	// The health checks did not return an expected HTTP code. Applies only to
	// Application Load Balancers and Gateway Load Balancers.
	//
	// * Target.Timeout - The
	// health check requests timed out. Applies only to Application Load Balancers and
	// Gateway Load Balancers.
	//
	// * Target.FailedHealthChecks - The load balancer
	// received an error while establishing a connection to the target or the target
	// response was malformed.
	//
	// * Elb.InternalError - The health checks failed due to
	// an internal error. Applies only to Application Load Balancers.
	//
	// If the target
	// state is unused, the reason code can be one of the following values:
	//
	// *
	// Target.NotRegistered - The target is not registered with the target group.
	//
	// *
	// Target.NotInUse - The target group is not used by any load balancer or the
	// target is in an Availability Zone that is not enabled for its load balancer.
	//
	// *
	// Target.InvalidState - The target is in the stopped or terminated state.
	//
	// *
	// Target.IpUnusable - The target IP address is reserved for use by a load
	// balancer.
	//
	// If the target state is draining, the reason code can be the following
	// value:
	//
	// * Target.DeregistrationInProgress - The target is in the process of
	// being deregistered and the deregistration delay period has not expired.
	//
	// If the
	// target state is unavailable, the reason code can be the following value:
	//
	// *
	// Target.HealthCheckDisabled - Health checks are disabled for the target group.
	// Applies only to Application Load Balancers.
	//
	// * Elb.InternalError - Target health
	// is unavailable due to an internal error. Applies only to Network Load Balancers.
	Reason TargetHealthReasonEnum

	// The state of the target.
	State TargetHealthStateEnum

	noSmithyDocumentSerde
}

// Information about the health of a target.
type TargetHealthDescription struct {

	// The port to use to connect with the target.
	HealthCheckPort *string

	// The description of the target.
	Target *TargetDescription

	// The health information for the target.
	TargetHealth *TargetHealth

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
