// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An activity that adds other attributes based on existing attributes in the
// message.
type AddAttributesActivity struct {

	// A list of 1-50 AttributeNameMapping objects that map an existing attribute to a
	// new attribute. The existing attributes remain in the message, so if you want to
	// remove the originals, use RemoveAttributeActivity.
	//
	// This member is required.
	Attributes map[string]string

	// The name of the addAttributes activity.
	//
	// This member is required.
	Name *string

	// The next activity in the pipeline.
	Next *string

	noSmithyDocumentSerde
}

// Contains informations about errors.
type BatchPutMessageErrorEntry struct {

	// The code associated with the error.
	ErrorCode *string

	// The message associated with the error.
	ErrorMessage *string

	// The ID of the message that caused the error. See the value corresponding to the
	// messageId key in the message object.
	MessageId *string

	noSmithyDocumentSerde
}

// A collection of data from an MQTT topic. Channels archive the raw, unprocessed
// messages before publishing the data to a pipeline.
type Channel struct {

	// The ARN of the channel.
	Arn *string

	// When the channel was created.
	CreationTime *time.Time

	// The last time when a new message arrived in the channel. IoT Analytics updates
	// this value at most once per minute for one channel. Hence, the
	// lastMessageArrivalTime value is an approximation. This feature only applies to
	// messages that arrived in the data store after October 23, 2020.
	LastMessageArrivalTime *time.Time

	// When the channel was last updated.
	LastUpdateTime *time.Time

	// The name of the channel.
	Name *string

	// How long, in days, message data is kept for the channel.
	RetentionPeriod *RetentionPeriod

	// The status of the channel.
	Status ChannelStatus

	// Where channel data is stored. You can choose one of serviceManagedS3 or
	// customerManagedS3 storage. If not specified, the default is serviceManagedS3.
	// You can't change this storage option after the channel is created.
	Storage *ChannelStorage

	noSmithyDocumentSerde
}

// The activity that determines the source of the messages to be processed.
type ChannelActivity struct {

	// The name of the channel from which the messages are processed.
	//
	// This member is required.
	ChannelName *string

	// The name of the channel activity.
	//
	// This member is required.
	Name *string

	// The next activity in the pipeline.
	Next *string

	noSmithyDocumentSerde
}

// Specifies one or more sets of channel messages.
type ChannelMessages struct {

	// Specifies one or more keys that identify the Amazon Simple Storage Service
	// (Amazon S3) objects that save your channel messages. You must use the full path
	// for the key. Example path: channel/mychannel/__dt=2020-02-29
	// 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz
	S3Paths []string

	noSmithyDocumentSerde
}

// Statistics information about the channel.
type ChannelStatistics struct {

	// The estimated size of the channel.
	Size *EstimatedResourceSize

	noSmithyDocumentSerde
}

// Where channel data is stored. You may choose one of serviceManagedS3,
// customerManagedS3 storage. If not specified, the default is serviceManagedS3.
// This can't be changed after creation of the channel.
type ChannelStorage struct {

	// Used to store channel data in an S3 bucket that you manage. If customer managed
	// storage is selected, the retentionPeriod parameter is ignored. You can't change
	// the choice of S3 storage after the data store is created.
	CustomerManagedS3 *CustomerManagedChannelS3Storage

	// Used to store channel data in an S3 bucket managed by IoT Analytics. You can't
	// change the choice of S3 storage after the data store is created.
	ServiceManagedS3 *ServiceManagedChannelS3Storage

	noSmithyDocumentSerde
}

// Where channel data is stored.
type ChannelStorageSummary struct {

	// Used to store channel data in an S3 bucket that you manage.
	CustomerManagedS3 *CustomerManagedChannelS3StorageSummary

	// Used to store channel data in an S3 bucket managed by IoT Analytics.
	ServiceManagedS3 *ServiceManagedChannelS3StorageSummary

	noSmithyDocumentSerde
}

// A summary of information about a channel.
type ChannelSummary struct {

	// The name of the channel.
	ChannelName *string

	// Where channel data is stored.
	ChannelStorage *ChannelStorageSummary

	// When the channel was created.
	CreationTime *time.Time

	// The last time when a new message arrived in the channel. IoT Analytics updates
	// this value at most once per minute for one channel. Hence, the
	// lastMessageArrivalTime value is an approximation. This feature only applies to
	// messages that arrived in the data store after October 23, 2020.
	LastMessageArrivalTime *time.Time

	// The last time the channel was updated.
	LastUpdateTime *time.Time

	// The status of the channel.
	Status ChannelStatus

	noSmithyDocumentSerde
}

// Contains information about a column that stores your data.
type Column struct {

	// The name of the column.
	//
	// This member is required.
	Name *string

	// The type of data. For more information about the supported data types, see
	// Common data types
	// (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html) in the
	// Glue Developer Guide.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// Information required to run the containerAction to produce dataset contents.
type ContainerDatasetAction struct {

	// The ARN of the role that gives permission to the system to access required
	// resources to run the containerAction. This includes, at minimum, permission to
	// retrieve the dataset contents that are the input to the containerized
	// application.
	//
	// This member is required.
	ExecutionRoleArn *string

	// The ARN of the Docker container stored in your account. The Docker container
	// contains an application and required support libraries and is used to generate
	// dataset contents.
	//
	// This member is required.
	Image *string

	// Configuration of the resource that executes the containerAction.
	//
	// This member is required.
	ResourceConfiguration *ResourceConfiguration

	// The values of variables used in the context of the execution of the
	// containerized application (basically, parameters passed to the application).
	// Each variable must have a name and a value given by one of stringValue,
	// datasetContentVersionValue, or outputFileUriValue.
	Variables []Variable

	noSmithyDocumentSerde
}

// Used to store channel data in an S3 bucket that you manage. If customer-managed
// storage is selected, the retentionPeriod parameter is ignored. You can't change
// the choice of S3 storage after the data store is created.
type CustomerManagedChannelS3Storage struct {

	// The name of the S3 bucket in which channel data is stored.
	//
	// This member is required.
	Bucket *string

	// The ARN of the role that grants IoT Analytics permission to interact with your
	// Amazon S3 resources.
	//
	// This member is required.
	RoleArn *string

	// (Optional) The prefix used to create the keys of the channel data objects. Each
	// object in an S3 bucket has a key that is its unique identifier in the bucket.
	// Each object in a bucket has exactly one key. The prefix must end with a forward
	// slash (/).
	KeyPrefix *string

	noSmithyDocumentSerde
}

// Used to store channel data in an S3 bucket that you manage.
type CustomerManagedChannelS3StorageSummary struct {

	// The name of the S3 bucket in which channel data is stored.
	Bucket *string

	// (Optional) The prefix used to create the keys of the channel data objects. Each
	// object in an S3 bucket has a key that is its unique identifier within the bucket
	// (each object in a bucket has exactly one key). The prefix must end with a
	// forward slash (/).
	KeyPrefix *string

	// The ARN of the role that grants IoT Analytics permission to interact with your
	// Amazon S3 resources.
	RoleArn *string

	noSmithyDocumentSerde
}

// S3-customer-managed; When you choose customer-managed storage, the
// retentionPeriod parameter is ignored. You can't change the choice of Amazon S3
// storage after your data store is created.
type CustomerManagedDatastoreS3Storage struct {

	// The name of the Amazon S3 bucket where your data is stored.
	//
	// This member is required.
	Bucket *string

	// The ARN of the role that grants IoT Analytics permission to interact with your
	// Amazon S3 resources.
	//
	// This member is required.
	RoleArn *string

	// (Optional) The prefix used to create the keys of the data store data objects.
	// Each object in an Amazon S3 bucket has a key that is its unique identifier in
	// the bucket. Each object in a bucket has exactly one key. The prefix must end
	// with a forward slash (/).
	KeyPrefix *string

	noSmithyDocumentSerde
}

// Contains information about the data store that you manage.
type CustomerManagedDatastoreS3StorageSummary struct {

	// The name of the Amazon S3 bucket where your data is stored.
	Bucket *string

	// (Optional) The prefix used to create the keys of the data store data objects.
	// Each object in an Amazon S3 bucket has a key that is its unique identifier in
	// the bucket. Each object in a bucket has exactly one key. The prefix must end
	// with a forward slash (/).
	KeyPrefix *string

	// The ARN of the role that grants IoT Analytics permission to interact with your
	// Amazon S3 resources.
	RoleArn *string

	noSmithyDocumentSerde
}

// Information about a dataset.
type Dataset struct {

	// The DatasetAction objects that automatically create the dataset contents.
	Actions []DatasetAction

	// The ARN of the dataset.
	Arn *string

	// When dataset contents are created they are delivered to destinations specified
	// here.
	ContentDeliveryRules []DatasetContentDeliveryRule

	// When the dataset was created.
	CreationTime *time.Time

	// The last time the dataset was updated.
	LastUpdateTime *time.Time

	// A list of data rules that send notifications to CloudWatch, when data arrives
	// late. To specify lateDataRules, the dataset must use a DeltaTimer
	// (https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html)
	// filter.
	LateDataRules []LateDataRule

	// The name of the dataset.
	Name *string

	// Optional. How long, in days, message data is kept for the dataset.
	RetentionPeriod *RetentionPeriod

	// The status of the dataset.
	Status DatasetStatus

	// The DatasetTrigger objects that specify when the dataset is automatically
	// updated.
	Triggers []DatasetTrigger

	// Optional. How many versions of dataset contents are kept. If not specified or
	// set to null, only the latest version plus the latest succeeded version (if they
	// are different) are kept for the time period specified by the retentionPeriod
	// parameter. For more information, see  Keeping Multiple Versions of IoT Analytics
	// datasets
	// (https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions)
	// in the IoT Analytics User Guide.
	VersioningConfiguration *VersioningConfiguration

	noSmithyDocumentSerde
}

// A DatasetAction object that specifies how dataset contents are automatically
// created.
type DatasetAction struct {

	// The name of the dataset action by which dataset contents are automatically
	// created.
	ActionName *string

	// Information that allows the system to run a containerized application to create
	// the dataset contents. The application must be in a Docker container along with
	// any required support libraries.
	ContainerAction *ContainerDatasetAction

	// An SqlQueryDatasetAction object that uses an SQL query to automatically create
	// dataset contents.
	QueryAction *SqlQueryDatasetAction

	noSmithyDocumentSerde
}

// Information about the action that automatically creates the dataset's contents.
type DatasetActionSummary struct {

	// The name of the action that automatically creates the dataset's contents.
	ActionName *string

	// The type of action by which the dataset's contents are automatically created.
	ActionType DatasetActionType

	noSmithyDocumentSerde
}

// The destination to which dataset contents are delivered.
type DatasetContentDeliveryDestination struct {

	// Configuration information for delivery of dataset contents to IoT Events.
	IotEventsDestinationConfiguration *IotEventsDestinationConfiguration

	// Configuration information for delivery of dataset contents to Amazon S3.
	S3DestinationConfiguration *S3DestinationConfiguration

	noSmithyDocumentSerde
}

// When dataset contents are created, they are delivered to destination specified
// here.
type DatasetContentDeliveryRule struct {

	// The destination to which dataset contents are delivered.
	//
	// This member is required.
	Destination *DatasetContentDeliveryDestination

	// The name of the dataset content delivery rules entry.
	EntryName *string

	noSmithyDocumentSerde
}

// The state of the dataset contents and the reason they are in this state.
type DatasetContentStatus struct {

	// The reason the dataset contents are in this state.
	Reason *string

	// The state of the dataset contents. Can be one of READY, CREATING, SUCCEEDED, or
	// FAILED.
	State DatasetContentState

	noSmithyDocumentSerde
}

// Summary information about dataset contents.
type DatasetContentSummary struct {

	// The time the dataset content status was updated to SUCCEEDED or FAILED.
	CompletionTime *time.Time

	// The actual time the creation of the dataset contents was started.
	CreationTime *time.Time

	// The time the creation of the dataset contents was scheduled to start.
	ScheduleTime *time.Time

	// The status of the dataset contents.
	Status *DatasetContentStatus

	// The version of the dataset contents.
	Version *string

	noSmithyDocumentSerde
}

// The dataset whose latest contents are used as input to the notebook or
// application.
type DatasetContentVersionValue struct {

	// The name of the dataset whose latest contents are used as input to the notebook
	// or application.
	//
	// This member is required.
	DatasetName *string

	noSmithyDocumentSerde
}

// The reference to a dataset entry.
type DatasetEntry struct {

	// The presigned URI of the dataset item.
	DataURI *string

	// The name of the dataset item.
	EntryName *string

	noSmithyDocumentSerde
}

// A summary of information about a dataset.
type DatasetSummary struct {

	// A list of DataActionSummary objects.
	Actions []DatasetActionSummary

	// The time the dataset was created.
	CreationTime *time.Time

	// The name of the dataset.
	DatasetName *string

	// The last time the dataset was updated.
	LastUpdateTime *time.Time

	// The status of the dataset.
	Status DatasetStatus

	// A list of triggers. A trigger causes dataset content to be populated at a
	// specified time interval or when another dataset is populated. The list of
	// triggers can be empty or contain up to five DataSetTrigger objects
	Triggers []DatasetTrigger

	noSmithyDocumentSerde
}

// The DatasetTrigger that specifies when the dataset is automatically updated.
type DatasetTrigger struct {

	// The dataset whose content creation triggers the creation of this dataset's
	// contents.
	Dataset *TriggeringDataset

	// The Schedule when the trigger is initiated.
	Schedule *Schedule

	noSmithyDocumentSerde
}

// Information about a data store.
type Datastore struct {

	// The ARN of the data store.
	Arn *string

	// When the data store was created.
	CreationTime *time.Time

	// Contains information about the partition dimensions in a data store.
	DatastorePartitions *DatastorePartitions

	// Contains the configuration information of file formats. IoT Analytics data
	// stores support JSON and Parquet (https://parquet.apache.org/). The default file
	// format is JSON. You can specify only one format. You can't change the file
	// format after you create the data store.
	FileFormatConfiguration *FileFormatConfiguration

	// The last time when a new message arrived in the data store. IoT Analytics
	// updates this value at most once per minute for Amazon Simple Storage Service one
	// data store. Hence, the lastMessageArrivalTime value is an approximation. This
	// feature only applies to messages that arrived in the data store after October
	// 23, 2020.
	LastMessageArrivalTime *time.Time

	// The last time the data store was updated.
	LastUpdateTime *time.Time

	// The name of the data store.
	Name *string

	// How long, in days, message data is kept for the data store. When
	// customerManagedS3 storage is selected, this parameter is ignored.
	RetentionPeriod *RetentionPeriod

	// The status of a data store: CREATING The data store is being created. ACTIVE The
	// data store has been created and can be used. DELETING The data store is being
	// deleted.
	Status DatastoreStatus

	// Where data in a data store is stored.. You can choose serviceManagedS3 storage,
	// customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default
	// is serviceManagedS3. You can't change the choice of Amazon S3 storage after your
	// data store is created.
	Storage DatastoreStorage

	noSmithyDocumentSerde
}

// The datastore activity that specifies where to store the processed data.
type DatastoreActivity struct {

	// The name of the data store where processed messages are stored.
	//
	// This member is required.
	DatastoreName *string

	// The name of the datastore activity.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
// You can't change the choice of Amazon S3 storage after your data store is
// created.
type DatastoreIotSiteWiseMultiLayerStorage struct {

	// Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
	//
	// This member is required.
	CustomerManagedS3Storage *IotSiteWiseCustomerManagedDatastoreS3Storage

	noSmithyDocumentSerde
}

// Contains information about the data store that you manage, which stores data
// used by IoT SiteWise.
type DatastoreIotSiteWiseMultiLayerStorageSummary struct {

	// Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
	CustomerManagedS3Storage *IotSiteWiseCustomerManagedDatastoreS3StorageSummary

	noSmithyDocumentSerde
}

// A single dimension to partition a data store. The dimension must be an
// AttributePartition or a TimestampPartition.
type DatastorePartition struct {

	// A partition dimension defined by an attributeName.
	AttributePartition *Partition

	// A partition dimension defined by a timestamp attribute.
	TimestampPartition *TimestampPartition

	noSmithyDocumentSerde
}

// Contains information about the partition dimensions in a data store.
type DatastorePartitions struct {

	// A list of partition dimensions in a data store.
	Partitions []DatastorePartition

	noSmithyDocumentSerde
}

// Statistical information about the data store.
type DatastoreStatistics struct {

	// The estimated size of the data store.
	Size *EstimatedResourceSize

	noSmithyDocumentSerde
}

// Where data in a data store is stored.. You can choose serviceManagedS3 storage,
// customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default
// is serviceManagedS3. You can't change the choice of Amazon S3 storage after your
// data store is created.
//
// The following types satisfy this interface:
//  DatastoreStorageMemberCustomerManagedS3
//  DatastoreStorageMemberIotSiteWiseMultiLayerStorage
//  DatastoreStorageMemberServiceManagedS3
type DatastoreStorage interface {
	isDatastoreStorage()
}

// S3-customer-managed; When you choose customer-managed storage, the
// retentionPeriod parameter is ignored. You can't change the choice of Amazon S3
// storage after your data store is created.
type DatastoreStorageMemberCustomerManagedS3 struct {
	Value CustomerManagedDatastoreS3Storage

	noSmithyDocumentSerde
}

func (*DatastoreStorageMemberCustomerManagedS3) isDatastoreStorage() {}

// Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
// You can't change the choice of Amazon S3 storage after your data store is
// created.
type DatastoreStorageMemberIotSiteWiseMultiLayerStorage struct {
	Value DatastoreIotSiteWiseMultiLayerStorage

	noSmithyDocumentSerde
}

func (*DatastoreStorageMemberIotSiteWiseMultiLayerStorage) isDatastoreStorage() {}

// Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't
// change the choice of Amazon S3 storage after your data store is created.
type DatastoreStorageMemberServiceManagedS3 struct {
	Value ServiceManagedDatastoreS3Storage

	noSmithyDocumentSerde
}

func (*DatastoreStorageMemberServiceManagedS3) isDatastoreStorage() {}

// Contains information about your data store.
type DatastoreStorageSummary struct {

	// Used to store data in an Amazon S3 bucket managed by IoT Analytics.
	CustomerManagedS3 *CustomerManagedDatastoreS3StorageSummary

	// Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
	IotSiteWiseMultiLayerStorage *DatastoreIotSiteWiseMultiLayerStorageSummary

	// Used to store data in an Amazon S3 bucket managed by IoT Analytics.
	ServiceManagedS3 *ServiceManagedDatastoreS3StorageSummary

	noSmithyDocumentSerde
}

// A summary of information about a data store.
type DatastoreSummary struct {

	// When the data store was created.
	CreationTime *time.Time

	// The name of the data store.
	DatastoreName *string

	// Contains information about the partition dimensions in a data store.
	DatastorePartitions *DatastorePartitions

	// Where data in a data store is stored.
	DatastoreStorage *DatastoreStorageSummary

	// The file format of the data in the data store.
	FileFormatType FileFormatType

	// The last time when a new message arrived in the data store. IoT Analytics
	// updates this value at most once per minute for Amazon Simple Storage Service one
	// data store. Hence, the lastMessageArrivalTime value is an approximation. This
	// feature only applies to messages that arrived in the data store after October
	// 23, 2020.
	LastMessageArrivalTime *time.Time

	// The last time the data store was updated.
	LastUpdateTime *time.Time

	// The status of the data store.
	Status DatastoreStatus

	noSmithyDocumentSerde
}

// Used to limit data to that which has arrived since the last execution of the
// action.
type DeltaTime struct {

	// The number of seconds of estimated in-flight lag time of message data. When you
	// create dataset contents using message data from a specified timeframe, some
	// message data might still be in flight when processing begins, and so do not
	// arrive in time to be processed. Use this field to make allowances for the in
	// flight time of your message data, so that data not processed from a previous
	// timeframe is included with the next timeframe. Otherwise, missed message data
	// would be excluded from processing during the next timeframe too, because its
	// timestamp places it within the previous timeframe.
	//
	// This member is required.
	OffsetSeconds *int32

	// An expression by which the time of the message data might be determined. This
	// can be the name of a timestamp field or a SQL expression that is used to derive
	// the time the message data was generated.
	//
	// This member is required.
	TimeExpression *string

	noSmithyDocumentSerde
}

// A structure that contains the configuration information of a delta time session
// window. DeltaTime
// (https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html)
// specifies a time interval. You can use DeltaTime to create dataset contents with
// data that has arrived in the data store since the last execution. For an example
// of DeltaTime, see  Creating a SQL dataset with a delta window (CLI)
// (https://docs.aws.amazon.com/iotanalytics/latest/userguide/automate-create-dataset.html#automate-example6)
// in the IoT Analytics User Guide.
type DeltaTimeSessionWindowConfiguration struct {

	// A time interval. You can use timeoutInMinutes so that IoT Analytics can batch up
	// late data notifications that have been generated since the last execution. IoT
	// Analytics sends one batch of notifications to Amazon CloudWatch Events at one
	// time. For more information about how to write a timestamp expression, see Date
	// and Time Functions and Operators
	// (https://prestodb.io/docs/0.172/functions/datetime.html), in the Presto 0.172
	// Documentation.
	//
	// This member is required.
	TimeoutInMinutes *int32

	noSmithyDocumentSerde
}

// An activity that adds data from the IoT device registry to your message.
type DeviceRegistryEnrichActivity struct {

	// The name of the attribute that is added to the message.
	//
	// This member is required.
	Attribute *string

	// The name of the deviceRegistryEnrich activity.
	//
	// This member is required.
	Name *string

	// The ARN of the role that allows access to the device's registry information.
	//
	// This member is required.
	RoleArn *string

	// The name of the IoT device whose registry information is added to the message.
	//
	// This member is required.
	ThingName *string

	// The next activity in the pipeline.
	Next *string

	noSmithyDocumentSerde
}

// An activity that adds information from the IoT Device Shadow service to a
// message.
type DeviceShadowEnrichActivity struct {

	// The name of the attribute that is added to the message.
	//
	// This member is required.
	Attribute *string

	// The name of the deviceShadowEnrich activity.
	//
	// This member is required.
	Name *string

	// The ARN of the role that allows access to the device's shadow.
	//
	// This member is required.
	RoleArn *string

	// The name of the IoT device whose shadow information is added to the message.
	//
	// This member is required.
	ThingName *string

	// The next activity in the pipeline.
	Next *string

	noSmithyDocumentSerde
}

// The estimated size of the resource.
type EstimatedResourceSize struct {

	// The time when the estimate of the size of the resource was made.
	EstimatedOn *time.Time

	// The estimated size of the resource, in bytes.
	EstimatedSizeInBytes *float64

	noSmithyDocumentSerde
}

// Contains the configuration information of file formats. IoT Analytics data
// stores support JSON and Parquet (https://parquet.apache.org/). The default file
// format is JSON. You can specify only one format. You can't change the file
// format after you create the data store.
type FileFormatConfiguration struct {

	// Contains the configuration information of the JSON format.
	JsonConfiguration *JsonConfiguration

	// Contains the configuration information of the Parquet format.
	ParquetConfiguration *ParquetConfiguration

	noSmithyDocumentSerde
}

// An activity that filters a message based on its attributes.
type FilterActivity struct {

	// An expression that looks like a SQL WHERE clause that must return a Boolean
	// value. Messages that satisfy the condition are passed to the next activity.
	//
	// This member is required.
	Filter *string

	// The name of the filter activity.
	//
	// This member is required.
	Name *string

	// The next activity in the pipeline.
	Next *string

	noSmithyDocumentSerde
}

// Configuration information for coordination with Glue, a fully managed extract,
// transform and load (ETL) service.
type GlueConfiguration struct {

	// The name of the database in your Glue Data Catalog in which the table is
	// located. An Glue Data Catalog database contains metadata tables.
	//
	// This member is required.
	DatabaseName *string

	// The name of the table in your Glue Data Catalog that is used to perform the ETL
	// operations. An Glue Data Catalog table contains partitioned data and
	// descriptions of data sources and targets.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// Configuration information for delivery of dataset contents to IoT Events.
type IotEventsDestinationConfiguration struct {

	// The name of the IoT Events input to which dataset contents are delivered.
	//
	// This member is required.
	InputName *string

	// The ARN of the role that grants IoT Analytics permission to deliver dataset
	// contents to an IoT Events input.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
// You can't change the choice of Amazon S3 storage after your data store is
// created.
type IotSiteWiseCustomerManagedDatastoreS3Storage struct {

	// The name of the Amazon S3 bucket where your data is stored.
	//
	// This member is required.
	Bucket *string

	// (Optional) The prefix used to create the keys of the data store data objects.
	// Each object in an Amazon S3 bucket has a key that is its unique identifier in
	// the bucket. Each object in a bucket has exactly one key. The prefix must end
	// with a forward slash (/).
	KeyPrefix *string

	noSmithyDocumentSerde
}

// Contains information about the data store that you manage, which stores data
// used by IoT SiteWise.
type IotSiteWiseCustomerManagedDatastoreS3StorageSummary struct {

	// The name of the Amazon S3 bucket where your data is stored.
	Bucket *string

	// (Optional) The prefix used to create the keys of the data store data objects.
	// Each object in an Amazon S3 bucket has a key that is its unique identifier in
	// the bucket. Each object in a bucket has exactly one key. The prefix must end
	// with a forward slash (/).
	KeyPrefix *string

	noSmithyDocumentSerde
}

// Contains the configuration information of the JSON format.
type JsonConfiguration struct {
	noSmithyDocumentSerde
}

// An activity that runs a Lambda function to modify the message.
type LambdaActivity struct {

	// The number of messages passed to the Lambda function for processing. The Lambda
	// function must be able to process all of these messages within five minutes,
	// which is the maximum timeout duration for Lambda functions.
	//
	// This member is required.
	BatchSize *int32

	// The name of the Lambda function that is run on the message.
	//
	// This member is required.
	LambdaName *string

	// The name of the lambda activity.
	//
	// This member is required.
	Name *string

	// The next activity in the pipeline.
	Next *string

	noSmithyDocumentSerde
}

// A structure that contains the name and configuration information of a late data
// rule.
type LateDataRule struct {

	// The information needed to configure the late data rule.
	//
	// This member is required.
	RuleConfiguration *LateDataRuleConfiguration

	// The name of the late data rule.
	RuleName *string

	noSmithyDocumentSerde
}

// The information needed to configure a delta time session window.
type LateDataRuleConfiguration struct {

	// The information needed to configure a delta time session window.
	DeltaTimeSessionWindowConfiguration *DeltaTimeSessionWindowConfiguration

	noSmithyDocumentSerde
}

// Information about logging options.
type LoggingOptions struct {

	// If true, logging is enabled for IoT Analytics.
	//
	// This member is required.
	Enabled bool

	// The logging level. Currently, only ERROR is supported.
	//
	// This member is required.
	Level LoggingLevel

	// The ARN of the role that grants permission to IoT Analytics to perform logging.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// An activity that computes an arithmetic expression using the message's
// attributes.
type MathActivity struct {

	// The name of the attribute that contains the result of the math operation.
	//
	// This member is required.
	Attribute *string

	// An expression that uses one or more existing attributes and must return an
	// integer value.
	//
	// This member is required.
	Math *string

	// The name of the math activity.
	//
	// This member is required.
	Name *string

	// The next activity in the pipeline.
	Next *string

	noSmithyDocumentSerde
}

// Information about a message.
type Message struct {

	// The ID you want to assign to the message. Each messageId must be unique within
	// each batch sent.
	//
	// This member is required.
	MessageId *string

	// The payload of the message. This can be a JSON string or a base64-encoded string
	// representing binary data, in which case you must decode it by means of a
	// pipeline activity.
	//
	// This member is required.
	Payload []byte

	noSmithyDocumentSerde
}

// The value of the variable as a structure that specifies an output file URI.
type OutputFileUriValue struct {

	// The URI of the location where dataset contents are stored, usually the URI of a
	// file in an S3 bucket.
	//
	// This member is required.
	FileName *string

	noSmithyDocumentSerde
}

// Contains the configuration information of the Parquet format.
type ParquetConfiguration struct {

	// Information needed to define a schema.
	SchemaDefinition *SchemaDefinition

	noSmithyDocumentSerde
}

// A partition dimension defined by an attribute.
type Partition struct {

	// The name of the attribute that defines a partition dimension.
	//
	// This member is required.
	AttributeName *string

	noSmithyDocumentSerde
}

// Contains information about a pipeline.
type Pipeline struct {

	// The activities that perform transformations on the messages.
	Activities []PipelineActivity

	// The ARN of the pipeline.
	Arn *string

	// When the pipeline was created.
	CreationTime *time.Time

	// The last time the pipeline was updated.
	LastUpdateTime *time.Time

	// The name of the pipeline.
	Name *string

	// A summary of information about the pipeline reprocessing.
	ReprocessingSummaries []ReprocessingSummary

	noSmithyDocumentSerde
}

// An activity that performs a transformation on a message.
type PipelineActivity struct {

	// Adds other attributes based on existing attributes in the message.
	AddAttributes *AddAttributesActivity

	// Determines the source of the messages to be processed.
	Channel *ChannelActivity

	// Specifies where to store the processed message data.
	Datastore *DatastoreActivity

	// Adds data from the IoT device registry to your message.
	DeviceRegistryEnrich *DeviceRegistryEnrichActivity

	// Adds information from the IoT Device Shadow service to a message.
	DeviceShadowEnrich *DeviceShadowEnrichActivity

	// Filters a message based on its attributes.
	Filter *FilterActivity

	// Runs a Lambda function to modify the message.
	Lambda *LambdaActivity

	// Computes an arithmetic expression using the message's attributes and adds it to
	// the message.
	Math *MathActivity

	// Removes attributes from a message.
	RemoveAttributes *RemoveAttributesActivity

	// Used to create a new message using only the specified attributes from the
	// original message.
	SelectAttributes *SelectAttributesActivity

	noSmithyDocumentSerde
}

// A summary of information about a pipeline.
type PipelineSummary struct {

	// When the pipeline was created.
	CreationTime *time.Time

	// When the pipeline was last updated.
	LastUpdateTime *time.Time

	// The name of the pipeline.
	PipelineName *string

	// A summary of information about the pipeline reprocessing.
	ReprocessingSummaries []ReprocessingSummary

	noSmithyDocumentSerde
}

// Information that is used to filter message data, to segregate it according to
// the timeframe in which it arrives.
type QueryFilter struct {

	// Used to limit data to that which has arrived since the last execution of the
	// action.
	DeltaTime *DeltaTime

	noSmithyDocumentSerde
}

// An activity that removes attributes from a message.
type RemoveAttributesActivity struct {

	// A list of 1-50 attributes to remove from the message.
	//
	// This member is required.
	Attributes []string

	// The name of the removeAttributes activity.
	//
	// This member is required.
	Name *string

	// The next activity in the pipeline.
	Next *string

	noSmithyDocumentSerde
}

// Information about pipeline reprocessing.
type ReprocessingSummary struct {

	// The time the pipeline reprocessing was created.
	CreationTime *time.Time

	// The reprocessingId returned by StartPipelineReprocessing.
	Id *string

	// The status of the pipeline reprocessing.
	Status ReprocessingStatus

	noSmithyDocumentSerde
}

// The configuration of the resource used to execute the containerAction.
type ResourceConfiguration struct {

	// The type of the compute resource used to execute the containerAction. Possible
	// values are: ACU_1 (vCPU=4, memory=16 GiB) or ACU_2 (vCPU=8, memory=32 GiB).
	//
	// This member is required.
	ComputeType ComputeType

	// The size, in GB, of the persistent storage available to the resource instance
	// used to execute the containerAction (min: 1, max: 50).
	//
	// This member is required.
	VolumeSizeInGB int32

	noSmithyDocumentSerde
}

// How long, in days, message data is kept.
type RetentionPeriod struct {

	// The number of days that message data is kept. The unlimited parameter must be
	// false.
	NumberOfDays *int32

	// If true, message data is kept indefinitely.
	Unlimited bool

	noSmithyDocumentSerde
}

// Configuration information for delivery of dataset contents to Amazon Simple
// Storage Service (Amazon S3).
type S3DestinationConfiguration struct {

	// The name of the S3 bucket to which dataset contents are delivered.
	//
	// This member is required.
	Bucket *string

	// The key of the dataset contents object in an S3 bucket. Each object has a key
	// that is a unique identifier. Each object has exactly one key. You can create a
	// unique key with the following options:
	//
	// * Use !{iotanalytics:scheduleTime} to
	// insert the time of a scheduled SQL query run.
	//
	// * Use !{iotanalytics:versionId}
	// to insert a unique hash that identifies a dataset content.
	//
	// * Use
	// !{iotanalytics:creationTime} to insert the creation time of a dataset
	// content.
	//
	// The following example creates a unique key for a CSV file:
	// dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv If
	// you don't use !{iotanalytics:versionId} to specify the key, you might get
	// duplicate keys. For example, you might have two dataset contents with the same
	// scheduleTime but different versionIds. This means that one dataset content
	// overwrites the other.
	//
	// This member is required.
	Key *string

	// The ARN of the role that grants IoT Analytics permission to interact with your
	// Amazon S3 and Glue resources.
	//
	// This member is required.
	RoleArn *string

	// Configuration information for coordination with Glue, a fully managed extract,
	// transform and load (ETL) service.
	GlueConfiguration *GlueConfiguration

	noSmithyDocumentSerde
}

// The schedule for when to trigger an update.
type Schedule struct {

	// The expression that defines when to trigger an update. For more information, see
	// Schedule Expressions for Rules
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html)
	// in the Amazon CloudWatch Events User Guide.
	Expression *string

	noSmithyDocumentSerde
}

// Information needed to define a schema.
type SchemaDefinition struct {

	// Specifies one or more columns that store your data. Each schema can have up to
	// 100 columns. Each column can have up to 100 nested types.
	Columns []Column

	noSmithyDocumentSerde
}

// Used to create a new message using only the specified attributes from the
// original message.
type SelectAttributesActivity struct {

	// A list of the attributes to select from the message.
	//
	// This member is required.
	Attributes []string

	// The name of the selectAttributes activity.
	//
	// This member is required.
	Name *string

	// The next activity in the pipeline.
	Next *string

	noSmithyDocumentSerde
}

// Used to store channel data in an S3 bucket managed by IoT Analytics. You can't
// change the choice of S3 storage after the data store is created.
type ServiceManagedChannelS3Storage struct {
	noSmithyDocumentSerde
}

// Used to store channel data in an S3 bucket managed by IoT Analytics.
type ServiceManagedChannelS3StorageSummary struct {
	noSmithyDocumentSerde
}

// Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't
// change the choice of Amazon S3 storage after your data store is created.
type ServiceManagedDatastoreS3Storage struct {
	noSmithyDocumentSerde
}

// Contains information about the data store that is managed by IoT Analytics.
type ServiceManagedDatastoreS3StorageSummary struct {
	noSmithyDocumentSerde
}

// The SQL query to modify the message.
type SqlQueryDatasetAction struct {

	// A SQL query string.
	//
	// This member is required.
	SqlQuery *string

	// Prefilters applied to message data.
	Filters []QueryFilter

	noSmithyDocumentSerde
}

// A set of key-value pairs that are used to manage the resource.
type Tag struct {

	// The tag's key.
	//
	// This member is required.
	Key *string

	// The tag's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A partition dimension defined by a timestamp attribute.
type TimestampPartition struct {

	// The attribute name of the partition defined by a timestamp.
	//
	// This member is required.
	AttributeName *string

	// The timestamp format of a partition defined by a timestamp. The default format
	// is seconds since epoch (January 1, 1970 at midnight UTC time).
	TimestampFormat *string

	noSmithyDocumentSerde
}

// Information about the dataset whose content generation triggers the new dataset
// content generation.
type TriggeringDataset struct {

	// The name of the dataset whose content generation triggers the new dataset
	// content generation.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// An instance of a variable to be passed to the containerAction execution. Each
// variable must have a name and a value given by one of stringValue,
// datasetContentVersionValue, or outputFileUriValue.
type Variable struct {

	// The name of the variable.
	//
	// This member is required.
	Name *string

	// The value of the variable as a structure that specifies a dataset content
	// version.
	DatasetContentVersionValue *DatasetContentVersionValue

	// The value of the variable as a double (numeric).
	DoubleValue float64

	// The value of the variable as a structure that specifies an output file URI.
	OutputFileUriValue *OutputFileUriValue

	// The value of the variable as a string.
	StringValue *string

	noSmithyDocumentSerde
}

// Information about the versioning of dataset contents.
type VersioningConfiguration struct {

	// How many versions of dataset contents are kept. The unlimited parameter must be
	// false.
	MaxVersions *int32

	// If true, unlimited versions of dataset contents are kept.
	Unlimited bool

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isDatastoreStorage() {}
