// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An LDAP attribute of an Active Directory computer account, in the form of a
// name:value pair.
type ActiveDirectoryComputerAttribute struct {

	// The name for the LDAP attribute.
	Name *string

	// The value for the LDAP attribute.
	Value *string

	noSmithyDocumentSerde
}

// The configuration for a Microsoft Active Directory (Microsoft AD) studio
// resource.
type ActiveDirectoryConfiguration struct {

	// A collection of custom attributes for an Active Directory computer.
	ComputerAttributes []ActiveDirectoryComputerAttribute

	// The directory ID of the Directory Service for Microsoft Active Directory to
	// access using this studio component.
	DirectoryId *string

	// The distinguished name (DN) and organizational unit (OU) of an Active Directory
	// computer.
	OrganizationalUnitDistinguishedName *string

	noSmithyDocumentSerde
}

// The configuration for a render farm that is associated with a studio resource.
type ComputeFarmConfiguration struct {

	// The name of an Active Directory user that is used on ComputeFarm worker
	// instances.
	ActiveDirectoryUser *string

	// The endpoint of the ComputeFarm that is accessed by the studio component
	// resource.
	Endpoint *string

	noSmithyDocumentSerde
}

// Represents a EULA resource.
type Eula struct {

	// The EULA content.
	Content *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time

	// The EULA ID.
	EulaId *string

	// The name for the EULA.
	Name *string

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The acceptance of a EULA, required to use Amazon-provided streaming images.
type EulaAcceptance struct {

	// The Unix epoch timestamp in seconds for when the EULA was accepted.
	AcceptedAt *time.Time

	// The ID of the person who accepted the EULA.
	AcceptedBy *string

	// The ID of the acceptee.
	AccepteeId *string

	// The EULA acceptance ID.
	EulaAcceptanceId *string

	// The EULA ID.
	EulaId *string

	noSmithyDocumentSerde
}

// A launch profile controls your artist workforce’s access to studio components,
// like compute farms, shared file systems, managed file systems, and license
// server configurations, as well as instance types and Amazon Machine Images
// (AMIs). Studio administrators create launch profiles in the Nimble Studio
// console. Artists can use their launch profiles to launch an instance from the
// Nimble Studio portal. Each user’s launch profile defines how they can launch a
// streaming session. By default, studio admins can use all launch profiles.
type LaunchProfile struct {

	// The ARN of the resource.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time

	// The user ID of the user that created the launch profile.
	CreatedBy *string

	// A human-readable description of the launch profile.
	Description *string

	// Unique identifiers for a collection of EC2 subnets.
	Ec2SubnetIds []string

	// The launch profile ID.
	LaunchProfileId *string

	// The version number of the protocol that is used by the launch profile. The only
	// valid version is "2021-03-31".
	LaunchProfileProtocolVersions []string

	// A friendly name for the launch profile.
	Name *string

	// The current state.
	State LaunchProfileState

	// The status code.
	StatusCode LaunchProfileStatusCode

	// The status message for the launch profile.
	StatusMessage *string

	// A configuration for a streaming session.
	StreamConfiguration *StreamConfiguration

	// Unique identifiers for a collection of studio components that can be used with
	// this launch profile.
	StudioComponentIds []string

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]string

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time

	// The user ID of the user that most recently updated the resource.
	UpdatedBy *string

	// The list of the latest validation results.
	ValidationResults []ValidationResult

	noSmithyDocumentSerde
}

// A Launch Profile Initialization contains information required for a workstation
// or server to connect to a launch profile. This includes scripts, endpoints,
// security groups, subnets, and other configuration.
type LaunchProfileInitialization struct {

	// A LaunchProfileInitializationActiveDirectory resource.
	ActiveDirectory *LaunchProfileInitializationActiveDirectory

	// The EC2 security groups that control access to the studio component.
	Ec2SecurityGroupIds []string

	// The launch profile ID.
	LaunchProfileId *string

	// The version number of the protocol that is used by the launch profile. The only
	// valid version is "2021-03-31".
	LaunchProfileProtocolVersion *string

	// The launch purpose.
	LaunchPurpose *string

	// The name for the launch profile.
	Name *string

	// The platform of the launch platform, either WINDOWS or LINUX.
	Platform LaunchProfilePlatform

	// The system initializtion scripts.
	SystemInitializationScripts []LaunchProfileInitializationScript

	// The user initializtion scripts.
	UserInitializationScripts []LaunchProfileInitializationScript

	noSmithyDocumentSerde
}

// The Launch Profile Initialization Active Directory contains information required
// for the launch profile to connect to the Active Directory.
type LaunchProfileInitializationActiveDirectory struct {

	// A collection of custom attributes for an Active Directory computer.
	ComputerAttributes []ActiveDirectoryComputerAttribute

	// The directory ID of the Directory Service for Microsoft Active Directory to
	// access using this launch profile.
	DirectoryId *string

	// The directory name.
	DirectoryName *string

	// The DNS IP address.
	DnsIpAddresses []string

	// The name for the organizational unit distinguished name.
	OrganizationalUnitDistinguishedName *string

	// The unique identifier for a studio component resource.
	StudioComponentId *string

	// The name for the studio component.
	StudioComponentName *string

	noSmithyDocumentSerde
}

// The Launch Profile Initialization Script is used when start streaming session
// runs.
type LaunchProfileInitializationScript struct {

	// An IAM role attached to a Studio Component that gives the studio component
	// access to AWS resources at anytime while the instance is running.
	RuntimeRoleArn *string

	// The initialization script.
	Script *string

	// An IAM role attached to Studio Component when the system initialization script
	// runs which give the studio component access to AWS resources when the system
	// initialization script runs.
	SecureInitializationRoleArn *string

	// The unique identifier for a studio component resource.
	StudioComponentId *string

	// The name for the studio component.
	StudioComponentName *string

	noSmithyDocumentSerde
}

// Launch profile membership enables your studio admins to delegate launch profile
// access to other studio users in the Nimble Studio portal without needing to
// write or maintain complex IAM policies. A launch profile member is a user
// association from your studio identity source who is granted permissions to a
// launch profile. A launch profile member (type USER) provides the following
// permissions to that launch profile:
//
// * GetLaunchProfile
//
// *
// GetLaunchProfileInitialization
//
// * GetLaunchProfileMembers
//
// *
// GetLaunchProfileMember
//
// * CreateStreamingSession
//
// * GetLaunchProfileDetails
type LaunchProfileMembership struct {

	// The ID of the identity store.
	IdentityStoreId *string

	// The persona.
	Persona LaunchProfilePersona

	// The principal ID.
	PrincipalId *string

	// The Active Directory Security Identifier for this user, if available.
	Sid *string

	noSmithyDocumentSerde
}

// The configuration for a license service that is associated with a studio
// resource.
type LicenseServiceConfiguration struct {

	// The endpoint of the license service that is accessed by the studio component
	// resource.
	Endpoint *string

	noSmithyDocumentSerde
}

// A new member that is added to a launch profile.
type NewLaunchProfileMember struct {

	// The persona.
	//
	// This member is required.
	Persona LaunchProfilePersona

	// The principal ID.
	//
	// This member is required.
	PrincipalId *string

	noSmithyDocumentSerde
}

// A new studio user's membership.
type NewStudioMember struct {

	// The persona.
	//
	// This member is required.
	Persona StudioPersona

	// The principal ID.
	//
	// This member is required.
	PrincipalId *string

	noSmithyDocumentSerde
}

// A parameter for a studio component script, in the form of a key:value pair.
type ScriptParameterKeyValue struct {

	// A script parameter key.
	Key *string

	// A script parameter value.
	Value *string

	noSmithyDocumentSerde
}

// The configuration for a shared file storage system that is associated with a
// studio resource.
type SharedFileSystemConfiguration struct {

	// The endpoint of the shared file system that is accessed by the studio component
	// resource.
	Endpoint *string

	// The unique identifier for a file system.
	FileSystemId *string

	// The mount location for a shared file system on a Linux virtual workstation.
	LinuxMountPoint *string

	// The name of the file share.
	ShareName *string

	// The mount location for a shared file system on a Windows virtual workstation.
	WindowsMountDrive *string

	noSmithyDocumentSerde
}

// A configuration for a streaming session.
type StreamConfiguration struct {

	// Enable or disable the use of the system clipboard to copy and paste between the
	// streaming session and streaming client.
	//
	// This member is required.
	ClipboardMode StreamingClipboardMode

	// The EC2 instance types that users can select from when launching a streaming
	// session with this launch profile.
	//
	// This member is required.
	Ec2InstanceTypes []StreamingInstanceType

	// The streaming images that users can select from when launching a streaming
	// session with this launch profile.
	//
	// This member is required.
	StreamingImageIds []string

	// The length of time, in minutes, that a streaming session can be active before it
	// is stopped or terminated. After this point, Nimble Studio automatically
	// terminates or stops the session. The default length of time is 690 minutes, and
	// the maximum length of time is 30 days.
	MaxSessionLengthInMinutes int32

	// Integer that determines if you can start and stop your sessions and how long a
	// session can stay in the STOPPED state. The default value is 0. The maximum value
	// is 5760. If the value is missing or set to 0, your sessions can’t be stopped. If
	// you then call StopStreamingSession, the session fails. If the time that a
	// session stays in the READY state exceeds the maxSessionLengthInMinutes value,
	// the session will automatically be terminated (instead of stopped). If the value
	// is set to a positive number, the session can be stopped. You can call
	// StopStreamingSession to stop sessions in the READY state. If the time that a
	// session stays in the READY state exceeds the maxSessionLengthInMinutes value,
	// the session will automatically be stopped (instead of terminated).
	MaxStoppedSessionLengthInMinutes int32

	// (Optional) The upload storage for a streaming session.
	SessionStorage *StreamConfigurationSessionStorage

	noSmithyDocumentSerde
}

// Configuration for streaming workstations created using this launch profile.
type StreamConfigurationCreate struct {

	// Enable or disable the use of the system clipboard to copy and paste between the
	// streaming session and streaming client.
	//
	// This member is required.
	ClipboardMode StreamingClipboardMode

	// The EC2 instance types that users can select from when launching a streaming
	// session with this launch profile.
	//
	// This member is required.
	Ec2InstanceTypes []StreamingInstanceType

	// The streaming images that users can select from when launching a streaming
	// session with this launch profile.
	//
	// This member is required.
	StreamingImageIds []string

	// The length of time, in minutes, that a streaming session can be active before it
	// is stopped or terminated. After this point, Nimble Studio automatically
	// terminates or stops the session. The default length of time is 690 minutes, and
	// the maximum length of time is 30 days.
	MaxSessionLengthInMinutes int32

	// Integer that determines if you can start and stop your sessions and how long a
	// session can stay in the STOPPED state. The default value is 0. The maximum value
	// is 5760. If the value is missing or set to 0, your sessions can’t be stopped. If
	// you then call StopStreamingSession, the session fails. If the time that a
	// session stays in the READY state exceeds the maxSessionLengthInMinutes value,
	// the session will automatically be terminated (instead of stopped). If the value
	// is set to a positive number, the session can be stopped. You can call
	// StopStreamingSession to stop sessions in the READY state. If the time that a
	// session stays in the READY state exceeds the maxSessionLengthInMinutes value,
	// the session will automatically be stopped (instead of terminated).
	MaxStoppedSessionLengthInMinutes int32

	// (Optional) The upload storage for a streaming workstation that is created using
	// this launch profile.
	SessionStorage *StreamConfigurationSessionStorage

	noSmithyDocumentSerde
}

// The configuration for a streaming session’s upload storage.
type StreamConfigurationSessionStorage struct {

	// Allows artists to upload files to their workstations. The only valid option is
	// UPLOAD.
	//
	// This member is required.
	Mode []StreamingSessionStorageMode

	// The configuration for the upload storage root of the streaming session.
	Root *StreamingSessionStorageRoot

	noSmithyDocumentSerde
}

// Represents a streaming image resource. Streaming images are used by studio users
// to select which operating system and software they want to use in a Nimble
// Studio streaming session. Amazon provides a number of streaming images that
// include popular 3rd-party software. You can create your own streaming images
// using an Amazon Elastic Compute Cloud (Amazon EC2) machine image that you create
// for this purpose. You can also include software that your users require.
type StreamingImage struct {

	// The ARN of the resource.
	Arn *string

	// A human-readable description of the streaming image.
	Description *string

	// The ID of an EC2 machine image with which to create the streaming image.
	Ec2ImageId *string

	// The encryption configuration.
	EncryptionConfiguration *StreamingImageEncryptionConfiguration

	// The list of EULAs that must be accepted before a Streaming Session can be
	// started using this streaming image.
	EulaIds []string

	// A friendly name for a streaming image resource.
	Name *string

	// The owner of the streaming image, either the studioId that contains the
	// streaming image, or 'amazon' for images that are provided by Amazon Nimble
	// Studio.
	Owner *string

	// The platform of the streaming image, either WINDOWS or LINUX.
	Platform *string

	// The current state.
	State StreamingImageState

	// The status code.
	StatusCode StreamingImageStatusCode

	// The status message for the streaming image.
	StatusMessage *string

	// The ID of the streaming image.
	StreamingImageId *string

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Specifies how a streaming image is encrypted.
type StreamingImageEncryptionConfiguration struct {

	// The type of KMS key that is used to encrypt studio data.
	//
	// This member is required.
	KeyType StreamingImageEncryptionConfigurationKeyType

	// The ARN for a KMS key that is used to encrypt studio data.
	KeyArn *string

	noSmithyDocumentSerde
}

// A streaming session is a virtual workstation created using a particular launch
// profile.
type StreamingSession struct {

	// The ARN of the resource.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time

	// The user ID of the user that created the streaming session.
	CreatedBy *string

	// The EC2 Instance type used for the streaming session.
	Ec2InstanceType *string

	// The ID of the launch profile used to control access from the streaming session.
	LaunchProfileId *string

	// The user ID of the user that owns the streaming session. The user that owns the
	// session will be logging into the session and interacting with the virtual
	// workstation.
	OwnedBy *string

	// The session ID.
	SessionId *string

	// The time the session entered START_IN_PROGRESS state.
	StartedAt *time.Time

	// The user ID of the user that started the streaming session.
	StartedBy *string

	// The current state.
	State StreamingSessionState

	// The status code.
	StatusCode StreamingSessionStatusCode

	// The status message for the streaming session.
	StatusMessage *string

	// The time the streaming session will automatically be stopped if the user doesn’t
	// stop the session themselves.
	StopAt *time.Time

	// The time the session entered STOP_IN_PROGRESS state.
	StoppedAt *time.Time

	// The user ID of the user that stopped the streaming session.
	StoppedBy *string

	// The ID of the streaming image.
	StreamingImageId *string

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]string

	// The time the streaming session will automatically terminate if not terminated by
	// the user.
	TerminateAt *time.Time

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time

	// The user ID of the user that most recently updated the resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The upload storage root location (folder) on streaming workstations where files
// are uploaded.
type StreamingSessionStorageRoot struct {

	// The folder path in Linux workstations where files are uploaded.
	Linux *string

	// The folder path in Windows workstations where files are uploaded.
	Windows *string

	noSmithyDocumentSerde
}

// A stream is an active connection to a streaming session, enabling a studio user
// to control the streaming session using a compatible client. Streaming session
// streams are compatible with the NICE DCV web client, included in the Nimble
// Studio portal, or the NICE DCV desktop client.
type StreamingSessionStream struct {

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time

	// The user ID of the user that created the streaming session stream.
	CreatedBy *string

	// The Unix epoch timestamp in seconds for when the resource expires.
	ExpiresAt *time.Time

	// The user ID of the user that owns the streaming session. The user that owns the
	// session will be logging into the session and interacting with the virtual
	// workstation.
	OwnedBy *string

	// The current state.
	State StreamingSessionStreamState

	// The streaming session stream status code.
	StatusCode StreamingSessionStreamStatusCode

	// The stream ID.
	StreamId *string

	// The URL to connect to this stream using the DCV client.
	Url *string

	noSmithyDocumentSerde
}

// Represents a studio resource. A studio is the core resource used with Nimble
// Studio. You must create a studio first, before any other resource type can be
// created. All other resources you create and manage in Nimble Studio are
// contained within a studio. When creating a studio, you must provides two IAM
// roles for use with the Nimble Studio portal. These roles are assumed by your
// users when they log in to the Nimble Studio portal via Amazon Web Services SSO
// and your identity source. The user role must have the
// AmazonNimbleStudio-StudioUser managed policy attached for the portal to function
// properly. The admin role must have the AmazonNimbleStudio-StudioAdmin managed
// policy attached for the portal to function properly. Your studio roles must
// trust the identity.nimble.amazonaws.com service principal to function properly.
type Studio struct {

	// The IAM role that studio admins assume when logging in to the Nimble Studio
	// portal.
	AdminRoleArn *string

	// The Amazon Resource Name (ARN) that is assigned to a studio resource and
	// uniquely identifies it. ARNs are unique across all Regions.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time

	// A friendly name for the studio.
	DisplayName *string

	// The Amazon Web Services Region where the studio resource is located.
	HomeRegion *string

	// The Amazon Web Services SSO application client ID used to integrate with Amazon
	// Web Services SSO to enable Amazon Web Services SSO users to log in to Nimble
	// Studio portal.
	SsoClientId *string

	// The current state of the studio resource.
	State StudioState

	// Status codes that provide additional detail on the studio state.
	StatusCode StudioStatusCode

	// Additional detail on the studio state.
	StatusMessage *string

	// Configuration of the encryption method that is used for the studio.
	StudioEncryptionConfiguration *StudioEncryptionConfiguration

	// The unique identifier for a studio resource. In Nimble Studio, all other
	// resources are contained in a studio resource.
	StudioId *string

	// The name of the studio, as included in the URL when accessing it in the Nimble
	// Studio portal.
	StudioName *string

	// The address of the web page for the studio.
	StudioUrl *string

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]string

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time

	// The IAM role that studio users assume when logging in to the Nimble Studio
	// portal.
	UserRoleArn *string

	noSmithyDocumentSerde
}

// A studio component represents a network resource to be used by a studio's users
// and workflows. A typical studio contains studio components for each of the
// following: render farm, Active Directory, licensing, and file system. Access to
// a studio component is managed by specifying security groups for the resource, as
// well as its endpoint. A studio component also has a set of initialization
// scripts that are returned by GetLaunchProfileInitialization. These
// initialization scripts run on streaming sessions when they start. They provide
// users with flexibility in controlling how the studio resources are configured on
// a streaming session.
type StudioComponent struct {

	// The ARN of the resource.
	Arn *string

	// The configuration of the studio component, based on component type.
	Configuration *StudioComponentConfiguration

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time

	// The user ID of the user that created the studio component.
	CreatedBy *string

	// A human-readable description for the studio component resource.
	Description *string

	// The EC2 security groups that control access to the studio component.
	Ec2SecurityGroupIds []string

	// Initialization scripts for studio components.
	InitializationScripts []StudioComponentInitializationScript

	// A friendly name for the studio component resource.
	Name *string

	// An IAM role attached to a Studio Component that gives the studio component
	// access to AWS resources at anytime while the instance is running.
	RuntimeRoleArn *string

	// Parameters for the studio component scripts.
	ScriptParameters []ScriptParameterKeyValue

	// An IAM role attached to Studio Component when the system initialization script
	// runs which give the studio component access to AWS resources when the system
	// initialization script runs.
	SecureInitializationRoleArn *string

	// The current state.
	State StudioComponentState

	// The status code.
	StatusCode StudioComponentStatusCode

	// The status message for the studio component.
	StatusMessage *string

	// The unique identifier for a studio component resource.
	StudioComponentId *string

	// The specific subtype of a studio component.
	Subtype StudioComponentSubtype

	// A collection of labels, in the form of key:value pairs, that apply to this
	// resource.
	Tags map[string]string

	// The type of the studio component.
	Type StudioComponentType

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time

	// The user ID of the user that most recently updated the resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The configuration of the studio component, based on component type.
type StudioComponentConfiguration struct {

	// The configuration for a Microsoft Active Directory (Microsoft AD) studio
	// resource.
	ActiveDirectoryConfiguration *ActiveDirectoryConfiguration

	// The configuration for a render farm that is associated with a studio resource.
	ComputeFarmConfiguration *ComputeFarmConfiguration

	// The configuration for a license service that is associated with a studio
	// resource.
	LicenseServiceConfiguration *LicenseServiceConfiguration

	// The configuration for a shared file storage system that is associated with a
	// studio resource.
	SharedFileSystemConfiguration *SharedFileSystemConfiguration

	noSmithyDocumentSerde
}

// Initialization scripts for studio components.
type StudioComponentInitializationScript struct {

	// The version number of the protocol that is used by the launch profile. The only
	// valid version is "2021-03-31".
	LaunchProfileProtocolVersion *string

	// The platform of the initialization script, either WINDOWS or LINUX.
	Platform LaunchProfilePlatform

	// The method to use when running the initialization script.
	RunContext StudioComponentInitializationScriptRunContext

	// The initialization script.
	Script *string

	noSmithyDocumentSerde
}

// The studio component's summary.
type StudioComponentSummary struct {

	// The Unix epoch timestamp in seconds for when the resource was created.
	CreatedAt *time.Time

	// The user ID of the user that created the studio component.
	CreatedBy *string

	// The description.
	Description *string

	// The name for the studio component.
	Name *string

	// The unique identifier for a studio component resource.
	StudioComponentId *string

	// The specific subtype of a studio component.
	Subtype StudioComponentSubtype

	// The type of the studio component.
	Type StudioComponentType

	// The Unix epoch timestamp in seconds for when the resource was updated.
	UpdatedAt *time.Time

	// The user ID of the user that most recently updated the resource.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// Configuration of the encryption method that is used for the studio.
type StudioEncryptionConfiguration struct {

	// The type of KMS key that is used to encrypt studio data.
	//
	// This member is required.
	KeyType StudioEncryptionConfigurationKeyType

	// The ARN for a KMS key that is used to encrypt studio data.
	KeyArn *string

	noSmithyDocumentSerde
}

// A studio member is an association of a user from your studio identity source to
// elevated permissions that they are granted in the studio. When you add a user to
// your studio using the Nimble Studio console, they are given access to the
// studio's AWS SSO application and are given access to log in to the Nimble Studio
// portal. These users have the permissions provided by the studio's user IAM role
// and do not appear in the studio membership collection. Only studio admins appear
// in studio membership. When you add a user to studio membership with the persona
// ADMIN, upon logging in to the Nimble Studio portal, they are granted permissions
// specified by the Studio's Admin IAM role.
type StudioMembership struct {

	// The ID of the identity store.
	IdentityStoreId *string

	// The persona.
	Persona StudioPersona

	// The principal ID.
	PrincipalId *string

	// The Active Directory Security Identifier for this user, if available.
	Sid *string

	noSmithyDocumentSerde
}

// The launch profile validation result.
type ValidationResult struct {

	// The current state.
	//
	// This member is required.
	State LaunchProfileValidationState

	// The status code. This will contain the failure reason if the state is
	// VALIDATION_FAILED.
	//
	// This member is required.
	StatusCode LaunchProfileValidationStatusCode

	// The status message for the validation result.
	//
	// This member is required.
	StatusMessage *string

	// The type of the validation result.
	//
	// This member is required.
	Type LaunchProfileValidationType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
