#!/usr/bin/python -u
# Copyright or Copr. INRIA/Scilab - Sylvestre LEDRU
#
# Sylvestre LEDRU - <sylvestre.ledru@inria.fr> <sylvestre@ledru.info>
# 
# This software is a computer program whose purpose is to generate C++ wrapper 
# for Java objects/methods.
# 
# This software is governed by the CeCILL  license under French law and
# abiding by the rules of distribution of free software.  You can  use, 
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info". 
# 
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability. 
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading,  using,  modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean  that it is complicated to manipulate,  and  that  also
# therefore means  that it is reserved for developers  and  experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or 
# data to be ensured and,  more generally, to use and operate it in the 
# same conditions as regards security. 
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
# 
# For more information, see the file COPYING

from datatypes.dataGiws import dataGiws
from datatypes.dataFactoryGiws import dataFactoryGiws

class parameterGiws(dataGiws):
	__name=""
	__type=""

	def __init__(self, name, type):

		myDataFactory=dataFactoryGiws()
		self.__type=myDataFactory.create(type)
		self.__name=name
		
#		if isinstance(type,dataGiws):
#			self.__type=type
#		else:
#		raise Exception("The type must be a dataGiws object")

	def getName(self):
		return self.__name

	def getType(self):
		return self.__type
	
	def __str__(self):
		return """%s %s, """ % (self.getType().getNativeType(), self.getName())
	
	def generateCXXHeader(self):
		""" Generate the profil of the parameter """
		str="""%s %s""" % (self.getType().getNativeType(), self.getName())
		if self.getType().isArray():
			if self.getType().getDimensionArray() == 1:
				str+=", int %sSize"%self.getName()
			else:
				str+=", int %sSize, int %sSizeCol"%(self.getName(),self.getName())
		return str
