    /**
  *********************************************************************
*************************************************************************
*** 
*** \file  GizmodShared.hpp
*** \brief GizmodShared class header
***
*****************************************
  *****************************************
    **/
  
/*
  
  Copyright (c) 2007, Tim Burrell
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and 
  limitations under the License. 
  
*/

#ifndef __GizmodShared_h
#define __GizmodShared_h

#if HAVE_CONFIG_H
#include "config.h"
#endif
	
#include <boost/thread/mutex.hpp>

//////////////////////////////////////////////////////////////////////////////
// Namespace
///////////////////////////////////////

namespace Gizmod {

//////////////////////////////////////////////////////////////////////////////
// Class Definition
///////////////////////////////////////

/**
 * \class GizmodShared
 * \brief Base class for Shared Gizmod data 
 */
class GizmodShared {
public:
	// public functions
	
	// construction / deconstruction
	GizmodShared();							///< Default Constructor
	virtual ~GizmodShared();					///< Destructor

protected:
	// protected functions
	
	// protected member variables
	
	// static protected member vars
	static boost::mutex		mMutexScript;			///< Mutex for the python script

private:
	// private functions
	
	// private member variables
};

//////////////////////////////////////////////////////////////////////////////

} // Gizmod namespace

#endif // __GizmodShared_h
