    /**
  *********************************************************************
*************************************************************************
*** 
*** \file  GizmoKeyDefs.hpp
*** \brief GizmoKeyDefs header
***
*****************************************
  *****************************************
    **/
  
/*
  
  Copyright (c) 2007, Tim Burrell
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and 
  limitations under the License. 
  
*/

#ifndef __GizmoKeyDefs_h
#define __GizmoKeyDefs_h

#if HAVE_CONFIG_H
#include "config.h"
#endif

//////////////////////////////////////////////////////////////////////////////
// Namespace
///////////////////////////////////////

namespace Gizmod {

//////////////////////////////////////////////////////////////////////////////
// Typedef, enum's
///////////////////////////////////////

/**
 * \enum  GizmoEventType
 * \brief These are the event types
**/
typedef enum {
	GIZMO_EV_SYN			= 0x00,
	GIZMO_EV_KEY			= 0x01,
	GIZMO_EV_REL			= 0x02,
	GIZMO_EV_ABS			= 0x03,
	GIZMO_EV_MSC			= 0x04,
	GIZMO_EV_SW			= 0x05,
	GIZMO_EV_LED			= 0x11,
	GIZMO_EV_SND			= 0x12,
	GIZMO_EV_REP			= 0x14,
	GIZMO_EV_FF			= 0x15,
	GIZMO_EV_PWR			= 0x16,
	GIZMO_EV_FF_STATUS		= 0x17,
	GIZMO_EV_MAX			= 0x1f
} GizmoEventType;

/**
 * \enum  GizmoMouseAxis
 * \brief Constants for the mouse axes
**/
typedef enum {
	GIZMO_MOUSE_AXIS_X		= 0x00,
	GIZMO_MOUSE_AXIS_Y		= 0x01,
	GIZMO_MOUSE_AXIS_Z		= 0x08,
} GizmoMouseAxis;

/**
 * \enum  GizmoKey
 * \brief These are the key definitions that devices emit
**/
typedef enum {
	GIZMO_KEY_RESERVED		= 0,
	GIZMO_KEY_ESC			= 1,
	GIZMO_KEY_1			= 2,
	GIZMO_KEY_2			= 3,
	GIZMO_KEY_3			= 4,
	GIZMO_KEY_4			= 5,
	GIZMO_KEY_5			= 6,
	GIZMO_KEY_6			= 7,
	GIZMO_KEY_7			= 8,
	GIZMO_KEY_8			= 9,
	GIZMO_KEY_9			= 10,
	GIZMO_KEY_0			= 11,
	GIZMO_KEY_MINUS			= 12,
	GIZMO_KEY_EQUAL			= 13,
	GIZMO_KEY_BACKSPACE		= 14,
	GIZMO_KEY_TAB			= 15,
	GIZMO_KEY_Q			= 16,
	GIZMO_KEY_W			= 17,
	GIZMO_KEY_E			= 18,
	GIZMO_KEY_R			= 19,
	GIZMO_KEY_T			= 20,
	GIZMO_KEY_Y			= 21,
	GIZMO_KEY_U			= 22,
	GIZMO_KEY_I			= 23,
	GIZMO_KEY_O			= 24,
	GIZMO_KEY_P			= 25,
	GIZMO_KEY_LEFTBRACE		= 26,
	GIZMO_KEY_RIGHTBRACE		= 27,
	GIZMO_KEY_ENTER			= 28,
	GIZMO_KEY_LEFTCTRL		= 29,
	GIZMO_KEY_A			= 30,
	GIZMO_KEY_S			= 31,
	GIZMO_KEY_D			= 32,
	GIZMO_KEY_F			= 33,
	GIZMO_KEY_G			= 34,
	GIZMO_KEY_H			= 35,
	GIZMO_KEY_J			= 36,
	GIZMO_KEY_K			= 37,
	GIZMO_KEY_L			= 38,
	GIZMO_KEY_SEMICOLON		= 39,
	GIZMO_KEY_APOSTROPHE		= 40,
	GIZMO_KEY_GRAVE			= 41,
	GIZMO_KEY_LEFTSHIFT		= 42,
	GIZMO_KEY_BACKSLASH		= 43,
	GIZMO_KEY_Z			= 44,
	GIZMO_KEY_X			= 45,
	GIZMO_KEY_C			= 46,
	GIZMO_KEY_V			= 47,
	GIZMO_KEY_B			= 48,
	GIZMO_KEY_N			= 49,
	GIZMO_KEY_M			= 50,
	GIZMO_KEY_COMMA			= 51,
	GIZMO_KEY_DOT			= 52,
	GIZMO_KEY_SLASH			= 53,
	GIZMO_KEY_RIGHTSHIFT		= 54,
	GIZMO_KEY_KPASTERISK		= 55,
	GIZMO_KEY_LEFTALT		= 56,
	GIZMO_KEY_SPACE			= 57,
	GIZMO_KEY_CAPSLOCK		= 58,
	GIZMO_KEY_F1			= 59,
	GIZMO_KEY_F2			= 60,
	GIZMO_KEY_F3			= 61,
	GIZMO_KEY_F4			= 62,
	GIZMO_KEY_F5			= 63,
	GIZMO_KEY_F6			= 64,
	GIZMO_KEY_F7			= 65,
	GIZMO_KEY_F8			= 66,
	GIZMO_KEY_F9			= 67,
	GIZMO_KEY_F10			= 68,
	GIZMO_KEY_NUMLOCK		= 69,
	GIZMO_KEY_SCROLLLOCK		= 70,
	GIZMO_KEY_KP7			= 71,
	GIZMO_KEY_KP8			= 72,
	GIZMO_KEY_KP9			= 73,
	GIZMO_KEY_KPMINUS		= 74,
	GIZMO_KEY_KP4			= 75,
	GIZMO_KEY_KP5			= 76,
	GIZMO_KEY_KP6			= 77,
	GIZMO_KEY_KPPLUS		= 78,
	GIZMO_KEY_KP1			= 79,
	GIZMO_KEY_KP2			= 80,
	GIZMO_KEY_KP3			= 81,
	GIZMO_KEY_KP0			= 82,
	GIZMO_KEY_KPDOT			= 83,
	GIZMO_KEY_ZENKAKUHANKAKU	= 85,
	GIZMO_KEY_102ND			= 86,
	GIZMO_KEY_F11			= 87,
	GIZMO_KEY_F12			= 88,
	GIZMO_KEY_RO			= 89,
	GIZMO_KEY_KATAKANA		= 90,
	GIZMO_KEY_HIRAGANA		= 91,
	GIZMO_KEY_HENKAN		= 92,
	GIZMO_KEY_KATAKANAHIRAGANA	= 93,
	GIZMO_KEY_MUHENKAN		= 94,
	GIZMO_KEY_KPJPCOMMA		= 95,
	GIZMO_KEY_KPENTER		= 96,
	GIZMO_KEY_RIGHTCTRL		= 97,
	GIZMO_KEY_KPSLASH		= 98,
	GIZMO_KEY_SYSRQ			= 99,
	GIZMO_KEY_RIGHTALT		= 100,
	GIZMO_KEY_LINEFEED		= 101,
	GIZMO_KEY_HOME			= 102,
	GIZMO_KEY_UP			= 103,
	GIZMO_KEY_PAGEUP		= 104,
	GIZMO_KEY_LEFT			= 105,
	GIZMO_KEY_RIGHT			= 106,
	GIZMO_KEY_END			= 107,
	GIZMO_KEY_DOWN			= 108,
	GIZMO_KEY_PAGEDOWN		= 109,
	GIZMO_KEY_INSERT		= 110,
	GIZMO_KEY_DELETE		= 111,
	GIZMO_KEY_MACRO			= 112,
	GIZMO_KEY_MUTE			= 113,
	GIZMO_KEY_VOLUMEDOWN		= 114,
	GIZMO_KEY_VOLUMEUP		= 115,
	GIZMO_KEY_POWER			= 116,
	GIZMO_KEY_KPEQUAL		= 117,
	GIZMO_KEY_KPPLUSMINUS		= 118,
	GIZMO_KEY_PAUSE			= 119,
	GIZMO_KEY_KPCOMMA		= 121,
	GIZMO_KEY_HANGEUL		= 122,
	GIZMO_KEY_HANJA			= 123,
	GIZMO_KEY_YEN			= 124,
	GIZMO_KEY_LEFTMETA		= 125,
	GIZMO_KEY_RIGHTMETA		= 126,
	GIZMO_KEY_COMPOSE		= 127,
	GIZMO_KEY_STOP			= 128,
	GIZMO_KEY_AGAIN			= 129,
	GIZMO_KEY_PROPS			= 130,
	GIZMO_KEY_UNDO			= 131,
	GIZMO_KEY_FRONT			= 132,
	GIZMO_KEY_COPY			= 133,
	GIZMO_KEY_OPEN			= 134,
	GIZMO_KEY_PASTE			= 135,
	GIZMO_KEY_FIND			= 136,
	GIZMO_KEY_CUT			= 137,
	GIZMO_KEY_HELP			= 138,
	GIZMO_KEY_MENU			= 139,
	GIZMO_KEY_CALC			= 140,
	GIZMO_KEY_SETUP			= 141,
	GIZMO_KEY_SLEEP			= 142,
	GIZMO_KEY_WAKEUP		= 143,
	GIZMO_KEY_FILE			= 144,
	GIZMO_KEY_SENDFILE		= 145,
	GIZMO_KEY_DELETEFILE		= 146,
	GIZMO_KEY_XFER			= 147,
	GIZMO_KEY_PROG1			= 148,
	GIZMO_KEY_PROG2			= 149,
	GIZMO_KEY_WWW			= 150,
	GIZMO_KEY_MSDOS			= 151,
	GIZMO_KEY_COFFEE		= 152,
	GIZMO_KEY_DIRECTION		= 153,
	GIZMO_KEY_CYCLEWINDOWS		= 154,
	GIZMO_KEY_MAIL			= 155,
	GIZMO_KEY_BOOKMARKS		= 156,
	GIZMO_KEY_COMPUTER		= 157,
	GIZMO_KEY_BACK			= 158,
	GIZMO_KEY_FORWARD		= 159,
	GIZMO_KEY_CLOSECD		= 160,
	GIZMO_KEY_EJECTCD		= 161,
	GIZMO_KEY_EJECTCLOSECD		= 162,
	GIZMO_KEY_NEXTSONG		= 163,
	GIZMO_KEY_PLAYPAUSE		= 164,
	GIZMO_KEY_PREVIOUSSONG		= 165,
	GIZMO_KEY_STOPCD		= 166,
	GIZMO_KEY_RECORD		= 167,
	GIZMO_KEY_REWIND		= 168,
	GIZMO_KEY_PHONE			= 169,
	GIZMO_KEY_ISO			= 170,
	GIZMO_KEY_CONFIG		= 171,
	GIZMO_KEY_HOMEPAGE		= 172,
	GIZMO_KEY_REFRESH		= 173,
	GIZMO_KEY_EXIT			= 174,
	GIZMO_KEY_MOVE			= 175,
	GIZMO_KEY_EDIT			= 176,
	GIZMO_KEY_SCROLLUP		= 177,
	GIZMO_KEY_SCROLLDOWN		= 178,
	GIZMO_KEY_KPLEFTPAREN		= 179,
	GIZMO_KEY_KPRIGHTPAREN		= 180,
	GIZMO_KEY_NEW			= 181,
	GIZMO_KEY_REDO			= 182,
	GIZMO_KEY_F13			= 183,
	GIZMO_KEY_F14			= 184,
	GIZMO_KEY_F15			= 185,
	GIZMO_KEY_F16			= 186,
	GIZMO_KEY_F17			= 187,
	GIZMO_KEY_F18			= 188,
	GIZMO_KEY_F19			= 189,
	GIZMO_KEY_F20			= 190,
	GIZMO_KEY_F21			= 191,
	GIZMO_KEY_F22			= 192,
	GIZMO_KEY_F23			= 193,
	GIZMO_KEY_F24			= 194,
	GIZMO_KEY_PLAYCD		= 200,
	GIZMO_KEY_PAUSECD		= 201,
	GIZMO_KEY_PROG3			= 202,
	GIZMO_KEY_PROG4			= 203,
	GIZMO_KEY_SUSPEND		= 205,
	GIZMO_KEY_CLOSE			= 206,
	GIZMO_KEY_PLAY			= 207,
	GIZMO_KEY_FASTFORWARD		= 208,
	GIZMO_KEY_BASSBOOST		= 209,
	GIZMO_KEY_PRINT			= 210,
	GIZMO_KEY_HP			= 211,
	GIZMO_KEY_CAMERA		= 212,
	GIZMO_KEY_SOUND			= 213,
	GIZMO_KEY_QUESTION		= 214,
	GIZMO_KEY_EMAIL			= 215,
	GIZMO_KEY_CHAT			= 216,
	GIZMO_KEY_SEARCH		= 217,
	GIZMO_KEY_CONNECT		= 218,
	GIZMO_KEY_FINANCE		= 219,
	GIZMO_KEY_SPORT			= 220,
	GIZMO_KEY_SHOP			= 221,
	GIZMO_KEY_ALTERASE		= 222,
	GIZMO_KEY_CANCEL		= 223,
	GIZMO_KEY_BRIGHTNESSDOWN	= 224,
	GIZMO_KEY_BRIGHTNESSUP		= 225,
	GIZMO_KEY_MEDIA			= 226,
	GIZMO_KEY_SWITCHVIDEOMODE	= 227,
	GIZMO_KEY_KBDILLUMTOGGLE	= 228,
	GIZMO_KEY_KBDILLUMDOWN		= 229,
	GIZMO_KEY_KBDILLUMUP		= 230,
	GIZMO_KEY_SEND			= 231,
	GIZMO_KEY_REPLY			= 232,
	GIZMO_KEY_FORWARDMAIL		= 233,
	GIZMO_KEY_SAVE			= 234,
	GIZMO_KEY_DOCUMENTS		= 235,
	GIZMO_KEY_BATTERY		= 236,
	GIZMO_KEY_BLUETOOTH		= 237,
	GIZMO_KEY_WLAN			= 238,
	GIZMO_KEY_UNKNOWN		= 240,
	GIZMO_BTN_MISC			= 0x100,
	GIZMO_BTN_0			= 0x100,
	GIZMO_BTN_1			= 0x101,
	GIZMO_BTN_2			= 0x102,
	GIZMO_BTN_3			= 0x103,
	GIZMO_BTN_4			= 0x104,
	GIZMO_BTN_5			= 0x105,
	GIZMO_BTN_6			= 0x106,
	GIZMO_BTN_7			= 0x107,
	GIZMO_BTN_8			= 0x108,
	GIZMO_BTN_9			= 0x109,
	GIZMO_BTN_MOUSE			= 0x110,
	GIZMO_BTN_LEFT			= 0x110,
	GIZMO_BTN_RIGHT			= 0x111,
	GIZMO_BTN_MIDDLE		= 0x112,
	GIZMO_BTN_SIDE			= 0x113,
	GIZMO_BTN_EXTRA			= 0x114,
	GIZMO_BTN_FORWARD		= 0x115,
	GIZMO_BTN_BACK			= 0x116,
	GIZMO_BTN_TASK			= 0x117,
	GIZMO_BTN_JOYSTICK		= 0x120,
	GIZMO_BTN_TRIGGER		= 0x120,
	GIZMO_BTN_THUMB			= 0x121,
	GIZMO_BTN_THUMB2		= 0x122,
	GIZMO_BTN_TOP			= 0x123,
	GIZMO_BTN_TOP2			= 0x124,
	GIZMO_BTN_PINKIE		= 0x125,
	GIZMO_BTN_BASE			= 0x126,
	GIZMO_BTN_BASE2			= 0x127,
	GIZMO_BTN_BASE3			= 0x128,
	GIZMO_BTN_BASE4			= 0x129,
	GIZMO_BTN_BASE5			= 0x12a,
	GIZMO_BTN_BASE6			= 0x12b,
	GIZMO_BTN_DEAD			= 0x12f,
	GIZMO_BTN_GAMEPAD		= 0x130,
	GIZMO_BTN_A			= 0x130,
	GIZMO_BTN_B			= 0x131,
	GIZMO_BTN_C			= 0x132,
	GIZMO_BTN_X			= 0x133,
	GIZMO_BTN_Y			= 0x134,
	GIZMO_BTN_Z			= 0x135,
	GIZMO_BTN_TL			= 0x136,
	GIZMO_BTN_TR			= 0x137,
	GIZMO_BTN_TL2			= 0x138,
	GIZMO_BTN_TR2			= 0x139,
	GIZMO_BTN_SELECT		= 0x13a,
	GIZMO_BTN_START			= 0x13b,
	GIZMO_BTN_MODE			= 0x13c,
	GIZMO_BTN_THUMBL		= 0x13d,
	GIZMO_BTN_THUMBR		= 0x13e,
	GIZMO_BTN_DIGI			= 0x140,
	GIZMO_BTN_TOOL_PEN		= 0x140,
	GIZMO_BTN_TOOL_RUBBER		= 0x141,
	GIZMO_BTN_TOOL_BRUSH		= 0x142,
	GIZMO_BTN_TOOL_PENCIL		= 0x143,
	GIZMO_BTN_TOOL_AIRBRUSH		= 0x144,
	GIZMO_BTN_TOOL_FINGER		= 0x145,
	GIZMO_BTN_TOOL_MOUSE		= 0x146,
	GIZMO_BTN_TOOL_LENS		= 0x147,
	GIZMO_BTN_TOUCH			= 0x14a,
	GIZMO_BTN_STYLUS		= 0x14b,
	GIZMO_BTN_STYLUS2		= 0x14c,
	GIZMO_BTN_TOOL_DOUBLETAP	= 0x14d,
	GIZMO_BTN_TOOL_TRIPLETAP	= 0x14e,
	GIZMO_BTN_WHEEL			= 0x150,
	GIZMO_BTN_GEAR_DOWN		= 0x150,
	GIZMO_BTN_GEAR_UP		= 0x151,
	GIZMO_KEY_OK			= 0x160,
	GIZMO_KEY_SELECT		= 0x161,
	GIZMO_KEY_GOTO			= 0x162,
	GIZMO_KEY_CLEAR			= 0x163,
	GIZMO_KEY_POWER2		= 0x164,
	GIZMO_KEY_OPTION		= 0x165,
	GIZMO_KEY_INFO			= 0x166,
	GIZMO_KEY_TIME			= 0x167,
	GIZMO_KEY_VENDOR		= 0x168,
	GIZMO_KEY_ARCHIVE		= 0x169,
	GIZMO_KEY_PROGRAM		= 0x16a,
	GIZMO_KEY_CHANNEL		= 0x16b,
	GIZMO_KEY_FAVORITES		= 0x16c,
	GIZMO_KEY_EPG			= 0x16d,
	GIZMO_KEY_PVR			= 0x16e,
	GIZMO_KEY_MHP			= 0x16f,
	GIZMO_KEY_LANGUAGE		= 0x170,
	GIZMO_KEY_TITLE			= 0x171,
	GIZMO_KEY_SUBTITLE		= 0x172,
	GIZMO_KEY_ANGLE			= 0x173,
	GIZMO_KEY_ZOOM			= 0x174,
	GIZMO_KEY_MODE			= 0x175,
	GIZMO_KEY_KEYBOARD		= 0x176,
	GIZMO_KEY_SCREEN		= 0x177,
	GIZMO_KEY_PC			= 0x178,
	GIZMO_KEY_TV			= 0x179,
	GIZMO_KEY_TV2			= 0x17a,
	GIZMO_KEY_VCR			= 0x17b,
	GIZMO_KEY_VCR2			= 0x17c,
	GIZMO_KEY_SAT			= 0x17d,
	GIZMO_KEY_SAT2			= 0x17e,
	GIZMO_KEY_CD			= 0x17f,
	GIZMO_KEY_TAPE			= 0x180,
	GIZMO_KEY_RADIO			= 0x181,
	GIZMO_KEY_TUNER			= 0x182,
	GIZMO_KEY_PLAYER		= 0x183,
	GIZMO_KEY_TEXT			= 0x184,
	GIZMO_KEY_DVD			= 0x185,
	GIZMO_KEY_AUX			= 0x186,
	GIZMO_KEY_MP3			= 0x187,
	GIZMO_KEY_AUDIO			= 0x188,
	GIZMO_KEY_VIDEO			= 0x189,
	GIZMO_KEY_DIRECTORY		= 0x18a,
	GIZMO_KEY_LIST			= 0x18b,
	GIZMO_KEY_MEMO			= 0x18c,
	GIZMO_KEY_CALENDAR		= 0x18d,
	GIZMO_KEY_RED			= 0x18e,
	GIZMO_KEY_GREEN			= 0x18f,
	GIZMO_KEY_YELLOW		= 0x190,
	GIZMO_KEY_BLUE			= 0x191,
	GIZMO_KEY_CHANNELUP		= 0x192,
	GIZMO_KEY_CHANNELDOWN		= 0x193,
	GIZMO_KEY_FIRST			= 0x194,
	GIZMO_KEY_LAST			= 0x195,
	GIZMO_KEY_AB			= 0x196,
	GIZMO_KEY_NEXT			= 0x197,
	GIZMO_KEY_RESTART		= 0x198,
	GIZMO_KEY_SLOW			= 0x199,
	GIZMO_KEY_SHUFFLE		= 0x19a,
	GIZMO_KEY_BREAK			= 0x19b,
	GIZMO_KEY_PREVIOUS		= 0x19c,
	GIZMO_KEY_DIGITS		= 0x19d,
	GIZMO_KEY_TEEN			= 0x19e,
	GIZMO_KEY_TWEN			= 0x19f,
	GIZMO_KEY_DEL_EOL		= 0x1c0,
	GIZMO_KEY_DEL_EOS		= 0x1c1,
	GIZMO_KEY_INS_LINE		= 0x1c2,
	GIZMO_KEY_DEL_LINE		= 0x1c3,
	GIZMO_KEY_FN			= 0x1d0,
	GIZMO_KEY_FN_ESC		= 0x1d1,
	GIZMO_KEY_FN_F1			= 0x1d2,
	GIZMO_KEY_FN_F2			= 0x1d3,
	GIZMO_KEY_FN_F3			= 0x1d4,
	GIZMO_KEY_FN_F4			= 0x1d5,
	GIZMO_KEY_FN_F5			= 0x1d6,
	GIZMO_KEY_FN_F6			= 0x1d7,
	GIZMO_KEY_FN_F7			= 0x1d8,
	GIZMO_KEY_FN_F8			= 0x1d9,
	GIZMO_KEY_FN_F9			= 0x1da,
	GIZMO_KEY_FN_F10		= 0x1db,
	GIZMO_KEY_FN_F11		= 0x1dc,
	GIZMO_KEY_FN_F12		= 0x1dd,
	GIZMO_KEY_FN_1			= 0x1de,
	GIZMO_KEY_FN_2			= 0x1df,
	GIZMO_KEY_FN_D			= 0x1e0,
	GIZMO_KEY_FN_E			= 0x1e1,
	GIZMO_KEY_FN_F			= 0x1e2,
	GIZMO_KEY_FN_S			= 0x1e3,
	GIZMO_KEY_FN_B			= 0x1e4,
	GIZMO_KEY_BRL_DOT1		= 0x1f1,
	GIZMO_KEY_BRL_DOT2		= 0x1f2,
	GIZMO_KEY_BRL_DOT3		= 0x1f3,
	GIZMO_KEY_BRL_DOT4		= 0x1f4,
	GIZMO_KEY_BRL_DOT5		= 0x1f5,
	GIZMO_KEY_BRL_DOT6		= 0x1f6,
	GIZMO_KEY_BRL_DOT7		= 0x1f7,
	GIZMO_KEY_BRL_DOT8		= 0x1f8,
	GIZMO_KEY_MAX			= 0x1ff
} GizmoKey;

//////////////////////////////////////////////////////////////////////////////

} // Gizmod namespace

#endif // __GizmoKeyDefs_h
