#ifndef __GKDIAL_H__
#define __GKDIAL_H__ 1

#include <pthread.h>

#include <glade/glade.h>
#include <gconf/gconf-client.h>

enum
{
  AUTH_NONE,
  AUTH_PAP,
  AUTH_CHAP,
  AUTH_CHAT
};

enum
{
  GKCONNECTION_ADDING,
  GKCONNECTION_EDITING,
  GKCONNECTION_REMOVING,
  GKCONNECTION_NONE
};

typedef struct _GkConnection GkConnection;

struct _GkConnection
{
  gchar *name;
  gchar *phone;
  gchar *user;
  gchar *password;

  gchar *auth_type;
};

typedef struct _GkDial GkDial;

struct _GkDial
{
  GladeXML *gui;

  /*
   * gkdial's meta stuff 
   */
  gboolean add_only;
  gboolean edit_only;
  gboolean remove_only;

  /*
   ** configuration **
   When adding new configuration options check check_changed_cb, 
   if it is a toggle button gkdial_conf_init and gkdial_conf_changed
   on prefs.c and gkdial_defaults_init and gkdial_connect_signals
   on main.c
   */
  gboolean mw_starts_hiden;	/* imply always show tray */
  gboolean always_tray;
  gboolean hide_dw_on_conn;
  gboolean quit_on_off;
  gdouble max_retries;

  GtkWidget *main_window;
  GtkWidget *main_image;
  GtkWidget *main_combo;

  /*
   * menu items 
   */
  GtkWidget *menu_new;
  GtkWidget *menu_quit;

  GtkWidget *menu_properties;
  GtkWidget *menu_preferences;

  GtkWidget *menu_about;

  /*
   * connection handling buttons 
   */
  GtkWidget *button_connect;
  GtkWidget *button_disconnect;

  /*
   * misc buttons 
   */
  /*
   * GtkWidget *button_prefs; 
   */

  /*
   * desktop tray 
   */
  GtkWidget *tray;
  GtkWidget *tray_icon;

  GtkWidget *menu_item_connect;
  GtkWidget *menu_item_disconnect;
  GtkWidget *menu_item_prefs;

  /*
   * icons used on the tray 
   */
  GdkPixbuf *pixbuf_ppp_none;
  GdkPixbuf *pixbuf_ppp_both;
  GdkPixbuf *pixbuf_ppp_in;
  GdkPixbuf *pixbuf_ppp_out;
  GdkPixbuf *pixbuf_ppp_off;
  GdkPixbuf *pixbuf_ppp_trying;

  /*
   * icons used on the details window 
   */
  GdkPixbuf *pixbuf_ppp_none_64;
  GdkPixbuf *pixbuf_ppp_both_64;
  GdkPixbuf *pixbuf_ppp_in_64;
  GdkPixbuf *pixbuf_ppp_out_64;
  GdkPixbuf *pixbuf_ppp_off_64;
  GdkPixbuf *pixbuf_ppp_trying_64;

  /*
   * details window 
   */
  GtkWidget *details_window;
  GtkWidget *image_details_ppp;
  GtkWidget *details_statusbar;

  /*
   * information 
   */
  GtkWidget *label_set_time;
  GtkWidget *label_set_in;
  GtkWidget *label_set_out;

  /*
   * preferences window 
   */
  GtkWidget *prefs_window;
  GtkWidget *button_prefs_close;

  /*
   * accounts 
   */
  GtkTreeView *prefs_peers_list;
  GtkTreeStore *prefs_peers_model;

  GtkWidget *button_peer_edit;
  GtkWidget *button_peer_add;
  GtkWidget *button_peer_remove;

  /*
   * connection properties 
   */
  GkConnection *connection;
  GkConnection *connection_backup;
  GtkWidget *connedit_window;

  GtkWidget *cp_button_cancel;
  GtkWidget *cp_button_save;

  /*
   * connection 
   */
  GtkWidget *cp_entry_conn_name;
  GtkWidget *cp_entry_phone;
  GtkWidget *cp_entry_user;
  GtkWidget *cp_entry_password;
  GtkWidget *cp_entry_auth;

  gint editing_status;

  /*
   * general 
   */
  GtkToggleButton *check_retry_when_dialing;
  GtkWidget *spinb_times_to_retry;

  GtkToggleButton *check_reconn_if_lost;

  GtkToggleButton *check_mw_starts_hiden;
  GtkToggleButton *check_quit_on_off;
  GtkToggleButton *check_hide_dw_on_conn;
  GtkToggleButton *check_always_tray;

  /*
   * metadata stuff 
   */
  GConfClient *conf_client;
  gchar *lock_file;
  int ip_socket;
  gboolean conf_locked;

  /*
   * connection status 
   */
  gint state;
  gint state_locked;
  guint status_state_id;

  gint num_retries;
  gint was_gkdial;
  gint first_time;

  pthread_t *connecting_thread;
  gchar *connected_to;
  gchar *command;
  gint return_code;

  /*
   * timeouts 
   */
  int check_timeout;
};

#endif
