#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <signal.h>
#include <errno.h>

#include <linux/if.h>
#include <linux/ppp_defs.h>
#include <linux/ppp.h>

#include <time.h>
#include <ctype.h>
#include <fcntl.h>

#include <gtk/gtk.h>

#include "defines.h"
#include "gkdial.h"

/*
 * This function was *stolen* from modemlights[1] applet and modified, it
 * is a better way to check wether we're connected or connecting and can
 * be used on getting some information...
 * 
 * [1] writen by John Ellis <johne@bellatlantic.net> and part of
 * gnome-applets 
 */
int
get_stats (GkDial * gkdial, int *in, int *out)
{
  struct ifreq ifreq;
  struct ppp_stats stats;
  char device_name[] = "ppp0";

  memset (&ifreq, 0, sizeof (ifreq));
  strncpy (ifreq.ifr_name, device_name, IFNAMSIZ);
  ifreq.ifr_ifru.ifru_data = (caddr_t) & stats;

#ifdef SIOCGPPPSTATS
  if (ioctl (gkdial->ip_socket, SIOCGPPPSTATS, (caddr_t) & ifreq) < 0)
#else
  if (TRUE)
#endif
    {
      /*
       * failure means ppp is not up 
       */
      *in = *out = 0;
      return FALSE;
    }
  else
    {
      *in = stats.p.ppp_ibytes;
      *out = stats.p.ppp_obytes;
      return TRUE;
    }

  return FALSE;
}

/*
 * This function also comes from modemlights_applet 
 */
int
get_connect_time (GkDial * gkdial, int recalc_start)
{
  static time_t start_time = (time_t) 0;
  struct stat st;

  if (recalc_start)
    {
      if (stat (gkdial->lock_file, &st) == 0)
	start_time = st.st_mtime;
      else
	start_time = (time_t) 0;
    }

  if (start_time != (time_t) 0)
    return (int) (time (0) - start_time);
  else
    return -1;
}

/*
 * updates connection time 
 */
void
update_ctime (GkDial * gkdial)
{
  gchar *text;
  int t;
  int h, m, s;

  t = get_connect_time (gkdial, FALSE);

  if (t != -1)
    {
      h = t / 3600;
      m = (t - (h * 3600)) / 60;
      s = (t - (h * 3600)) % 60;
    }
  else
    {
      h = m = s = 0;
    }

  text = g_strdup_printf (_("%.2d:%.2d:%.2d"), h, m, s);
  gtk_label_set_text (GTK_LABEL (gkdial->label_set_time), text);
  g_free (text);
}

void
set_in_out (int in, int out)
{
  /*
   * FIXME: This function sets the pixmaps for in/out at the earlier
   * gkdial window 
   */
}

void
update_bps (GkDial * gkdial, int in, int out)
{
  static int last_in = 0;
  static int last_out = 0;

  static int total_in = 0;
  static int total_out = 0;

  char unit = 'B';
  gchar *text;

  GdkPixbuf *pbuf, *pbuf64;

  if (gkdial->state == CONNECTED)
    {
      if ((in > 200) && (out > 200))
	{
	  pbuf = gkdial->pixbuf_ppp_both;
	  pbuf64 = gkdial->pixbuf_ppp_both_64;
	}
      else if (in > 200)
	{
	  pbuf = gkdial->pixbuf_ppp_in;
	  pbuf64 = gkdial->pixbuf_ppp_in_64;
	}
      else if (out > 200)
	{
	  pbuf = gkdial->pixbuf_ppp_out;
	  pbuf64 = gkdial->pixbuf_ppp_out_64;
	}
      else
	{
	  pbuf = gkdial->pixbuf_ppp_none;
	  pbuf64 = gkdial->pixbuf_ppp_none_64;
	}

      gtk_image_set_from_pixbuf (GTK_IMAGE (gkdial->tray_icon), pbuf);
      /*
       * sets the big image at the details window 
       */
      gtk_image_set_from_pixbuf (GTK_IMAGE (gkdial->image_details_ppp),
				 pbuf64);
    }

  last_in = in;
  last_out = out;

  total_in += in;
  total_out += out;

  if (in > 1024)
    {
      in = in / 1024;
      unit = 'K';
    }

  text = g_strdup_printf (_("%d %c/s"), in, unit);
  gtk_label_set_text (GTK_LABEL (gkdial->label_set_in), text);
  g_free (text);

  if (out > 1024)
    {
      out = out / 1024;
      unit = 'K';
    }
  else
    unit = 'B';

  text = g_strdup_printf (_("%d %c/s"), out, unit);
  gtk_label_set_text (GTK_LABEL (gkdial->label_set_out), text);
  g_free (text);

}

/*
 * stolen from modemlights applet, to check whether the connection is up
 * more reliabily 
 */
int
is_connected (GkDial * gkdial)
{
  FILE *f = 0;
  gchar buf[64];
  pid_t pid = -1;

  f = fopen (gkdial->lock_file, "r");

  if (!f)
    return FALSE;

  if (fgets (buf, sizeof (buf), f) == NULL)
    {
      fclose (f);
      return FALSE;
    }
  fclose (f);

  pid = (pid_t) strtol (buf, NULL, 10);
  if (pid < 1 || (kill (pid, 0) == -1 && errno != EPERM))
    return FALSE;

  return TRUE;
}
