function [mse,est] = match2(run,pat)
% match2(run, pat): match pattern pat to runs run 
% Return MSE

l = length(run);
if (l ~= length(pat))
	warning('Bad pattern length');
	mse = Inf;
	return
end

norm = run ./ pat;
est = mean(norm);
mse = mean(((norm - est) / est) .^ 2);
