// $Id: ChildParamList.cc,v 1.2 2002/07/11 09:57:04 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2002  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ChildParamList.hh"
#include "Configuration.hh"

const std::string ChildParamList::getProperty(const std::string &t,const std::string &def) const throw()
{  if (Configuration.glade2)
   {  FOR_EACH_CONST_TAG_OF(i,*tag,"property")
         if (i->getAttr("name")==t) 
            return i->Value();
      return def;
   }
   else return tag->getString(t,def);
}

bool ChildParamList::hasProperty(const std::string &t) const throw()
{  if (Configuration.glade2)
   {  FOR_EACH_CONST_TAG_OF(i,*tag,"property")
         if (i->getAttr("name")==t) 
            return true;
      return false;
   }
   else return tag->hasTag(t);
}
